/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerWarningDeleteMoveScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SwapMovePacket;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;

public class PokeCheckerMovesScreen
extends PokeCheckerScreen {
    private int selectedNumber = -1;
    private boolean move1 = true;
    private boolean move2 = false;
    private boolean move3 = false;
    private boolean move4 = false;

    PokeCheckerMovesScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    public PokeCheckerMovesScreen(PokemonStorage storage, StoragePosition position, @Nullable Screen parent) {
        super(storage, position, parent);
    }

    public void resetAll() {
        this.move1 = false;
        this.move2 = false;
        this.move3 = false;
        this.move4 = false;
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrix, int mouseX, int mouseY) {
        RenderSystem.normal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (!this.pokemon.isEgg()) {
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel()), (int)10, (int)-14, (int)0xFFFFFF);
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex()), (int)-30, (int)-14, (int)0xFFFFFF);
            Moveset moveset = this.pokemon.getMoveset();
            for (int i2 = 0; i2 < moveset.size(); ++i2) {
                if (this.pokemon.getMoveset().get(i2) == null) continue;
                PokeCheckerMovesScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)moveset.get(i2).getActualMove().getLocalizedName(), (int)130, (int)(-7 + i2 * 22), (int)0xFFFFFF);
                PokeCheckerMovesScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(this.pokemon.getMoveset().get((int)i2).pp + "/" + this.pokemon.getMoveset().get(i2).getMaxPP()), (int)193, (int)(-5 + i2 * 22), (int)0xFFFFFF);
                float x = moveset.get((int)i2).getActualMove().getAttackType().textureX;
                float y = moveset.get((int)i2).getActualMove().getAttackType().textureY;
                ScreenHelper.drawImageQuadUV(Resources.types, matrix, 62.0f, 22 * i2 - 13, 18.0f, 18.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        } else {
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???"), (int)10, (int)-14, (int)0xFFFFFF);
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???"), (int)-30, (int)-14, (int)0xFFFFFF);
        }
        PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.screenpokechecker.effects", (Object[])new Object[0]), (int)-10, (int)111, (int)0xFFFFFF);
        PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.battle.description", (Object[])new Object[0]), (int)107, (int)98, (int)0xFFFFFF);
        this.drawSelection(matrix, mouseX, mouseY);
        this.drawSelectedRectBin(matrix, mouseX, mouseY);
        this.drawMoveDescription(matrix);
        this.drawBasePokemonInfo(matrix);
        RenderSystem.disableBlend();
    }

    public void drawMoveDescription(MatrixStack matrix) {
        if (!this.pokemon.isEgg()) {
            if (this.move1 && this.pokemon.getMoveset().size() > 0) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(0));
            }
            if (this.move2 && this.pokemon.getMoveset().size() > 1) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(1));
            }
            if (this.move3 && this.pokemon.getMoveset().size() > 2) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(2));
            }
            if (this.move4 && this.pokemon.getMoveset().size() > 3) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(3));
            }
        }
    }

    public void switchMoves(int moveToChange2) {
        NetworkHelper.sendToServer(new SwapMovePacket(this.position, this.pokemon.getUUID(), this.selectedNumber, moveToChange2));
        this.selectedNumber = -1;
    }

    private void drawMoveInfo(MatrixStack matrix, Attack attack) {
        if (attack == null) {
            return;
        }
        PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.battle.power", (Object[])new Object[0]) + ":"), (int)-30, (int)128, (int)0xFFFFFF);
        PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.battle.accuracy", (Object[])new Object[0]) + ":"), (int)-30, (int)138, (int)0xFFFFFF);
        int bpExtra = 0;
        int acExtra = 0;
        if (attack.getActualMove().getBasePower() >= 100) {
            bpExtra = this.field_230706_i_.field_71466_p.func_78256_a("0");
        }
        if (attack.getActualMove().getAccuracy() >= 100) {
            acExtra = this.field_230706_i_.field_71466_p.func_78256_a("0");
        }
        if (attack.getActualMove().getBasePower() > 0) {
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)("" + attack.getActualMove().getBasePower()), (int)(30 - bpExtra), (int)128, (int)0xFFFFFF);
        } else {
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"--", (int)(30 - bpExtra), (int)128, (int)0xFFFFFF);
        }
        if (attack.getActualMove().getAccuracy() <= 0) {
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"--", (int)(30 - acExtra), (int)138, (int)0xFFFFFF);
        } else {
            PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)("" + attack.getActualMove().getAccuracy()), (int)(30 - acExtra), (int)138, (int)0xFFFFFF);
        }
        PokeCheckerMovesScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)attack.getActualMove().getAttackCategory().getLocalizedName(), (int)-30, (int)148, (int)0xFFFFFF);
        ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)("attack." + attack.getActualMove().getAttackName().replace(" ", "_").toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), 60, 113, 145, 0xFFFFFF);
    }

    public void drawSelection(MatrixStack matrix, int i, int i1) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryMoves);
        if (this.pokemon.getMoveset().size() > 0 && i > this.field_230708_k_ / 2 - 31 && i < this.field_230708_k_ / 2 + 123 && i1 > this.field_230709_l_ / 2 - 100 && i1 < this.field_230709_l_ / 2 - 76 || this.move1) {
            this.func_238474_b_(matrix, 58, -17, 1, 231, 153, 24);
            this.resetAll();
            this.move1 = true;
        }
        if (this.pokemon.getMoveset().size() > 1 && i > this.field_230708_k_ / 2 - 31 && i < this.field_230708_k_ / 2 + 123 && i1 > this.field_230709_l_ / 2 - 77 && i1 < this.field_230709_l_ / 2 - 53 || this.move2) {
            this.func_238474_b_(matrix, 58, 6, 1, 231, 153, 24);
            this.resetAll();
            this.move2 = true;
        }
        if (this.pokemon.getMoveset().size() > 2 && i > this.field_230708_k_ / 2 - 31 && i < this.field_230708_k_ / 2 + 123 && i1 > this.field_230709_l_ / 2 - 54 && i1 < this.field_230709_l_ / 2 - 31 || this.move3) {
            this.func_238474_b_(matrix, 58, 28, 1, 231, 153, 24);
            this.resetAll();
            this.move3 = true;
        }
        if (this.pokemon.getMoveset().size() > 3 && i > this.field_230708_k_ / 2 - 31 && i < this.field_230708_k_ / 2 + 123 && i1 > this.field_230709_l_ / 2 - 32 && i1 < this.field_230709_l_ / 2 - 9 || this.move4) {
            this.func_238474_b_(matrix, 58, 50, 1, 231, 153, 24);
            this.resetAll();
            this.move4 = true;
        }
        this.drawSelectedRect(matrix);
    }

    protected void drawSelectedRect(MatrixStack matrix) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryMoves);
        RenderSystem.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        if (this.selectedNumber == 0) {
            this.func_238474_b_(matrix, 58, -17, 1, 231, 153, 24);
        } else if (this.selectedNumber == 1) {
            this.func_238474_b_(matrix, 58, 6, 1, 231, 153, 24);
        } else if (this.selectedNumber == 2) {
            this.func_238474_b_(matrix, 58, 28, 1, 231, 153, 24);
        } else if (this.selectedNumber == 3) {
            this.func_238474_b_(matrix, 58, 50, 1, 231, 153, 24);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawSelectedRectBin(MatrixStack matrix, int i, int i1) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryMoves);
        RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.selectedNumber >= this.pokemon.getMoveset().size() && i > this.field_230708_k_ / 2 + 130 && i < this.field_230708_k_ / 2 + 158 && i1 > this.field_230709_l_ / 2 - 25 && i1 < this.field_230709_l_ / 2 + 9) {
            this.func_238474_b_(matrix, 220, 60, 230, 225, 26, 31);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int moveClicked(double i, double i1) {
        if (this.pokemon.isEgg()) {
            return -1;
        }
        if (this.pokemon.getMoveset().size() > 0 && i > (double)((float)this.field_230708_k_ / 2.0f - 31.0f) && i < (double)((float)this.field_230708_k_ / 2.0f + 123.0f) && i1 > (double)((float)this.field_230709_l_ / 2.0f - 100.0f) && i1 < (double)((float)this.field_230709_l_ / 2.0f - 76.0f)) {
            return 0;
        }
        if (this.pokemon.getMoveset().size() > 1 && i > (double)((float)this.field_230708_k_ / 2.0f - 31.0f) && i < (double)((float)this.field_230708_k_ / 2.0f + 123.0f) && i1 > (double)((float)this.field_230709_l_ / 2.0f - 77.0f) && i1 < (double)((float)this.field_230709_l_ / 2.0f - 53.0f)) {
            return 1;
        }
        if (this.pokemon.getMoveset().size() > 2 && i > (double)((float)this.field_230708_k_ / 2.0f - 31.0f) && i < (double)((float)this.field_230708_k_ / 2.0f + 123.0f) && i1 > (double)((float)this.field_230709_l_ / 2.0f - 54.0f) && i1 < (double)((float)this.field_230709_l_ / 2.0f - 31.0f)) {
            return 2;
        }
        if (this.pokemon.getMoveset().size() > 3 && i > (double)((float)this.field_230708_k_ / 2.0f - 31.0f) && i < (double)((float)this.field_230708_k_ / 2.0f + 123.0f) && i1 > (double)((float)this.field_230709_l_ / 2.0f - 32.0f) && i1 < (double)((float)this.field_230709_l_ / 2.0f - 9.0f)) {
            return 3;
        }
        return -1;
    }

    protected void attackClicked(double i, double i1) {
    }

    protected void selectMove(double i, double i1) {
        if (i > (double)(this.field_230708_k_ / 2 - 31) && i < (double)(this.field_230708_k_ / 2 + 123) && i1 > (double)(this.field_230709_l_ / 2 - 100) && i1 < (double)(this.field_230709_l_ / 2 - 9) && this.selectedNumber != this.moveClicked(i, i1)) {
            if (this.selectedNumber == -1) {
                this.selectedNumber = this.moveClicked(i, i1);
            } else if (this.moveClicked(i, i1) != -1) {
                this.switchMoves(this.moveClicked(i, i1));
            }
        } else {
            this.selectedNumber = -1;
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.canDeleteMove() && this.selectedNumber >= 0 && mouseX > (double)((float)this.field_230708_k_ / 2.0f + 130.0f) && mouseX < (double)((float)this.field_230708_k_ / 2.0f + 158.0f) && mouseY > (double)((float)this.field_230709_l_ / 2.0f - 25.0f) && mouseY < (double)((float)this.field_230709_l_ / 2.0f + 9.0f)) {
            this.field_230706_i_.func_147108_a((Screen)new PokeCheckerWarningDeleteMoveScreen(this, this.pokemon, this.selectedNumber));
        }
        if (!this.pokemon.isEgg()) {
            this.attackClicked(mouseX, mouseY);
            this.selectMove(mouseX, mouseY);
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private boolean canDeleteMove() {
        return this.pokemon.getMoveset().size() > 1;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryMoves);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 - 40, (this.field_230709_l_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        if (this.selectedNumber >= 0 && this.canDeleteMove()) {
            this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 + 220, (this.field_230709_l_ - this.ySize) / 2 + 60, 203, 225, 26, 31);
        }
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }
}

