/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PartyEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorIndividualScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.RandomizePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.RequestCloseEditedPlayerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemonPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PokemonEditorPartyScreen
extends PartyEditorBaseScreen {
    public static UUID editedPlayerUUID;
    public static String editedPlayerName;

    public PokemonEditorPartyScreen() {
        super(ServerStorageDisplay.editedPokemon);
    }

    @Override
    public ITextComponent func_231171_q_() {
        return new TranslationTextComponent("gui.pokemoneditor.title");
    }

    @Override
    protected void exitScreen() {
        if (!Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(editedPlayerUUID)) {
            NetworkHelper.sendToServer(new RequestCloseEditedPlayerPacket(editedPlayerUUID));
        }
        this.field_230706_i_.field_71439_g.func_71053_j();
    }

    @Override
    protected void randomizeParty() {
        NetworkHelper.sendToServer(new RandomizePokemonPacket(editedPlayerUUID));
    }

    @Override
    protected void addPokemon(int partySlot) {
        NetworkHelper.sendToServer(new ChangePokemonPacket(UUID.randomUUID(), PixelmonSpecies.MAGIKARP.getValueUnsafe()));
    }

    @Override
    protected void editPokemon(int partySlot) {
        Pokemon pokemon = (Pokemon)this.pokemonList.get(partySlot);
        if (pokemon != null) {
            this.field_230706_i_.func_147108_a((Screen)new PokemonEditorIndividualScreen(pokemon, this.func_231171_q_()));
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int i, int j, float f) {
        super.func_230430_a_(matrix, i, j, f);
        this.pokemonList = Lists.newArrayList(ServerStorageDisplay.editedPokemon);
    }

    @Override
    protected void updatePokemon(Pokemon pokemon) {
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(pokemon));
    }

    @Override
    protected void updatePokemon(Pokemon pokemon, int slot) {
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(pokemon, slot));
    }
}

