/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.raids;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidButton;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.RaidActionPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.items.ItemData;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RaidCatchScreen
extends Screen {
    private static final ResourceLocation WATERMARK = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/watermark.png");
    private static final ResourceLocation STAR = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/star.png");
    private static final ResourceLocation SHINY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/shiny.png");
    private final List<RaidButton> buttons = Lists.newArrayList();
    private RaidData raid;
    private PixelmonEntity pixelmon;
    private boolean shiny;
    private ItemStack[] drops;
    private List<ItemData> balls;
    private boolean canCatch;
    private boolean sentToPC;
    private boolean catchSuccess = false;
    private boolean pcFull = false;
    private boolean inCatchAnimation = false;
    private int shakes = 0;
    private int ticker = 0;
    private int delay = -1;
    private boolean shakeSound = false;
    private boolean shouldRefresh = false;
    private int ballIndex = 0;
    private int scrollIndex = 0;
    private boolean closing = false;
    protected ScreenParticleEngine particleEngine = new ScreenParticleEngine();
    private boolean scrolling = false;
    private boolean click = false;
    private long lastTime = -1L;

    public RaidCatchScreen(RaidData raid, boolean shiny, ItemStack[] drops, List<ItemData> pokeballs, boolean canCatch) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_ = Minecraft.func_71410_x();
        SoundHelper.playSound(SoundEvents.field_194228_if, 0.5f, 1.0f);
        this.drops = drops;
        this.canCatch = canCatch;
        this.balls = this.canCatch ? pokeballs : Lists.newArrayList();
        this.shiny = shiny;
        this.setRaid(raid);
    }

    public void setRaid(RaidData raid) {
        this.setRaid(raid, null);
    }

    public void setRaid(RaidData raid, RaidCatchScreen old) {
        this.raid = raid;
        if (old != null) {
            this.pixelmon = old.pixelmon;
        } else {
            Pokemon pokemon = PokemonFactory.create(raid.getSpecies());
            if (raid.getForm() != null) {
                pokemon.setForm(raid.getForm());
            }
            pokemon.setGrowth(EnumGrowth.Ordinary);
            pokemon.setShiny(this.shiny);
            this.pixelmon = new PixelmonEntity((World)this.field_230706_i_.field_71441_e, pokemon);
            this.pixelmon.setAnimation(AnimationType.IDLE);
            this.pixelmon.checkAnimation();
            this.pixelmon.initAnimation();
        }
        this.shouldRefresh = true;
    }

    public void setShakes(int shakes, boolean sentToPC) {
        if (!this.inCatchAnimation && this.canCatch) {
            if (shakes < 0) {
                this.pcFull = true;
            } else {
                SoundHelper.playSound((SoundEvent)SoundRegistration.POKEBALL_CAPTURE.get(), 0.4f, 1.0f);
                this.inCatchAnimation = true;
                this.ticker = -500;
                this.shakes = MathHelper.func_76125_a((int)shakes, (int)1, (int)3);
                this.catchSuccess = shakes >= 4;
                this.canCatch = false;
                this.sentToPC = sentToPC;
            }
            this.shouldRefresh = true;
        }
    }

    private void initButtons() {
        this.buttons.clear();
        if (this.canCatch) {
            this.buttons.add(new RaidButton((double)this.field_230708_k_ * 0.5, (double)this.field_230709_l_ / 1.06 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, 0.0, (float)this.field_230709_l_ / 17.0f, "<", this.raid, button -> {
                boolean prev = this.canUseCurrentBall();
                --this.ballIndex;
                if (this.ballIndex < 0) {
                    this.ballIndex = this.balls.size() - 1;
                }
                if (this.canUseCurrentBall() != prev) {
                    this.shouldRefresh = true;
                }
            }).setEnabled(this.balls.size() > 1).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.field_230708_k_ * 0.6, (double)this.field_230709_l_ / 1.06 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, 0.0, (float)this.field_230709_l_ / 17.0f, ">", this.raid, button -> {
                boolean prev = this.canUseCurrentBall();
                ++this.ballIndex;
                if (this.ballIndex >= this.balls.size()) {
                    this.ballIndex = 0;
                }
                if (this.canUseCurrentBall() != prev) {
                    this.shouldRefresh = true;
                }
            }).setEnabled(this.balls.size() > 1).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.field_230708_k_ * 0.643, (double)this.field_230709_l_ / 1.06 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, (float)this.field_230708_k_ / 7.0f, (float)this.field_230709_l_ / 17.0f, this.pcFull ? I18n.func_135052_a((String)"raid.button.pcfull", (Object[])new Object[0]) : (this.balls.isEmpty() ? I18n.func_135052_a((String)"raid.button.noballs", (Object[])new Object[0]) : (this.canUseCurrentBall() ? I18n.func_135052_a((String)"raid.button.catch", (Object[])new Object[0]) : I18n.func_135052_a((String)"raid.button.cantuse", (Object[])new Object[0]))), this.raid, button -> NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 10, this.ballIndex, this.balls.get(this.ballIndex).getItemStack()))).setEnabled(this.canCatch && !this.balls.isEmpty() && !this.pcFull && this.canUseCurrentBall()).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.field_230708_k_ * 0.83, (double)this.field_230709_l_ / 1.06 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, (float)this.field_230708_k_ / 7.0f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.dontcatch", (Object[])new Object[0]), this.raid, button -> {
                this.closing = true;
                BattleScreen.restoreSettingsAndCloseStatic(ClientProxy.battleManager);
            }).setEnabled(this.canCatch).setVisible(this.canCatch));
        } else {
            this.buttons.add(new RaidButton((double)this.field_230708_k_ * 0.55, (double)this.field_230709_l_ / 1.06 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, (float)this.field_230708_k_ / 2.365f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.done", (Object[])new Object[0]), this.raid, button -> {
                this.closing = true;
                BattleScreen.restoreSettingsAndCloseStatic(ClientProxy.battleManager);
            }).setEnabled(!this.inCatchAnimation && !this.canCatch).setVisible(!this.canCatch));
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        float scale;
        if (this.buttons.isEmpty() || this.shouldRefresh) {
            this.shouldRefresh = false;
            this.initButtons();
        }
        this.func_230446_a_(matrix);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (RaidButton button : this.buttons) {
            button.draw(matrix, mouseX, mouseY, partialTicks);
        }
        int starSize = (int)((double)this.field_230708_k_ * 0.05);
        double sw = this.raid.getStars() * starSize;
        for (int i = 0; i < this.raid.getStars(); ++i) {
            ScreenHelper.drawImage(matrix, STAR, (float)((double)((float)this.field_230708_k_ * 0.75f + (float)(starSize * i)) - sw / 2.0), (float)this.field_230709_l_ * 0.185f, (float)starSize, (float)starSize, 1.0f);
        }
        float fs = (float)this.field_230708_k_ * 0.045f;
        ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)(this.catchSuccess && !this.inCatchAnimation ? "raid.caught" : "raid.defeated"), (Object[])new Object[]{this.raid.getSpecies().getName()}), (float)this.field_230708_k_ * 0.755f, (float)this.field_230709_l_ * 0.125f - fs / 4.0f, -1, fs);
        this.drawDrops(matrix, mouseX, mouseY);
        if (!this.balls.isEmpty() && this.canCatch) {
            scale = (float)this.field_230708_k_ / 960.0f * 3.0f;
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)((float)this.field_230708_k_ * 0.525f), (double)this.field_230709_l_ * 0.7675, 0.0);
            matrix.func_227862_a_(scale, scale, scale);
            this.drawItem(matrix, this.balls.get(this.ballIndex).getItemStack(), 0.0f, 0.0f, 770, 771);
            matrix.func_227865_b_();
        }
        if (this.canCatch || this.ticker < 0 || !this.raid.canAllCatch && !this.raid.isOwner(this.field_230706_i_.field_71439_g.func_110124_au())) {
            matrix.func_227860_a_();
            RenderSystem.enableColorMaterial();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            matrix.func_227861_a_((double)((float)this.field_230708_k_ / 4.0f), (double)((float)this.field_230709_l_ / 4.0f * 3.0f), 300.0);
            double referenceW = (float)this.field_230709_l_ / 3.0f;
            double referenceH = (float)this.field_230709_l_ / 4.0f;
            double dh = this.pixelmon.getForm().getDimensions().getHeight() - referenceH;
            double dw = this.pixelmon.getForm().getDimensions().getWidth() - referenceW;
            float scalar = 1.0f;
            scalar = dh > dw ? (float)(referenceH / this.pixelmon.getForm().getDimensions().getHeight()) : (float)(referenceW / this.pixelmon.getForm().getDimensions().getWidth());
            matrix.func_227862_a_(scalar, scalar, scalar);
            if (this.ticker < 0) {
                float shrink = (float)Math.max(0, -this.ticker) / 500.0f;
                matrix.func_227862_a_(shrink, shrink, shrink);
            }
            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            RenderHelper.func_227780_a_();
            try {
                EntityRendererManager renderManager = this.field_230706_i_.func_175598_ae();
                EntityRenderer entityClassRenderObject = renderManager.func_78713_a((Entity)this.pixelmon);
                PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
                IRenderTypeBuffer.Impl impl = ScreenHelper.getBufferImpl();
                rp.render(this.pixelmon, 0.0f, partialTicks, matrix, (IRenderTypeBuffer)impl, 0xF000F0);
                impl.func_228461_a_();
                renderManager.func_229089_a_(Vector3f.field_229181_d_.func_229193_c_(180.0f));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            matrix.func_227865_b_();
        }
        if (this.shiny && RandomHelper.getRandom().nextInt(80) == 0) {
            double dx = (RandomHelper.getRandom().nextDouble() - 0.5) * (double)this.field_230709_l_ * 0.5;
            double dy = (RandomHelper.getRandom().nextDouble() - 0.5) * (double)this.field_230709_l_ * 0.5;
            int size = 15 + RandomHelper.getRandom().nextInt(15);
            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(SHINY, (double)this.field_230708_k_ * 0.225 + dx, (double)this.field_230709_l_ * 0.5 + dy, 1000.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, (particle, matrixStack) -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
        this.particleEngine.draw(matrix);
        if (!this.canCatch) {
            matrix.func_227860_a_();
            scale = (float)this.field_230708_k_ / 960.0f * 6.0f;
            matrix.func_227861_a_((double)((float)this.field_230708_k_ * 0.201f), (double)this.field_230709_l_ * 0.58, 200.0);
            matrix.func_227862_a_(scale, scale, scale);
            if (this.inCatchAnimation) {
                long ms = this.getMillis();
                if (this.shakes > 0) {
                    boolean tick = true;
                    float scalar = 0.5f;
                    float speed = 1.0f;
                    float angle = 0.0f;
                    float shrink = 1.0f;
                    if (this.ticker >= 0) {
                        if (this.delay == -1) {
                            this.delay = 500;
                        }
                        if (this.delay > 0) {
                            this.delay = (int)((long)this.delay - ms);
                            tick = false;
                        }
                        if ((float)this.ticker < 100.0f * speed) {
                            angle = (float)(-this.ticker) * scalar;
                        } else if ((float)this.ticker < 300.0f * speed) {
                            angle = ((float)this.ticker - 200.0f * speed) * scalar;
                            if ((float)this.ticker < 200.0f * speed && !this.shakeSound) {
                                SoundHelper.playSound(SoundEvents.field_187676_dE, 1.0f, 1.0f);
                                this.shakeSound = true;
                            }
                        } else if ((float)this.ticker < 400.0f * speed) {
                            angle = (400.0f * speed - (float)this.ticker) * scalar;
                        } else if ((float)this.ticker > 500.0f * speed) {
                            this.ticker = 0;
                            --this.shakes;
                            this.shakeSound = false;
                        }
                    } else {
                        shrink = 1.0f - (float)Math.max(0, -this.ticker) / 500.0f;
                    }
                    matrix.func_227861_a_(8.0, 16.0, 0.0);
                    matrix.func_227862_a_(shrink, shrink, shrink);
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(angle, 0.0f, 0.0f, 1.0f));
                    matrix.func_227861_a_(-8.0, -16.0, 0.0);
                    if (tick) {
                        this.ticker = (int)((double)this.ticker + (double)ms / 2.5);
                    }
                } else {
                    this.inCatchAnimation = false;
                    this.shouldRefresh = true;
                    if (this.catchSuccess) {
                        SoundHelper.playSound((SoundEvent)SoundRegistration.POKEBALL_CAPTURE_SUCCESS.get(), 0.2f, 1.0f);
                        for (int i = 0; i < 15; ++i) {
                            int r = RandomHelper.getRandom().nextInt(360);
                            double dx = (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0) * (double)this.field_230708_k_ * 0.05;
                            double dy = (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0) * (double)this.field_230708_k_ * 0.05;
                            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(STAR, (double)((float)this.field_230708_k_ * 0.251f) + dx, (double)this.field_230709_l_ * 0.675 + dy, 10.0, 0.0, 0.0, 0.0, 0.96f, 0.78f, 0.0f, 0.0f, 0.0f, 0.0f, RandomHelper.getRandom().nextInt(100) + 100, (particle, matrixStack) -> {
                                int x = particle.age;
                                int m = particle.maxAge;
                                int h = m / 2;
                                float s = (float)(x <= h ? x : h - (x - h)) / (float)h;
                                matrixStack.func_227861_a_(particle.x, particle.y, 0.0);
                                matrixStack.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)(r + x), true));
                                matrixStack.func_227861_a_(-particle.x, -particle.y, 0.0);
                                matrixStack.func_227861_a_((double)(-particle.w / 2.0f), (double)(-particle.h / 2.0f), 0.0);
                                particle.a = s;
                                particle.w = s * (float)this.field_230708_k_ * 0.0525f;
                                particle.h = s * (float)this.field_230708_k_ * 0.0525f;
                            }));
                        }
                    } else {
                        ArrayList stacks;
                        SoundHelper.playSound(SoundEvents.field_187635_cQ, 0.8f, 0.8f + this.field_230706_i_.field_71441_e.field_73012_v.nextFloat() * 0.4f);
                        ItemData data = this.balls.get(this.ballIndex);
                        ItemStack pokeballStack = data.getItemStack();
                        if (pokeballStack.func_77973_b().equals(PixelmonItems.poke_ball)) {
                            PokeBall ball = PokeBallPart.getPokeBall(pokeballStack).get();
                            stacks = Lists.newArrayList((Object[])new ItemStack[]{ball.getLidItem(), new ItemStack((IItemProvider)ball.getRandomBaseAsItem()), new ItemStack((IItemProvider)Blocks.field_150430_aB)});
                        } else {
                            stacks = Lists.newArrayList((Object[])new ItemStack[]{pokeballStack});
                        }
                        for (ItemStack stack : stacks) {
                            double mY = 0.1 + (RandomHelper.getRandom().nextDouble() * 0.1 - 0.05);
                            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(null, (float)this.field_230708_k_ * 0.201f, (double)this.field_230709_l_ * 0.58, 0.0, RandomHelper.getRandom().nextDouble() * 2.0 - 1.0, -2.0, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 300, (particle, matrixStack) -> {
                                matrixStack.func_227860_a_();
                                matrixStack.func_227861_a_(particle.x, particle.y, 200.0);
                                matrixStack.func_227862_a_(scale, scale, scale);
                                this.drawItem((MatrixStack)matrixStack, stack, 0.0f, 0.0f, 770, 771);
                                matrixStack.func_227865_b_();
                                particle.mY += mY;
                            }));
                        }
                    }
                }
            }
            if (this.shakes > 0 || this.catchSuccess) {
                this.drawItem(matrix, this.balls.get(this.ballIndex).getItemStack(), 0.0f, 0.0f, 770, 771, this.shakes == 0);
            }
            matrix.func_227865_b_();
        }
    }

    private void drawDrops(MatrixStack matrix, int mouseX, int mouseY) {
        int index;
        float fs = (float)this.field_230708_k_ * 0.045f;
        for (int i = 0; i < 6 && (index = this.scrollIndex + i) < this.drops.length; ++i) {
            ItemStack stack = this.drops[index];
            float h = (float)this.field_230709_l_ * (0.3f + 0.076f * (float)i);
            float scale = (float)this.field_230708_k_ / 960.0f * 2.0f;
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)((float)this.field_230708_k_ * 0.55f), (double)h - (double)this.field_230709_l_ * 0.015, 0.0);
            matrix.func_227862_a_(scale, scale, scale);
            this.drawItem(matrix, stack, 0.0f, 0.0f, 770, 771);
            matrix.func_227865_b_();
            ScreenHelper.drawScaledSquashedString(matrix, stack.func_200301_q().getString(), (float)this.field_230708_k_ * 0.595f, h, -1, fs, 100.0);
            ScreenHelper.drawScaledString(matrix, "x " + stack.func_190916_E(), (float)this.field_230708_k_ * 0.89f, h - (float)this.field_230709_l_ * 0.005f, -1, fs);
        }
        if (this.drops.length > 6) {
            boolean mouseOver;
            int top = (int)((double)this.field_230709_l_ * 0.29);
            int bottom = (int)((double)this.field_230709_l_ * 0.735);
            int diff = bottom - top;
            int div = this.drops.length - 5;
            float dy = (float)diff / (float)div;
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)((int)((double)this.field_230708_k_ * 0.972)), (int)top, (int)((int)((double)this.field_230708_k_ * 0.9825)), (int)bottom, (int)-298897617);
            int bX1 = (int)((double)this.field_230708_k_ * 0.972);
            int bY1 = (int)((float)top + dy * (float)this.scrollIndex);
            int bX2 = (int)((double)this.field_230708_k_ * 0.9825);
            int bY2 = (int)((float)top + dy * (float)(this.scrollIndex + 1));
            boolean bl = mouseOver = mouseX >= bX1 && mouseY >= bY1 && mouseX <= bX2 && mouseY <= bY2;
            if (this.click && mouseOver) {
                this.scrolling = true;
            }
            if (!this.field_230706_i_.field_71417_B.func_198030_b()) {
                this.scrolling = false;
            }
            if (this.scrolling) {
                if (mouseY > bY2) {
                    ++this.scrollIndex;
                    if (this.scrollIndex > this.drops.length - 6) {
                        this.scrollIndex = Math.max(0, this.drops.length - 6);
                    }
                } else if (mouseY < bY1) {
                    --this.scrollIndex;
                    if (this.scrollIndex < 0) {
                        this.scrollIndex = 0;
                    }
                }
            }
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)bX1, (int)bY1, (int)bX2, (int)bY2, (int)(mouseOver || this.scrolling ? -289686597 : -292318317));
        }
        this.click = false;
    }

    private void drawItem(MatrixStack matrix, ItemStack stack, float x, float y, int srcFactor, int destFactor) {
        this.drawItem(matrix, stack, x, y, srcFactor, destFactor, false);
    }

    private void drawItem(MatrixStack matrix, ItemStack stack, float x, float y, int srcFactor, int destFactor, boolean darken) {
        boolean flag;
        matrix.func_227860_a_();
        IBakedModel model = this.field_230707_j_.func_184393_a(stack, null, null);
        this.field_230706_i_.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.field_230706_i_.field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)srcFactor, (int)destFactor);
        RenderSystem.enableColorMaterial();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderHelper.func_227780_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.func_227861_a_((double)x, (double)y, (double)(100.0f + this.field_230707_j_.field_77023_b));
        matrix.func_227861_a_(8.0, 8.0, 0.0);
        matrix.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrix.func_227862_a_(16.0f, 16.0f, 16.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !model.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.field_230707_j_.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrix, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, model);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        matrix.func_227865_b_();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)this.field_230708_k_ * 0.525 && mouseY >= (double)this.field_230709_l_ * 0.25 && mouseY <= (double)this.field_230709_l_ * 0.75) {
            if (delta < 0.0) {
                ++this.scrollIndex;
                if (this.scrollIndex > this.drops.length - 6) {
                    this.scrollIndex = Math.max(0, this.drops.length - 6);
                }
            } else if (delta > 0.0) {
                --this.scrollIndex;
                if (this.scrollIndex < 0) {
                    this.scrollIndex = 0;
                }
            }
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (RaidButton button : this.buttons) {
            button.onClick(mouseX, mouseY, mouseButton);
        }
        this.click = true;
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_230446_a_(MatrixStack matrix) {
        ScreenHelper.drawGradientRect(matrix, 0, 0, 0.0f, this.field_230708_k_, this.field_230709_l_, -1596523265, -1866285374);
        int bgBar = (int)((double)this.field_230709_l_ * 0.125);
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)this.field_230708_k_, 0.0, 0.0);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 0.0f, 0.0f, 1.0f));
        float[] color = this.raid.getDenEntity((World)this.field_230706_i_.field_71441_e).map(den -> {
            ScreenHelper.drawGradientRect(matrix, bgBar, 0, 0.0f, this.field_230709_l_ - bgBar, this.field_230708_k_, den.getColorUIA().getRGB(), den.getColorUIB().getRGB());
            Color c3 = den.getColorUIC();
            return new float[]{(float)c3.getRed() / 255.0f, (float)c3.getGreen() / 255.0f, (float)c3.getBlue() / 255.0f, 0.4f};
        }).orElseGet(() -> {
            ScreenHelper.drawGradientRect(matrix, bgBar, 0, 0.0f, this.field_230709_l_ - bgBar, this.field_230708_k_, -37796, -5752007);
            return new float[]{0.8f, 0.0f, 0.0f, 0.4f};
        });
        matrix.func_227865_b_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.func_227860_a_();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(-35.0f, 0.0f, 0.0f, 1.0f));
        ScreenHelper.drawImage(matrix, WATERMARK, (float)this.field_230708_k_ / 2.8f, (float)this.field_230709_l_ / 1.2f, (float)this.field_230708_k_ / 3.75f, (float)((double)((float)this.field_230708_k_ / 3.75f) * 1.65591398), color[0], color[1], color[2], color[3], 0.0f);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        ScreenHelper.drawQuad(matrix, this.field_230708_k_, (float)bgBar * 0.5f, 0.0f, (float)this.field_230708_k_ - (float)this.field_230708_k_ * 0.475f, (float)bgBar * 0.5f, 0.0f, (float)this.field_230708_k_ - (float)this.field_230708_k_ * 0.5f, (float)bgBar * 1.5f, 0.0f, this.field_230708_k_, (float)bgBar * 1.5f, 0.0f, Color.BLACK);
        matrix.func_227865_b_();
    }

    public void func_231023_e_() {
        this.pixelmon.getAnimationVariables().tick();
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        super.func_231152_a_(minecraft, width, height);
        this.initButtons();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (!this.closing) {
            this.field_230706_i_.execute(() -> this.field_230706_i_.func_147108_a((Screen)this));
        } else if (this.sentToPC) {
            this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.storage.partyfull", new Object[]{this.pixelmon.func_145748_c_()}), Util.field_240973_b_);
        }
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public long getMillis() {
        if (this.lastTime < 0L) {
            this.lastTime = System.currentTimeMillis();
            return 0L;
        }
        long time = System.currentTimeMillis();
        long diff = time - this.lastTime;
        this.lastTime = time;
        return diff;
    }

    private boolean canUseCurrentBall() {
        if (this.balls.isEmpty()) {
            return false;
        }
        Optional<PokeBall> ball = PokeBallPart.getPokeBall(this.balls.get(this.ballIndex).getItemStack());
        return this.raid.canUseMaster || !ball.isPresent() || !ball.get().isGuaranteedCatch();
    }
}

