/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.CommandSuggestionHelper;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.ForgeEventFactory;

public class ChatExtensionScreen
extends Screen {
    private int bPosX = 0;
    private int bPosY = 0;
    private int yOffset;
    public static boolean chatOpen = false;
    public boolean updateHeight = false;
    private int lastHeight = -1;
    private int sentHistoryCursor = -1;
    protected TextFieldWidget inputField;
    private String chatText;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private Screen screen;
    private CommandSuggestionHelper commandSuggestionHelper;
    private boolean justOpened = false;

    public ChatExtensionScreen(Screen screen, int yOffset) {
        super(StringTextComponent.field_240750_d_);
        this.screen = screen;
        this.yOffset = yOffset;
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (!this.justOpened || Character.toLowerCase(typedChar) != Character.toLowerCase((char)Minecraft.func_71410_x().field_71474_y.field_74310_D.getKey().func_197937_c())) {
            this.justOpened = false;
            return super.func_231042_a_(typedChar, keyCode);
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        super.func_231044_a_(mouseX, mouseY, button);
        if (button == Minecraft.func_71410_x().field_71474_y.field_74310_D.getKey().func_197937_c() && !this.isChatOpen()) {
            this.chatOpened("");
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Minecraft.func_71410_x().field_71474_y.field_74310_D.getKey().func_197937_c() && !this.isChatOpen()) {
            this.chatOpened("");
            return true;
        }
        if (keyCode == 47 && !this.isChatOpen()) {
            this.chatOpened("");
            return true;
        }
        if (this.commandSuggestionHelper.func_228115_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.chatClosed();
            return true;
        }
        if (keyCode != 257 && keyCode != 335) {
            if (keyCode == 265) {
                this.getSentHistory(-1);
                return true;
            }
            if (keyCode == 264) {
                this.getSentHistory(1);
                return true;
            }
            if (keyCode == 266) {
                this.minecraft.field_71456_v.func_146158_b().func_194813_a((double)(this.minecraft.field_71456_v.func_146158_b().func_146232_i() - 1));
                return true;
            }
            if (keyCode == 267) {
                this.minecraft.field_71456_v.func_146158_b().func_194813_a((double)(-this.minecraft.field_71456_v.func_146158_b().func_146232_i() + 1));
                return true;
            }
            return false;
        }
        String s = this.inputField.func_146179_b().trim();
        if (!s.isEmpty()) {
            this.func_231161_c_(s);
        }
        this.chatClosed();
        return true;
    }

    public void func_231160_c_() {
        this.bPosX = 2;
        this.bPosY = this.screen.field_230709_l_ - this.yOffset;
        this.minecraft.field_195559_v.func_197967_a(true);
        this.sentHistoryCursor = this.minecraft.field_71456_v.func_146158_b().func_146238_c().size();
        this.inputField = new TextFieldWidget(this.screen.getMinecraft().field_71466_p, this.bPosX + 2, this.bPosY + 2, this.screen.field_230708_k_ - 4, 12, (ITextComponent)new TranslationTextComponent("chat.editBox")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(ChatExtensionScreen.this.commandSuggestionHelper.func_228129_c_());
            }
        };
        this.inputField.func_146203_f(256);
        this.inputField.func_146185_a(false);
        this.inputField.func_146195_b(true);
        this.inputField.func_146180_a(this.inputField.func_146179_b());
        this.inputField.func_212954_a(this::onEdited);
        this.inputField.func_146205_d(false);
        this.inputField.func_146189_e(false);
        this.commandSuggestionHelper = new CommandSuggestionHelper(this.minecraft, this.screen, this.inputField, this.minecraft.field_71466_p, false, false, 1, 10, true, -805306368);
        this.commandSuggestionHelper.func_228111_a_();
    }

    private void onEdited(String p_212997_1_) {
        String s = this.inputField.func_146179_b();
        this.commandSuggestionHelper.func_228124_a_(!s.equals(""));
        this.commandSuggestionHelper.func_228111_a_();
    }

    public void func_231175_as__() {
        this.minecraft.field_195559_v.func_197967_a(false);
        this.minecraft.field_71456_v.func_146158_b().func_146240_d();
        chatOpen = false;
    }

    public void tick(int height) {
        if (this.inputField != null) {
            this.inputField.func_146178_a();
        }
        if (this.updateHeight) {
            if (this.lastHeight != height) {
                this.yOffset = height > 900 ? 140 : 125;
                this.func_231160_c_();
            }
            this.lastHeight = height;
        }
    }

    public boolean isChatOpen() {
        return chatOpen;
    }

    public void drawScreen(MatrixStack matrix, int par1, int par2, float par3) {
        if (chatOpen) {
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)2, (int)(this.screen.field_230709_l_ - this.yOffset), (int)(this.screen.field_230708_k_ - 122), (int)(this.screen.field_230709_l_ - this.yOffset + 12), (int)Integer.MIN_VALUE);
            this.inputField.func_230431_b_(matrix, par1, par2, par3);
        }
        if (this.minecraft == null || this.minecraft.field_71456_v == null) {
            return;
        }
        NewChatGui guiNewChat = this.minecraft.field_71456_v.func_146158_b();
        int j = this.getLineCount();
        int k = 0;
        int l = guiNewChat.func_146232_i();
        double f = this.minecraft.field_71474_y.field_74357_r * (double)0.9f + (double)0.1f;
        int updateCounter = this.minecraft.field_71456_v.func_73834_c();
        if (l > 0) {
            int l1;
            int k1;
            int j1;
            float f1 = (float)this.getChatScale();
            int i1 = MathHelper.func_76123_f((float)((float)this.getChatWidth() / f1));
            matrix.func_227860_a_();
            if (chatOpen) {
                matrix.func_227861_a_(2.0, (double)(this.bPosY - 3), 0.0);
            } else {
                matrix.func_227861_a_(2.0, (double)(this.bPosY + 10), 0.0);
            }
            matrix.func_227862_a_(f1, f1, 1.0f);
            for (j1 = 0; j1 + guiNewChat.field_146250_j < guiNewChat.field_146253_i.size() && j1 < j; ++j1) {
                ChatLine chatline = (ChatLine)guiNewChat.field_146253_i.get(j1 + guiNewChat.field_146250_j);
                if (chatline == null || (k1 = updateCounter - chatline.func_74540_b()) >= 200 && !chatOpen) continue;
                double d0 = (double)k1 / 200.0;
                d0 = 1.0 - d0;
                if ((d0 *= 10.0) < 0.0) {
                    d0 = 0.0;
                }
                if (d0 > 1.0) {
                    d0 = 1.0;
                }
                d0 *= d0;
                l1 = (int)(255.0 * d0);
                if (chatOpen) {
                    l1 = 255;
                }
                l1 = (int)((double)l1 * f);
                ++k;
                if (l1 <= 3) continue;
                int b0 = 0;
                int i2 = -j1 * 9;
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)b0, (int)(i2 - 9), (int)(b0 + i1 + 4), (int)i2, (int)(l1 / 2 << 24));
                IReorderingProcessor s = (IReorderingProcessor)chatline.func_238169_a_();
                if (!this.minecraft.field_71474_y.field_74344_o) {
                    // empty if block
                }
                RenderSystem.enableBlend();
                this.minecraft.field_71466_p.func_238407_a_(matrix, s, (float)b0, (float)(i2 - 8), 0xFFFFFF + (l1 << 24));
                RenderSystem.disableBlend();
            }
            if (chatOpen) {
                this.minecraft.field_71466_p.getClass();
                j1 = 9;
                matrix.func_227861_a_(-3.0, 0.0, 0.0);
                int j2 = l * j1 + l;
                k1 = k * j1 + k;
                int k2 = guiNewChat.field_146250_j * k1 / l;
                int l2 = k1 * k1 / j2;
                if (j2 != k1) {
                    l1 = k2 > 0 ? 170 : 96;
                    int i3 = guiNewChat.field_146251_k ? 0xCC3333 : 0x3333AA;
                    AbstractGui.func_238467_a_((MatrixStack)matrix, (int)0, (int)(-k2), (int)2, (int)(-k2 - l2), (int)(i3 + (l1 << 24)));
                    AbstractGui.func_238467_a_((MatrixStack)matrix, (int)2, (int)(-k2), (int)1, (int)(-k2 - l2), (int)(0xCCCCCC + (l1 << 24)));
                }
            }
            matrix.func_227865_b_();
        }
    }

    private void chatOpened(String start) {
        if (this.minecraft.field_71474_y.field_74343_n == ChatVisibility.HIDDEN || this.inputField == null) {
            return;
        }
        if (start != null) {
            this.inputField.func_146180_a(start);
        } else {
            this.inputField.func_146180_a("");
        }
        chatOpen = true;
        this.inputField.func_146189_e(true);
        this.inputField.func_146195_b(true);
        this.func_231035_a_((IGuiEventListener)this.inputField);
        this.justOpened = true;
    }

    private void chatClosed() {
        chatOpen = false;
        this.inputField.func_146189_e(false);
        this.inputField.func_146195_b(false);
        this.func_231035_a_(null);
        this.inputField.func_146180_a("");
    }

    public void func_231161_c_(String text) {
        if ((text = ForgeEventFactory.onClientSendMessage((String)text)).isEmpty()) {
            return;
        }
        this.minecraft.field_71456_v.func_146158_b().func_146239_a(text);
        this.minecraft.field_71439_g.func_71165_d(text);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.isChatOpen()) {
            this.minecraft.field_71456_v.func_146158_b().func_194813_a(delta);
            return true;
        }
        return false;
    }

    private void getSentHistory(int par1) {
        int j = this.sentHistoryCursor + par1;
        int k = this.minecraft.field_71456_v.func_146158_b().func_146238_c().size();
        if (j < 0) {
            j = 0;
        }
        if (j > k) {
            j = k;
        }
        if (j != this.sentHistoryCursor) {
            try {
                if (j == k) {
                    this.sentHistoryCursor = k;
                    this.inputField.func_146180_a(this.chatText);
                } else {
                    if (this.sentHistoryCursor == k) {
                        this.chatText = this.inputField.func_146179_b();
                    }
                    this.inputField.func_146180_a((String)this.minecraft.field_71456_v.func_146158_b().func_146238_c().get(j));
                    this.sentHistoryCursor = j;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void mouseClickedUnderMenus(int par1, int par2, int par3) {
        this.inputField.func_231044_a_((double)par1, (double)par2, par3);
    }

    private int getChatWidth() {
        return ChatExtensionScreen.calculateChatboxWidth(this.minecraft.field_71474_y.field_96692_F);
    }

    private int getChatHeight() {
        return ChatExtensionScreen.calculateChatboxHeight(this.minecraft.field_71474_y.field_96694_H);
    }

    private double getChatScale() {
        return this.minecraft.field_71474_y.field_96691_E;
    }

    private static int calculateChatboxWidth(double p_146233_0_) {
        int short1 = 320;
        int b0 = 40;
        return MathHelper.func_76128_c((double)(p_146233_0_ * (double)(short1 - b0) + (double)b0));
    }

    private static int calculateChatboxHeight(double p_146243_0_) {
        int short1 = 180;
        int b0 = 20;
        return MathHelper.func_76128_c((double)(p_146243_0_ * (double)(short1 - b0) + (double)b0));
    }

    private int getLineCount() {
        return this.getChatHeight() / 9;
    }
}

