/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.DualModelFactory;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import java.util.Objects;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class PixelmonSmdFactory {
    private static final ResourceLocation NO_MODEL = ResourceLocationHelper.of("pixelmon", "none");
    protected ResourceWithFallback model;
    protected float xRotation = 0.0f;
    protected float yRotation = 24.0f;
    protected float zRotation = 0.0f;
    protected float rotateAngleX = -1.5707964f;
    protected float rotateAngleY = 0.0f;
    protected float movementThreshold = 0.3f;
    protected float animationIncrement = 1.0f;
    protected float xOffset = 0.0f;
    protected float yOffset = 0.0f;
    protected float zOffset = 0.0f;
    protected float transparency = 0.0f;
    protected float transparency2 = 0.0f;

    public PixelmonSmdFactory(ResourceWithFallback ... model) {
        this.model = model[0];
    }

    public PixelmonSmdFactory setXRotation(float xRotation) {
        this.xRotation = xRotation;
        return this;
    }

    public PixelmonSmdFactory setYRotation(float yRotation) {
        this.yRotation = yRotation;
        return this;
    }

    public PixelmonSmdFactory setZRotation(float zRotation) {
        this.zRotation = zRotation;
        return this;
    }

    public PixelmonSmdFactory setTranslation(float translation) {
        this.xRotation = translation;
        this.zRotation = translation;
        return this;
    }

    public PixelmonSmdFactory setMovementThreshold(float threshold) {
        this.movementThreshold = threshold;
        return this;
    }

    public PixelmonSmdFactory setRotateAngleX(float rotateAngleX) {
        this.rotateAngleX = rotateAngleX;
        return this;
    }

    public PixelmonSmdFactory setRotateAngleY(float rotateAngleY) {
        this.rotateAngleY = rotateAngleY;
        return this;
    }

    public PixelmonSmdFactory setAnimationIncrement(float animationIncrement) {
        this.animationIncrement = animationIncrement;
        return this;
    }

    public PixelmonSmdFactory setTransparency(float transparency) {
        this.transparency = transparency;
        return this;
    }

    public PixelmonSmdFactory setXOffset(float xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public PixelmonSmdFactory setYOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public PixelmonSmdFactory setZOffset(float zOffset) {
        this.zOffset = zOffset;
        return this;
    }

    public PixelmonSmdFactory setValues(float xRotation, float yRotation, float zRotation, float rotateAngleX, float rotateAngleY, float movementThreshold, float animationIncrement, float xOffset, float yOffset, float zOffset, float transparency, float transparency2) {
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.rotateAngleX = rotateAngleX;
        this.rotateAngleY = rotateAngleY;
        this.movementThreshold = movementThreshold;
        this.animationIncrement = animationIncrement;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.transparency = transparency;
        if (this instanceof DualModelFactory) {
            ((DualModelFactory)this).setModel2Transparency(transparency2);
        }
        return this;
    }

    protected <T extends AbstractClientEntity> PixelmonModelSmd<T> createModel() {
        if (Objects.equals(this.model.get(), NO_MODEL)) {
            return null;
        }
        Impl impl = new Impl(this, PixelmonSmdFactory.loadModel(this.model.get()));
        impl.body.func_78793_a(this.xRotation, this.yRotation, this.zRotation);
        impl.body.field_78795_f = this.rotateAngleX;
        impl.body.field_78796_g = this.rotateAngleY;
        impl.body.offsetX = this.xOffset;
        impl.body.offsetY = this.yOffset;
        impl.body.offsetZ = this.zOffset;
        impl.movementThreshold = this.movementThreshold;
        impl.animationIncrement = this.animationIncrement;
        impl.body.setTransparent(this.transparency);
        return impl;
    }

    protected static ValveStudioModel loadModel(ResourceLocation rl) {
        try {
            if (ValveStudioModelLoader.INSTANCE.accepts(rl)) {
                return (ValveStudioModel)ValveStudioModelLoader.INSTANCE.loadModel(rl);
            }
            System.out.println("Could not load the smd model: " + rl.func_110623_a());
        }
        catch (Exception e) {
            System.out.println("Could not load the smd model: " + rl.func_110623_a());
            e.printStackTrace();
        }
        return null;
    }

    public static class Impl<T extends AbstractClientEntity>
    extends PixelmonModelSmd<T> {
        protected final PixelmonSmdFactory factory;
        protected PixelmonModelRenderer body;

        Impl(PixelmonSmdFactory factory, ValveStudioModel valveStudioModel) {
            this.theModel = valveStudioModel;
            this.factory = factory;
            this.body = new PixelmonModelRenderer((Model)this, "body");
            this.body.addCustomModel(new ModelCustomWrapper(valveStudioModel));
        }

        @Override
        public void setScale(float scale) {
            this.body.scale = scale;
        }

        @Override
        public void render(Entity entity, MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            if (this.body.getModel() instanceof PixelmonModelBase) {
                ((PixelmonModelBase)this.body.getModel()).texture = ((AbstractClientEntity)entity).getTexture();
            }
            this.body.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }

        @Override
        protected float getDefaultXRotation() {
            return this.factory.rotateAngleX;
        }

        @Override
        public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        }

        public void setupAnim(AbstractClientEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }
    }
}

