/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.data.IModelData;

public class PokeBallLidItemModel
implements IBakedModel {
    public static final ModelResourceLocation RESOURCE_LOCATION = new ModelResourceLocation("pixelmon:poke_ball_lid", "inventory");
    private final IBakedModel model;
    private final OverrideList overrides = new OverrideList();

    public PokeBallLidItemModel(IBakedModel model) {
        this.model = model;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.func_200117_a(state, side, rand);
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.model.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.func_177554_e();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack stack) {
        TransformationMatrix tr = (TransformationMatrix)PixelmonRendering.STANDARD_ITEM_TRANSFORMATIONS.get((Object)type);
        if (tr != null && !tr.isIdentity()) {
            tr.push(stack);
        }
        return this.model;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    static class OverrideList
    extends ItemOverrideList {
        private final Map<PokeBall, IBakedModel> models = Maps.newHashMap();

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            Optional<PokeBall> optionalPokeBall = PokeBallPart.getPokeBall(stack);
            if (optionalPokeBall.isPresent()) {
                PokeBall pokeBall = optionalPokeBall.get();
                IBakedModel model = this.models.get(pokeBall);
                if (model != null) {
                    return model;
                }
                try {
                    ResourceLocation sprite = pokeBall.getLidSprite();
                    Function textureGetter = Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b);
                    ImmutableList quads = ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)((TextureAtlasSprite)textureGetter.apply(sprite)), (TransformationMatrix)TransformationMatrix.func_227983_a_());
                    BakedItemModel newModel = new BakedItemModel(quads, originalModel.func_177554_e(), PixelmonRendering.STANDARD_ITEM_TRANSFORMATIONS, ItemOverrideList.field_188022_a, true, false);
                    this.models.put(pokeBall, (IBakedModel)newModel);
                    return newModel;
                }
                catch (IllegalStateException e) {
                    return originalModel;
                }
            }
            return originalModel;
        }
    }
}

