/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import com.pixelmonmod.pixelmon.client.particle.ParticleEvents;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleArcanery
extends Particle {
    private static final Comparator<ParticleArcanery> RENDER_ORDER = Comparator.comparingDouble(particle -> {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            double d0 = player.func_226277_ct_() - particle.field_187126_f;
            double d1 = player.func_226280_cw_() - particle.field_187127_g;
            double d2 = player.func_226281_cx_() - particle.field_187128_h;
            return -(d0 * d0 + d1 * d1 + d2 * d2);
        }
        return 0.0;
    });
    private static final List<ParticleArcanery> PARTICLE_QUEUE = new ArrayList<ParticleArcanery>();
    public ParticleEffect effect;
    private float partialTicks;
    public float rotationX;
    public float rotationZ;
    public float rotationYZ;
    public float rotationXY;
    public float rotationXZ;
    public double interpPosX;
    public double interpPosY;
    public double interpPosZ;
    public ActiveRenderInfo info;

    public ParticleArcanery(double x, double y, double z, double vx, double vy, double vz, ParticleEffect effect) {
        this(x, y, z, vx, vy, vz, 0.5f, effect);
    }

    public ParticleArcanery(double x, double y, double z, double vx, double vy, double vz, float size, ParticleEffect effect) {
        super(Minecraft.func_71410_x().field_71441_e != null ? Minecraft.func_71410_x().field_71441_e : null, x, y, z, vx, vy, vz);
        this.setPrevPos(x, y, z);
        this.effect = effect;
        effect.init(this, this.getWorld(), x, y, z, vx, vy, vz, size);
        this.func_189213_a();
    }

    public void setRGBA(float r, float g, float b, float a) {
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
        this.field_82339_as = a;
    }

    public double getMotionX() {
        return this.field_187129_i;
    }

    public double getMotionY() {
        return this.field_187130_j;
    }

    public double getMotionZ() {
        return this.field_187131_k;
    }

    public void setMotion(double x, double y, double z) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
    }

    public void setOnGround() {
        this.field_187132_l = true;
    }

    public void func_187114_a(int lifetime) {
        this.field_70547_e = lifetime;
    }

    public int func_206254_h() {
        return this.field_70547_e;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217605_e;
    }

    public boolean shouldCull() {
        return false;
    }

    public void incrementAge() {
        ++this.field_70546_d;
    }

    public int getAge() {
        return this.field_70546_d;
    }

    public float getSize() {
        return Math.max(this.field_187134_n, this.field_187135_o);
    }

    public void setSize(float size) {
        this.func_187115_a(size, size);
    }

    public float getWidth() {
        return this.field_187134_n;
    }

    public void setWidth(float width) {
        this.field_187134_n = width;
    }

    public float getHeight() {
        return this.field_187135_o;
    }

    public void setHeight(float height) {
        this.field_187135_o = height;
    }

    public double getX() {
        return this.field_187126_f;
    }

    public double getY() {
        return this.field_187127_g;
    }

    public double getZ() {
        return this.field_187128_h;
    }

    public void func_187109_b(double x, double y, double z) {
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
    }

    public double getPrevX() {
        return this.field_187123_c;
    }

    public double getPrevY() {
        return this.field_187124_d;
    }

    public double getPrevZ() {
        return this.field_187125_e;
    }

    public void setPrevPos(double x, double y, double z) {
        this.field_187123_c = x;
        this.field_187124_d = y;
        this.field_187125_e = z;
    }

    public void setHeading(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_187136_p.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_187136_p.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_187136_p.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_187129_i = x *= (double)velocity;
        this.field_187130_j = y *= (double)velocity;
        this.field_187131_k = z *= (double)velocity;
    }

    public boolean onGround() {
        return this.field_187132_l;
    }

    public static void dispatch(MatrixStack matrix, IRenderTypeBuffer tessellator, float ticks) {
        ParticleEvents.arcaneryParticleCount = 0;
        if (Minecraft.func_71375_t()) {
            PARTICLE_QUEUE.sort(RENDER_ORDER);
        }
        for (ParticleArcanery particle : PARTICLE_QUEUE) {
            if (particle == null || Minecraft.func_71410_x().func_147113_T()) continue;
            if (particle.getEffect().customRenderer()) {
                particle.getEffect().preRender(particle, ticks);
                particle.getEffect().render(matrix, particle, tessellator, ticks);
                particle.getEffect().postRender(particle, ticks);
                continue;
            }
            particle.getEffect().preRender(particle, ticks);
            particle.render(matrix, particle, tessellator, ticks);
            particle.getEffect().postRender(particle, ticks);
        }
        PARTICLE_QUEUE.clear();
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        this.partialTicks = partialTicks;
        this.interpPosX = MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f);
        this.interpPosY = MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g);
        this.interpPosZ = MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h);
        this.info = renderInfo;
        if (!Minecraft.func_71410_x().func_147113_T()) {
            PARTICLE_QUEUE.add(this);
        }
    }

    public void render(MatrixStack matrix, ParticleArcanery particle, IRenderTypeBuffer buffer, float partialTicks) {
        Vector3f[] avector3f = this.doStandardParticleRotation(this.info.func_216785_c(), partialTicks);
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        IVertexBuilder vertexBuffer = buffer.getBuffer(PixelmonRendering.getArcaneryTypes(particle.getTexture()));
        matrix.func_227860_a_();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        vertexBuffer.func_227888_a_(mat, avector3f[0].func_195899_a(), avector3f[0].func_195900_b(), avector3f[0].func_195902_c()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225583_a_(f8, f6).func_227886_a_(0xF000F0).func_181675_d();
        vertexBuffer.func_227888_a_(mat, avector3f[1].func_195899_a(), avector3f[1].func_195900_b(), avector3f[1].func_195902_c()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225583_a_(f8, f5).func_227886_a_(0xF000F0).func_181675_d();
        vertexBuffer.func_227888_a_(mat, avector3f[2].func_195899_a(), avector3f[2].func_195900_b(), avector3f[2].func_195902_c()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225583_a_(f7, f5).func_227886_a_(0xF000F0).func_181675_d();
        vertexBuffer.func_227888_a_(mat, avector3f[3].func_195899_a(), avector3f[3].func_195900_b(), avector3f[3].func_195902_c()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225583_a_(f7, f6).func_227886_a_(0xF000F0).func_181675_d();
        matrix.func_227865_b_();
        ((IRenderTypeBuffer.Impl)buffer).func_228462_a_(PixelmonRendering.getArcaneryTypes(particle.getTexture()));
    }

    public float getAngle() {
        return this.field_190014_F;
    }

    public float getPrevAngle() {
        return this.field_190015_G;
    }

    public float getAlphaF() {
        return this.field_82339_as;
    }

    public ResourceLocation getTexture() {
        return this.effect.texture();
    }

    public ParticleEffect getEffect() {
        return this.effect;
    }

    public void func_189213_a() {
        this.effect.update(this);
    }

    protected void func_187118_j() {
    }

    public void func_187110_a(double dx, double dy, double dz) {
        if (!this.getEffect().customRenderer()) {
            if (!this.field_228343_B_) {
                double d0 = dx;
                double d1 = dy;
                double d2 = dz;
                if (this.field_190017_n && (dx != 0.0 || dy != 0.0 || dz != 0.0)) {
                    Vector3d vector3d = Entity.func_223307_a(null, (Vector3d)new Vector3d(dx, dy, dz), (AxisAlignedBB)this.func_187116_l(), (World)this.field_187122_b, (ISelectionContext)ISelectionContext.func_216377_a(), (ReuseableStream)new ReuseableStream(Stream.empty()));
                    dx = vector3d.field_72450_a;
                    dy = vector3d.field_72448_b;
                    dz = vector3d.field_72449_c;
                }
                if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
                    this.field_187126_f += dx;
                    this.field_187127_g += dy;
                    this.field_187128_h += dz;
                }
                if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f) {
                    this.field_228343_B_ = true;
                }
                boolean bl = this.field_187132_l = d1 != dy && d1 < 0.0;
                if (d0 != dx) {
                    this.field_187129_i = 0.0;
                }
                if (d2 != dz) {
                    this.field_187131_k = 0.0;
                }
            }
        } else {
            this.func_187109_b(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
            float size = this.getSize() / 2.0f;
            this.func_187108_a(new AxisAlignedBB(this.getX() - (double)size, this.getY() - (double)size, this.getZ() - (double)size, this.getX() + (double)size, this.getY() + (double)size, this.getZ() + (double)size));
        }
    }

    public void setAngle(float theta) {
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F = theta;
    }

    public Random getRandom() {
        return this.field_187136_p;
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    public float getRedColorF() {
        return this.field_70552_h;
    }

    public float getGreenColorF() {
        return this.field_70553_i;
    }

    public float getBlueColorF() {
        return this.field_70551_j;
    }

    public float getAlphaColorF() {
        return this.field_82339_as;
    }

    public Vector3f[] doStandardParticleRotation(Vector3d vector3d, float partialTicks) {
        Quaternion quaternion;
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vector3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vector3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vector3d.func_82616_c());
        if (this.field_190014_F == 0.0f) {
            quaternion = this.info.func_227995_f_();
        } else {
            quaternion = new Quaternion(this.info.func_227995_f_());
            float f3 = MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F);
            quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getSize();
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        return avector3f;
    }

    public float getRoll() {
        return this.field_190014_F;
    }

    public float getORoll() {
        return this.field_190015_G;
    }
}

