/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles.beams;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.init.registry.ParticleRegistration;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;

public class EvolutionBeamParticleData
implements IParticleData {
    public static final Codec<EvolutionBeamParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.DOUBLE.fieldOf("diameter").forGetter(d -> d.diameter), (App)Codec.INT.fieldOf("beams").forGetter(d -> d.beams), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime)).apply((Applicative)instance, EvolutionBeamParticleData::new));
    private Color tint;
    private double diameter;
    private int beams;
    private int lifetime;
    public static final IParticleData.IDeserializer<EvolutionBeamParticleData> DESERIALIZER = new IParticleData.IDeserializer<EvolutionBeamParticleData>(){

        @Nonnull
        public EvolutionBeamParticleData fromCommand(@Nonnull ParticleType<EvolutionBeamParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double diameter = reader.readDouble();
            reader.expect(' ');
            int beams = reader.readInt();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            int red = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int alpha = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            return new EvolutionBeamParticleData(color, diameter, beams, lifetime);
        }

        public EvolutionBeamParticleData fromNetwork(@Nonnull ParticleType<EvolutionBeamParticleData> type, PacketBuffer buf) {
            int red = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int green = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int blue = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int alpha = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            double diameter = buf.readDouble();
            int beams = buf.readInt();
            int lifetime = buf.readInt();
            return new EvolutionBeamParticleData(color, diameter, beams, lifetime);
        }
    };

    public EvolutionBeamParticleData(Color tint, double diameter, int beams, int lifetime) {
        this.tint = tint;
        this.diameter = diameter;
        this.beams = beams;
        this.lifetime = lifetime;
    }

    public EvolutionBeamParticleData(int tintRGB, double diameter, int beams, int lifetime) {
        this.tint = new Color(tintRGB);
        this.diameter = diameter;
        this.beams = beams;
        this.lifetime = lifetime;
    }

    public Color getTint() {
        return this.tint;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public int getBeams() {
        return this.beams;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    @Nonnull
    public ParticleType<EvolutionBeamParticleData> func_197554_b() {
        return (ParticleType)ParticleRegistration.EVOLUTION_BEAM.get();
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeInt(this.tint.getAlpha());
        buf.writeDouble(this.diameter);
        buf.writeInt(this.beams);
        buf.writeInt(this.lifetime);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %i %i %i", this.func_197554_b().getRegistryName(), this.diameter, this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue());
    }
}

