/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;

public class PokeBallRenderer
extends EntityRenderer<PokeBallEntity> {
    private static final String PATH = "pixelmon:textures/pokeballs/";

    public PokeBallRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(PokeBallEntity pokeball, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLightIn) {
        float[] color;
        if (pokeball.func_226278_cu_() < -30.0) {
            return;
        }
        matrix.func_227860_a_();
        int id = pokeball.getPairedEntity();
        Entity pair = pokeball.field_70170_p.func_73045_a(id);
        if (!Float.isNaN(pokeball.clientRotation)) {
            matrix.func_227863_a_(QuaternionHelper.fromEuler(pokeball.clientRotation, 0.0f, 1.0f, 0.0f));
        } else if (pair != null) {
            pokeball.func_200602_a(EntityAnchorArgument.Type.EYES, pair.func_213303_ch());
            pokeball.clientRotation = -pokeball.field_70177_z;
            matrix.func_227863_a_(QuaternionHelper.fromEuler(pokeball.clientRotation, 0.0f, 1.0f, 0.0f));
        } else {
            Quaternion q1 = QuaternionHelper.fromEuler(-pokeball.getInitialPitch(), -((float)Math.cos((double)pokeball.getInitialYaw() * Math.PI / 180.0)), 0.0f, -((float)Math.sin((double)pokeball.getInitialYaw() * Math.PI / 180.0)));
            Quaternion q2 = QuaternionHelper.fromEuler(pokeball.field_70177_z, 0.0f, 1.0f, 0.0f);
            q1.func_195890_a(q2);
            matrix.func_227863_a_(q1);
        }
        GenericModelHolder<ModelPokeballs> model = pokeball.getBallType().getModelHolder(true);
        pokeball.setModel((ModelPokeballs)((Object)model.getModel()));
        ((ModelPokeballs)((Object)model.getModel())).setupForRender(pokeball);
        ((ModelPokeballs)((Object)model.getModel())).theModel.animate();
        boolean flash = pokeball.getShakeCount() == (pokeball.getCritical() ? 1 : 4) && pokeball.getIsWaiting() && pokeball.getWaitTimer() < 1;
        int packedOverlay = OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false));
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.resolveTexture(pokeball, flash)));
        if (!pokeball.getIsWaiting()) {
            pokeball.premierFlash();
        }
        if (pokeball.getMode() == PokeBallMode.EMPTY && pokeball.getAnimation() == AnimationType.BOUNCEOPEN) {
            pokeball.onCaptureAttemptEffect();
        }
        if (pokeball.getShakeCount() == (pokeball.getCritical() ? 1 : 4) && pokeball.getIsWaiting() && pokeball.getWaitTimer() < 1) {
            color = new float[]{0.006f, 0.006f, 0.006f, 1.0f};
            pokeball.successfulCaptureEffect();
            pokeball.setAnimation(AnimationType.IDLE);
        } else {
            color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        if (pokeball.getMode() == PokeBallMode.FULL && pokeball.getAnimation() == AnimationType.BOUNCECLOSED) {
            pokeball.releaseEffect();
        }
        ((ModelPokeballs)((Object)model.getModel())).partialTick = partialTicks;
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.0033333334f, 0.0033333334f, 0.0033333334f);
        if (pokeball.field_70173_aa >= 2) {
            ((ModelPokeballs)((Object)model.getModel())).render((Entity)pokeball, matrix, vertices, packedLightIn, packedOverlay, color[0], color[1], color[2], color[3]);
        }
        matrix.func_227865_b_();
        matrix.func_227865_b_();
        RenderSystem.enableCull();
    }

    public ResourceLocation getTextureLocation(PokeBallEntity pokeball) {
        return pokeball.getBallType().getModelTexture();
    }

    public ResourceLocation resolveTexture(PokeBallEntity pokeball, boolean flash) {
        return flash ? pokeball.getBallType().getFlashingTexture() : this.getTextureLocation(pokeball);
    }
}

