/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.item;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.items.ShrineOrbItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.IModelData;

public class ItemRendererShrineOrb
extends PerspectiveMapWrapper {
    public static final ModelResourceLocation uno = new ModelResourceLocation("pixelmon:uno_orb", "inventory");
    public static final ModelResourceLocation dos = new ModelResourceLocation("pixelmon:dos_orb", "inventory");
    public static final ModelResourceLocation tres = new ModelResourceLocation("pixelmon:tres_orb", "inventory");
    IBakedModel model;
    private float percent;
    private float height;
    Item orbType;

    public ItemRendererShrineOrb(IBakedModel model) {
        super(model, (IModelTransform)SimpleModelTransform.IDENTITY);
        this.model = model;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.func_177554_e();
    }

    public boolean func_177556_c() {
        return this.model.func_177556_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new OverrideList();
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quadList = new ArrayList<BakedQuad>(6);
        TextureAtlasSprite orbTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(ResourceLocationHelper.of("pixelmon:items/back"));
        quadList.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)orbTexture, (TransformationMatrix)TransformationMatrix.func_227983_a_()));
        if (this.orbType == PixelmonItems.uno_orb.getItem()) {
            orbTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(ResourceLocationHelper.of("pixelmon:items/unoorb"));
        } else if (this.orbType == PixelmonItems.dos_orb.getItem()) {
            orbTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(ResourceLocationHelper.of("pixelmon:items/dosorb"));
        } else if (this.orbType == PixelmonItems.tres_orb.getItem()) {
            orbTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(ResourceLocationHelper.of("pixelmon:items/tresorb"));
        }
        if (this.height >= 1.0f) {
            quadList.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)orbTexture, (TransformationMatrix)TransformationMatrix.func_227983_a_()));
        }
        orbTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(ResourceLocationHelper.of("pixelmon:items/front"));
        quadList.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)orbTexture, (TransformationMatrix)TransformationMatrix.func_227983_a_()));
        return quadList;
    }

    private void addQuad(List<BakedQuad> quadList, TextureAtlasSprite texture, float xEnd, float yEnd, float zEnd, float uStart, float vStart, float uEnd, float vEnd) {
        int x = Float.floatToRawIntBits(xEnd);
        int y = Float.floatToRawIntBits(yEnd);
        int z = Float.floatToRawIntBits(zEnd);
        int us = Float.floatToRawIntBits(texture.func_94214_a((double)uStart));
        int ue = Float.floatToRawIntBits(texture.func_94214_a((double)uEnd));
        int vs = Float.floatToIntBits(texture.func_94207_b((double)vStart));
        int ve = Float.floatToIntBits(texture.func_94207_b((double)vEnd));
        int white = Color.white.getRGB();
        BakedQuad orbQuad = new BakedQuad(new int[]{x, 0, z, white, ue, ve, 0, x, y, z, white, ue, vs, 0, 0, y, z, white, us, vs, 0, 0, 0, z, white, us, ve, 0}, 0, Direction.SOUTH, texture, false);
        quadList.add(orbQuad);
        int zn = Float.floatToRawIntBits(-zEnd);
        orbQuad = new BakedQuad(new int[]{0, 0, zn, white, ue, ve, 0, 0, y, zn, white, ue, vs, 0, x, y, zn, white, us, vs, 0, x, 0, zn, white, us, ve, 0}, 0, Direction.NORTH, texture, false);
        quadList.add(orbQuad);
    }

    private class OverrideList
    extends ItemOverrideList {
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, ClientWorld world, LivingEntity entity) {
            if (originalModel instanceof ItemRendererShrineOrb) {
                ItemRendererShrineOrb orb = (ItemRendererShrineOrb)originalModel;
                int pokemonKilled = stack.func_77952_i();
                orb.height = (float)pokemonKilled / (float)ShrineOrbItem.full;
                orb.percent = orb.height * 16.0f;
                orb.orbType = stack.func_77973_b();
            }
            return originalModel;
        }
    }
}

