/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class LayerCharms
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final ResourceLocation shinyCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/shiny_charm.png");
    private final ResourceLocation ovalCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/oval_charm.png");
    private final ResourceLocation expCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/exp_charm.png");
    private final ResourceLocation catchingCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/catching_charm.png");
    private final ResourceLocation markCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/mark_charm.png");
    private final Model shinyCharmModel = CustomModel.SHINY_CHARM.getModel();
    private final Model ovalCharmModel = CustomModel.OVAL_CHARM.getModel();
    private final Model expCharmModel = CustomModel.EXP_CHARM.getModel();
    private final Model catchingCharmModel = CustomModel.CATCHING_CHARM.getModel();
    private final Model markCharmModel = CustomModel.MARK_CHARM.getModel();
    private final PlayerRenderer renderer;
    private static final float[][] yz = new float[][]{{0.7f, 0.04f}, {0.7f, -0.04f}, {0.8f, 0.08f}, {0.8f, 0.0f}, {0.8f, -0.08f}};
    private static final float[][] syz = new float[][]{{0.8f, 0.38f}, {0.85f, 0.3f}, {0.85f, 0.42f}, {0.9f, 0.34f}, {0.95f, 0.26f}};

    public LayerCharms(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("layer_charm_wear");
        float scale = 1.0f;
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        int i = 0;
        for (EnumCharms charm : EnumCharms.values()) {
            boolean render = false;
            ResourceLocation texture = null;
            Model model = null;
            switch (charm) {
                case Shiny: {
                    if (!EntityPlayerExtension.getPlayerShinyCharm((PlayerEntity)player).isActive()) break;
                    render = true;
                    texture = this.shinyCharmTexture;
                    model = this.shinyCharmModel;
                    break;
                }
                case Oval: {
                    if (!EntityPlayerExtension.getPlayerOvalCharm((PlayerEntity)player).isActive()) break;
                    render = true;
                    texture = this.ovalCharmTexture;
                    model = this.ovalCharmModel;
                    break;
                }
                case Exp: {
                    if (!EntityPlayerExtension.getPlayerExpCharm((PlayerEntity)player).isActive()) break;
                    render = true;
                    texture = this.expCharmTexture;
                    model = this.expCharmModel;
                    break;
                }
                case Catching: {
                    if (!EntityPlayerExtension.getPlayerCatchingCharm((PlayerEntity)player).isActive()) break;
                    render = true;
                    texture = this.catchingCharmTexture;
                    model = this.catchingCharmModel;
                    break;
                }
                case Mark: {
                    if (!EntityPlayerExtension.getPlayerMarkCharm((PlayerEntity)player).isActive()) break;
                    render = true;
                    texture = this.markCharmTexture;
                    model = this.markCharmModel;
                }
            }
            if (render) {
                matrix.func_227860_a_();
                if (player.func_213453_ef()) {
                    matrix.func_227861_a_((double)-0.2525f, (double)syz[i][0], (double)syz[i][1]);
                } else {
                    matrix.func_227861_a_((double)-0.2525f, (double)yz[i][0], (double)yz[i][1]);
                }
                scale = 3.5E-4f;
                matrix.func_227862_a_(scale, scale, scale);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227861_a_((double)-0.3f, 0.0, 0.875);
                if (model instanceof GenericSmdModel) {
                    ((GenericSmdModel)model).getModel().animate();
                } else if (model instanceof ValveStudioModel) {
                    ((ValveStudioModel)model).animate();
                }
                model.func_225598_a_(matrix, buffer.getBuffer(PixelmonRendering.getSMDCulledRenderType(texture)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                matrix.func_227865_b_();
            }
            ++i;
        }
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }
}

