/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundNBT;

public class PixelmonStatsData {
    public int HP;
    public int Speed;
    public int Attack;
    public int Defense;
    public int SpecialAttack;
    public int SpecialDefense;

    public PixelmonStatsData() {
    }

    public PixelmonStatsData(CompoundNBT nbt) {
        this.HP = nbt.func_74762_e("StatsHP");
        this.Speed = nbt.func_74762_e("StatsSpeed");
        this.Attack = nbt.func_74762_e("StatsAttack");
        this.Defense = nbt.func_74762_e("StatsDefense");
        this.SpecialAttack = nbt.func_74762_e("StatsSpecialAttack");
        this.SpecialDefense = nbt.func_74762_e("StatsSpecialDefense");
    }

    public PixelmonStatsData(PermanentStats permanentStats) {
        this.HP = permanentStats.getHP();
        this.Attack = permanentStats.getAttack();
        this.Defense = permanentStats.getDefense();
        this.SpecialAttack = permanentStats.getSpecialAttack();
        this.SpecialDefense = permanentStats.getSpecialDefense();
        this.Speed = permanentStats.getSpeed();
    }

    public static PixelmonStatsData createPacket(PokemonLink pixelmon) {
        PixelmonStatsData p = new PixelmonStatsData();
        PermanentStats permanentStats = pixelmon.getStats();
        p.HP = permanentStats.getHP();
        p.Speed = permanentStats.getSpeed();
        p.Attack = permanentStats.getAttack();
        p.Defense = permanentStats.getDefense();
        p.SpecialAttack = permanentStats.getSpecialAttack();
        p.SpecialDefense = permanentStats.getSpecialDefense();
        return p;
    }

    public void writePacketData(ByteBuf buffer) {
        buffer.writeShort((int)((short)this.HP));
        buffer.writeShort((int)((short)this.Speed));
        buffer.writeShort((int)((short)this.Attack));
        buffer.writeShort((int)((short)this.Defense));
        buffer.writeShort((int)((short)this.SpecialAttack));
        buffer.writeShort((int)((short)this.SpecialDefense));
    }

    public void readPacketData(ByteBuf data) {
        this.HP = data.readShort();
        this.Speed = data.readShort();
        this.Attack = data.readShort();
        this.Defense = data.readShort();
        this.SpecialAttack = data.readShort();
        this.SpecialDefense = data.readShort();
    }
}

