/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class StopStartLevellingPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemonUUID;

    public StopStartLevellingPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public StopStartLevellingPacket(StoragePosition position, UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.position = StoragePosition.decode((ByteBuf)buffer);
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public void encode(PacketBuffer buffer) {
        this.position.encode((ByteBuf)buffer);
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        Pokemon pokemon = StorageProxy.getPokemon(player, this.position);
        if (pokemon == null || !pokemon.getUUID().equals(this.pokemonUUID)) {
            return;
        }
        pokemon.setDoesLevel(!pokemon.doesLevel());
    }
}

