/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ReturnBagItemsPacket
extends AbstractPixelmonPacket {
    private BagSection section;
    protected List<ItemData> itemData;

    public ReturnBagItemsPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public ReturnBagItemsPacket(boolean sync) {
        super(PacketDirection.PLAY_CLIENT, sync);
    }

    public ReturnBagItemsPacket(BagSection section, List<ItemData> itemData) {
        this();
        this.section = section;
        this.itemData = itemData;
    }

    public ReturnBagItemsPacket(BagSection section, List<ItemData> itemData, boolean sync) {
        this(sync);
        this.section = section;
        this.itemData = itemData;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.section.ordinal());
        buffer.writeInt(this.itemData.size());
        for (ItemData itemDatum : this.itemData) {
            itemDatum.encode(buffer);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.section = BagSection.values()[buffer.readInt()];
        int size = buffer.readInt();
        this.itemData = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.itemData.add(ItemData.deocde(buffer));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.sections.put(this.section, this.itemData);
    }
}

