/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules;

import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ProposeBattleRulesPacket
extends AbstractPixelmonPacket {
    private int queryID;
    private BattleRules rules;

    public ProposeBattleRulesPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ProposeBattleRulesPacket(int queryID, BattleRules rules) {
        super(PacketDirection.PLAY_SERVER);
        this.queryID = queryID;
        this.rules = rules;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.queryID);
        this.rules.encodeInto(buf);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.queryID = buf.readInt();
        this.rules = new BattleRules();
        this.rules.decodeInto(buf);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        BattleQuery query = BattleQuery.getQuery(this.queryID);
        if (query == null) {
            return;
        }
        ServerPlayerEntity player = context.getSender();
        query.proposeRules(player, this.rules);
    }
}

