/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.mail;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.MailEvent;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.heldItems.MailItem;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class MailPacket
extends AbstractPixelmonPacket {
    private boolean sealed;
    private String contents;

    public MailPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public MailPacket(Boolean sealed, String contents) {
        super(PacketDirection.PLAY_SERVER, true);
        this.sealed = sealed;
        this.contents = contents;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.sealed = buf.readBoolean();
        this.contents = buf.func_218666_n();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.sealed);
        buf.func_180714_a(this.contents);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ItemStack letter = player.func_184614_ca();
        if (letter.func_190926_b() || !(letter.func_77973_b() instanceof MailItem)) {
            return;
        }
        if (letter.func_77973_b().getRegistryName().func_110623_a().contains("closed")) {
            return;
        }
        if (this.contents.split("\n").length > 14) {
            return;
        }
        for (String line : this.contents.split("\n")) {
            if (line.length() <= 200) continue;
            return;
        }
        MailEvent.EditMail.Pre preEdit = new MailEvent.EditMail.Pre(player, letter, letter.func_196082_o().func_74779_i("contents"), this.contents);
        if (Pixelmon.EVENT_BUS.post((Event)preEdit)) {
            return;
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("author", (INBT)StringNBT.func_229705_a_((String)player.func_200200_C_().getString()));
        compoundNBT.func_218657_a("contents", (INBT)StringNBT.func_229705_a_((String)this.contents));
        compoundNBT.func_218657_a("editable", (INBT)ByteNBT.func_229672_a_((boolean)true));
        Pixelmon.EVENT_BUS.post((Event)new MailEvent.EditMail.Post(player, preEdit.getMailItem(), preEdit.getBeforeText(), preEdit.getAfterText()));
        ItemStack stack = new ItemStack((IItemProvider)(this.sealed ? ((MailItem)letter.func_77973_b()).getClosed() : letter.func_77973_b()), 1);
        stack.func_77982_d(compoundNBT);
        MailEvent.SealMail.Pre preSeal = null;
        if (this.sealed) {
            preSeal = new MailEvent.SealMail.Pre(player, preEdit.getMailItem(), stack, preEdit.getAfterText(), player.func_200200_C_().getString());
            if (Pixelmon.EVENT_BUS.post((Event)preSeal)) {
                stack = new ItemStack((IItemProvider)letter.func_77973_b(), 1);
                stack.func_77982_d(compoundNBT);
            } else {
                compoundNBT.func_218657_a("author", (INBT)StringNBT.func_229705_a_((String)preSeal.getAuthor()));
                compoundNBT.func_218657_a("contents", (INBT)StringNBT.func_229705_a_((String)preSeal.getText()));
                compoundNBT.func_218657_a("editable", (INBT)ByteNBT.func_229672_a_((boolean)false));
                stack.func_77982_d(compoundNBT);
            }
        }
        if (preEdit.getMailItem().func_190916_E() > 1) {
            preEdit.getMailItem().func_190918_g(1);
        } else {
            player.field_71071_by.func_184437_d(preEdit.getMailItem());
        }
        player.func_191521_c(stack);
        player.field_71069_bz.func_75142_b();
        if (this.sealed) {
            Pixelmon.EVENT_BUS.post((Event)new MailEvent.SealMail.Post(player, preSeal.getOpenItemStack(), preSeal.getSealedItemStack(), preSeal.getText(), preSeal.getAuthor()));
        }
    }
}

