/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ChattingNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.QuestGiverNPCEditorScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetChattingNPCTexturesPacket
extends AbstractPixelmonPacket {
    private List<ClientNPCData> data = Lists.newArrayList();

    public SetChattingNPCTexturesPacket() {
        super(PacketDirection.PLAY_CLIENT);
        for (GeneralNPCData generalData : ServerNPCRegistry.getEnglishNPCs()) {
            for (String texture : generalData.getTextures()) {
                this.data.add(new ClientNPCData(generalData.id, texture));
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        ArrayHelper.encodeList(buf, this.data);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.data.clear();
        int listSize = buf.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.data.add(new ClientNPCData(buf));
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        QuestGiverNPCEditorScreen.npcData = this.data;
        ChattingNPCEditorScreen.npcData = QuestGiverNPCEditorScreen.npcData;
    }
}

