/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.client.gui.npc.AbstractShopScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ChattingNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ClientShopItem;
import com.pixelmonmod.pixelmon.client.gui.npc.QuestGiverNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ShopkeeperScreen;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperChat;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetNPCDataPacket
extends AbstractPixelmonPacket {
    private SetTrainerData data;
    private EnumNPCType npcType;
    private ArrayList<String> chatPages;
    private String name;
    private ArrayList<ShopItemWithVariation> buyList;
    private ArrayList<ShopItemWithVariation> sellList;
    private ArrayList<ClientShopItem> clientBuyList;
    private ArrayList<ClientShopItem> clientSellList;
    private ShopkeeperChat skChat;

    public SetNPCDataPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetNPCDataPacket(String name, ArrayList<String> chatPages) {
        this(name, chatPages, EnumNPCType.ChattingNPC);
    }

    public SetNPCDataPacket(String name, ArrayList<String> chatPages, EnumNPCType type) {
        super(PacketDirection.PLAY_CLIENT);
        this.name = name;
        this.npcType = type;
        this.chatPages = chatPages;
    }

    public SetNPCDataPacket(String name, ShopkeeperChat chat, ArrayList<ShopItemWithVariation> buyList, ArrayList<ShopItemWithVariation> sellList2) {
        super(PacketDirection.PLAY_CLIENT);
        this.name = name;
        this.npcType = EnumNPCType.Shopkeeper;
        this.skChat = chat;
        this.buyList = buyList;
        this.sellList = sellList2;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.npcType.ordinal());
        switch (this.npcType) {
            case ChattingNPC: 
            case QuestGiver: {
                buffer.func_180714_a(this.name);
                buffer.writeShort(this.chatPages.size());
                for (String page : this.chatPages) {
                    buffer.func_180714_a(page);
                }
                break;
            }
            case Shopkeeper: {
                buffer.func_180714_a(this.name);
                this.skChat.writeToBuffer(buffer);
                buffer.writeShort(this.buyList.size());
                for (ShopItemWithVariation item : this.buyList) {
                    item.writeToBuffer(buffer);
                }
                buffer.writeShort(this.sellList.size());
                for (ShopItemWithVariation item : this.sellList) {
                    item.writeToBuffer(buffer);
                }
                break;
            }
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.npcType = EnumNPCType.getFromOrdinal(buffer.readShort());
        switch (this.npcType) {
            case ChattingNPC: 
            case QuestGiver: {
                this.name = buffer.func_218666_n();
                this.chatPages = new ArrayList();
                int numPages = buffer.readShort();
                for (int i = 0; i < numPages; ++i) {
                    this.chatPages.add(buffer.func_218666_n());
                }
                break;
            }
            case Shopkeeper: {
                int i;
                this.name = buffer.func_218666_n();
                this.skChat = ShopkeeperChat.loadFromBuffer(buffer);
                int numItems = buffer.readShort();
                this.clientBuyList = new ArrayList();
                for (i = 0; i < numItems; ++i) {
                    this.clientBuyList.add(ClientShopItem.fromBuffer(buffer));
                }
                numItems = buffer.readShort();
                this.clientSellList = new ArrayList();
                for (i = 0; i < numItems; ++i) {
                    this.clientSellList.add(ClientShopItem.fromBuffer(buffer));
                }
                break;
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        switch (this.npcType) {
            case ChattingNPC: {
                ChattingNPCScreen.name = this.name;
                ChattingNPCScreen.chatPages = this.chatPages;
                break;
            }
            case QuestGiver: {
                QuestGiverNPCScreen.name = this.name;
                QuestGiverNPCScreen.chatPages = this.chatPages;
                break;
            }
            case Shopkeeper: {
                ShopkeeperScreen.name = this.name;
                ShopkeeperScreen.chat = this.skChat;
                AbstractShopScreen.buyItems = this.clientBuyList;
                AbstractShopScreen.sellItems = this.clientSellList;
                break;
            }
        }
    }
}

