/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemonPacket;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdatePlayerPokemonPacket
extends UpdateEditedPokemonPacket {
    private UUID playerUUID;

    public UpdatePlayerPokemonPacket() {
    }

    public UpdatePlayerPokemonPacket(Pokemon data) {
        super(data);
        this.playerUUID = PokemonEditorPartyScreen.editedPlayerUUID;
    }

    public UpdatePlayerPokemonPacket(Pokemon data, int slot) {
        super(data, slot);
        this.playerUUID = PokemonEditorPartyScreen.editedPlayerUUID;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        super.encode(buffer);
        buffer.func_179252_a(this.playerUUID);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        super.decode(buffer);
        this.playerUUID = buffer.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        if (!PokemonEditorItem.checkPermission(sender)) {
            return;
        }
        ServerPlayerEntity player = sender.func_184102_h().func_184103_al().func_177451_a(this.playerUUID);
        if (player != null) {
            PlayerPartyStorage party = StorageProxy.getParty(player);
            int slot = party.getSlot(this.data);
            if (this.slot == -1) {
                if (slot == -1) {
                    party.add(this.data);
                } else {
                    Pokemon current = party.get(slot);
                    if (current != null && current.getPersistentData() != null) {
                        this.data.getPersistentData().func_197643_a(current.getPersistentData());
                    }
                    party.set(slot, this.data);
                }
            }
            UpdatePlayerPokemonPacket.updatePokemon(this, player, party);
            PokemonEditorItem.updateSinglePokemon(sender, this.playerUUID, party.getSlot(this.data));
        }
    }
}

