/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.raids;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.CloseRaidPacket;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RaidActionPacket
extends AbstractPixelmonPacket {
    private int den;
    private int action;
    private int slot;
    private ItemStack usedStack = null;
    private int stackCount;

    public RaidActionPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RaidActionPacket(int den, int action) {
        this(den, action, 0);
    }

    public RaidActionPacket(int den, int action, int slot) {
        this();
        this.den = den;
        this.action = action;
        this.slot = slot;
    }

    public RaidActionPacket(int den, int action, int slot, ItemStack usedStack) {
        this();
        this.den = den;
        this.action = action;
        this.slot = slot;
        this.usedStack = usedStack;
        if (this.usedStack != null) {
            this.stackCount = this.usedStack.func_190916_E();
            this.usedStack.func_190920_e(1);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.den = buf.readInt();
        this.action = buf.readInt();
        this.slot = buf.readInt();
        if (buf.readBoolean()) {
            this.usedStack = buf.func_150791_c();
            this.stackCount = buf.readInt();
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.den);
        buf.writeInt(this.action);
        buf.writeInt(this.slot);
        buf.writeBoolean(this.usedStack != null);
        if (this.usedStack != null) {
            buf.func_150788_a(this.usedStack);
            buf.writeInt(this.stackCount);
        }
    }

    @Override
    public void handlePacket(NetworkEvent.Context context) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            ServerWorld world;
            Entity entity;
            ServerPlayerEntity player = context.getSender();
            if (player != null && (entity = (world = player.func_71121_q()).func_73045_a(this.den)) instanceof DenEntity) {
                DenEntity den = (DenEntity)entity;
                RaidData raid = den.getServerData();
                if ((raid == null || raid.getPlayer(player) == null) && (raid = den.getInUseRaidData()) != null && raid.getPlayer(player) == null) {
                    raid = null;
                }
                if (raid != null) {
                    if (den.func_70032_d((Entity)player) <= 30.0f) {
                        if (this.usedStack != null && this.stackCount > 0) {
                            this.usedStack.func_190920_e(this.stackCount);
                        }
                        raid.processAction(this.action, this.slot, this.usedStack, player);
                    } else {
                        raid.removePlayer(player);
                    }
                } else {
                    NetworkHelper.sendPacket(new CloseRaidPacket(), player);
                }
            }
        });
    }
}

