/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trading;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.ClientTradingManager;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetTradeTargetPacket
extends AbstractPixelmonPacket {
    private Pokemon data;
    private PixelmonStatsData stats;
    boolean clear = false;

    public SetTradeTargetPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetTradeTargetPacket(Pokemon data, PixelmonStatsData stats) {
        super(PacketDirection.PLAY_CLIENT);
        this.data = data;
        this.stats = stats;
    }

    public SetTradeTargetPacket(boolean clear) {
        super(PacketDirection.PLAY_CLIENT);
        this.clear = clear;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.clear);
        if (!this.clear) {
            this.data.writeToByteBuffer(buffer, EnumUpdateType.CLIENT);
            this.stats.writePacketData((ByteBuf)buffer);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.clear = buffer.readBoolean();
        if (!this.clear) {
            this.data = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buffer, EnumUpdateType.CLIENT);
            this.stats = new PixelmonStatsData();
            this.stats.readPacketData((ByteBuf)buffer);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (this.clear) {
            ClientTradingManager.tradeTarget = null;
            ClientTradingManager.tradeTargetStats = null;
            ClientTradingManager.player1Ready = false;
            ClientTradingManager.player2Ready = false;
        } else {
            ClientTradingManager.tradeTarget = this.data;
            ClientTradingManager.tradeTargetStats = this.stats;
            ClientTradingManager.player1Ready = false;
            ClientTradingManager.player2Ready = false;
        }
    }
}

