/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class FillDexCommand
extends PixelCommand {
    public FillDexCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "filldex", "/filldex [player] [percentage]", 4);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0);
        int percentage = this.parsePercent(args);
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = StorageProxy.getParty(target);
        int dex = 1;
        while (storage.playerPokedex.getCaughtCompletionPercentage() < (float)percentage) {
            storage.playerPokedex.set(dex, PokedexRegistrationStatus.CAUGHT);
            ++dex;
        }
        storage.playerPokedex.update();
    }

    private int parsePercent(String ... args) {
        if (args.length < 2) {
            return 100;
        }
        return NumberHelper.parseInteger(args[1]).orElse(100);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

