/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerStats;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class Stats
extends PixelCommand {
    public Stats(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher);
    }

    @Override
    public String getName() {
        return "pokestats";
    }

    @Override
    public String getUsage(CommandSource sender) {
        return "/pokestats [player]";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        args = this.setupTargetOrSourceAsTarget(sender, args, 0);
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        boolean isSelf = sender.func_197019_b().getString().equalsIgnoreCase(target.func_145748_c_().getString());
        PixelmonCommandUtils.sendMessage(sender, isSelf ? "pixelmon.command.stats.yourstats" : "pixelmon.command.stats.playerstats", target.func_145748_c_().getString());
        PlayerPartyStorage party = StorageProxy.getParty(target);
        PlayerStats stats = party.stats;
        PixelmonCommandUtils.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.stats.wins", stats.getWins());
        PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.stats.losses", stats.getLosses());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

