/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerStats;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class StatsReset
extends PixelCommand {
    public StatsReset(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher);
    }

    @Override
    public String getName() {
        return "resetpokestats";
    }

    @Override
    public String getUsage(CommandSource sender) {
        return "/resetpokestats <player>";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length != 1) {
            PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
            return;
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage party = StorageProxy.getParty(player);
        PlayerStats stats = party.stats;
        stats.resetWinLoss();
        PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.statsreset.reset", player.func_200200_C_().getString());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

