/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.InteractNPCPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class NPCRelearner
extends NPCEntity {
    public static final DataSync<NPCRelearner, ItemStack> SYNC_COST = new DataSync<NPCRelearner, ItemStack>(NPCRelearner.class, DataSerializers.field_187196_f, (npcEntity, s) -> {
        npcEntity.cost = s;
    });
    private ItemStack cost;

    public NPCRelearner(EntityType<NPCRelearner> type, World world) {
        super(type, world);
    }

    public NPCRelearner(World world) {
        this((EntityType<NPCRelearner>)((EntityType)EntityRegistration.NPC_RELEARNER.get()), world);
        this.init(new TranslationTextComponent("pixelmon.npc.relearnername").getString());
    }

    @Override
    protected void func_70088_a() {
        this.define(SYNC_COST, ItemStack.field_190927_a);
        super.func_70088_a();
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/npcchat1.png";
    }

    @Override
    public String getDisplayText() {
        return I18n.func_135052_a((String)"pixelmon.npc.relearnername", (Object[])new Object[0]);
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public ItemStack getCost() {
        ItemStack cost = this.cost;
        if (cost.func_190926_b() || cost.func_77973_b() instanceof NPCEditorItem || cost.func_77973_b() == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        return cost;
    }

    public void setCost(ItemStack item) {
        SYNC_COST.set((Entity)this, (Object)item);
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        if (player instanceof ServerPlayerEntity) {
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.Relearner, player))) {
                return false;
            }
            ItemStack cost = this.getCost();
            ItemStack itemstack = player.func_184586_b(hand);
            if (player.func_184812_l_()) {
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77973_b() instanceof NPCEditorItem) {
                        this.openRelearnerGui(player);
                    } else if (cost.func_190926_b() || cost.func_77973_b() != itemstack.func_77973_b() || cost.func_77952_i() != itemstack.func_77952_i()) {
                        cost = player.func_225608_bj_() ? new ItemStack((IItemProvider)itemstack.func_77973_b(), 1, itemstack.serializeNBT()) : itemstack.func_77946_l();
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnersetitem", cost.func_200301_q(), cost.func_190916_E());
                    } else if (cost.func_190916_E() != cost.func_77976_d()) {
                        cost.func_190917_f(1);
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnersetitem", cost.func_200301_q(), cost.func_190916_E());
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnerfull", new Object[0]);
                    }
                } else if (!cost.func_190926_b()) {
                    cost.func_190918_g(1);
                    if (cost.func_190916_E() <= 0) {
                        cost = ItemStack.field_190927_a;
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnernoitem", new Object[0]);
                        this.setCost(cost);
                    } else {
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnersetitem", cost.func_200301_q(), cost.func_190916_E());
                    }
                } else {
                    this.openRelearnerGui(player);
                }
            } else if (this.checkCost(itemstack)) {
                this.openRelearnerGui(player);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnercost", cost.func_200301_q(), cost.func_190916_E());
            }
        } else {
            this.field_70714_bg.func_220888_c().forEach(arg_0 -> ((GoalSelector)this.field_70714_bg).func_85156_a(arg_0));
        }
        return true;
    }

    public boolean checkCost(ItemStack hand) {
        ItemStack cost = this.getCost();
        if (cost.func_190926_b()) {
            return true;
        }
        return ItemStack.func_179545_c((ItemStack)cost, (ItemStack)hand) && hand.func_190916_E() >= cost.func_190916_E() && (!cost.func_77942_o() || cost.func_77978_p().equals((Object)hand.func_77978_p()));
    }

    public void openRelearnerGui(PlayerEntity player) {
        NetworkHelper.sendPacket(new InteractNPCPacket(this.getNPCID(), EnumNPCType.Relearner), (ServerPlayerEntity)player);
        OpenScreenPacket.open(player, EnumGuiScreen.ChooseRelearnMove, new int[0]);
    }

    public static List<ImmutableAttack> getRelearnableMoves(Pokemon pokemon) {
        ArrayList<ImmutableAttack> attackList = new ArrayList<ImmutableAttack>(pokemon.getRelearnableMoves());
        List<ImmutableAttack> levelUpList = pokemon.getForm().getMoves().getMovesUpToLevel(pokemon.getPokemonLevel());
        for (int i = levelUpList.size() - 1; i >= 0; --i) {
            ImmutableAttack move = levelUpList.get(i);
            if (attackList.contains(move)) continue;
            attackList.add(move);
        }
        for (Attack attack : pokemon.getMoveset()) {
            if (attack == null) continue;
            attackList.remove(attack.getActualMove());
        }
        return attackList;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        ItemStack cost = this.getCost();
        if (!cost.func_190926_b()) {
            CompoundNBT stack = cost.serializeNBT();
            nbt.func_218657_a("RelearnerCostStack", (INBT)stack);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("RelearnerCostStack")) {
            this.setCost(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("RelearnerCostStack")));
        } else if (nbt.func_74764_b("Cost")) {
            ItemStack cost = new ItemStack((IItemProvider)Item.func_150899_d((int)nbt.func_74762_e("Cost")), nbt.func_74762_e("costNum"));
            cost.func_196085_b(nbt.func_74762_e("CostDamage"));
            this.setCost(cost);
        }
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_220892_d.clear();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
                this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, Attributes.field_233821_d_.func_111110_b()));
                break;
            }
        }
    }

    @Override
    public boolean func_70104_M() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }
}

