/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.PixelBlockSnapshot;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.FossilBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import javax.swing.Timer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RockSmash {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("rock_smash").setName("pixelmon.moveskill.rock_smash").describe("pixelmon.moveskill.rock_smash.description1", "pixelmon.moveskill.rock_smash.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/rocksmash.png")).setDefaultCooldownTicks(800).setUsePP(true).setAnyMoves("Rock Smash");
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            World world = pixelmon.field_70170_p;
            BlockPos pos = (BlockPos)tup.func_76341_a();
            BlockState state = world.func_180495_p(pos);
            if (state.func_185904_a() != Material.field_151576_e || state.func_177230_c() == Blocks.field_150357_h) {
                return -1;
            }
            if (state.func_177230_c() instanceof MultiBlock || state.func_177230_c() instanceof FossilBlock) {
                return -1;
            }
            ServerPlayerEntity owner = (ServerPlayerEntity)pixelmon.getOwner();
            if (owner.field_71134_c.func_73081_b() == GameType.ADVENTURE) {
                PixelBlockSnapshot snapshot = new PixelBlockSnapshot(world, pos, state);
                world.func_217377_a(pos, false);
                Timer timer = new Timer(7000, e -> owner.func_184102_h().execute(() -> snapshot.restoreToLocation(world, pos, true, true)));
                timer.setRepeats(false);
                timer.start();
            } else {
                ItemStack hand = owner.func_184582_a(EquipmentSlotType.MAINHAND);
                try {
                    owner.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    if (owner.field_71134_c.func_180237_b(pos) && !state.func_177230_c().canHarvestBlock(state, (IBlockReader)world, pos, (PlayerEntity)owner)) {
                        world.func_175655_b(pos, true);
                    }
                }
                finally {
                    owner.func_184201_a(EquipmentSlotType.MAINHAND, hand);
                }
            }
            BlockSpawningHandler.getInstance().performBattleStartCheck(world, pos, (Entity)pixelmon.getOwner(), (PixelmonEntity)pixelmon, BattleStartTypes.ROCKSMASH, state, new Object[0]);
            return moveSkill.cooldownTicks - pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
        });
        return moveSkill;
    }
}

