/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Teleport {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("teleport").setName("pixelmon.moveskill.teleport").describe("pixelmon.moveskill.teleport.description").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/teleport.png")).setDefaultCooldownTicks(20).setUsePP(true).setAnyMoves("Teleport");
        return moveSkill.setBehaviourNoTarget(Teleport.teleportAction(moveSkill, true));
    }

    public static Function<PixelmonEntity, Integer> teleportAction(MoveSkill moveSkill, boolean canChangeDim) {
        return pixelmon -> {
            if (pixelmon.hasOwner()) {
                ServerPlayerEntity player = (ServerPlayerEntity)pixelmon.getOwner();
                if (player == null) {
                    return -1;
                }
                PlayerPartyStorage party = StorageProxy.getParty(player);
                if (!canChangeDim && party.teleportPos.getDimension() != player.field_70170_p.func_234923_W_()) {
                    return -1;
                }
                if (party.teleportPos.getPosition().func_177956_o() == 0 && party.teleportPos.getPosition().func_177958_n() == 0 && party.teleportPos.getPosition().func_177952_p() == 0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.moveskill.teleport.failure"), Util.field_240973_b_);
                    return -1;
                }
                party.teleportPos.teleport(player);
                return moveSkill.cooldownTicks + (int)Math.max(0.0f, (300.0f - (float)pixelmon.getPokemon().getStat(BattleStatsType.SPEED)) / 50.0f * 20.0f);
            }
            return -1;
        };
    }
}

