/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import net.minecraft.command.ICommandSource;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class WeatherChanger {
    public static boolean allowMultiplayerWeather = false;

    public static MoveSkill createRainMoveSkill() {
        return WeatherChanger.createBaseMoveSkill("rain_dance", true).setName("pixelmon.moveskill.rain_dance").describe("pixelmon.moveskill.rain_dance.description1", "pixelmon.moveskill.rain_dance.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/raindance.png")).setAnyMoves("Rain Dance").setUsePP(true).setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpecification[]{PokemonSpecificationProxy.create("Kyogre")}));
    }

    public static MoveSkill createSunMoveSkill() {
        return WeatherChanger.createBaseMoveSkill("sunny_day", false).setName("pixelmon.moveskill.sunny_day").describe("pixelmon.moveskill.sunny_day.description1", "pixelmon.moveskill.sunny_day.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/sunnyday.png")).setAnyMoves("Sunny Day").setUsePP(true).setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpecification[]{PokemonSpecificationProxy.create("Groudon")}));
    }

    private static MoveSkill createBaseMoveSkill(String id, boolean rain) {
        MoveSkill moveSkill = new MoveSkill(id);
        moveSkill.setDefaultCooldownTicks(6000);
        moveSkill.setBehaviourNoTarget(pixelmon -> {
            if (!allowMultiplayerWeather && pixelmon.field_70170_p.func_73046_m().func_184103_al().func_72394_k() > 1 && pixelmon.field_70170_p.func_73046_m() instanceof DedicatedServer) {
                ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.weather.nomultiplayer", new Object[0]);
                return -1;
            }
            if (rain) {
                if (!pixelmon.field_70170_p.func_226660_f_(pixelmon.func_233580_cy_())) {
                    ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.weather.underground", pixelmon.func_145748_c_());
                    return -1;
                }
                if (pixelmon.field_70170_p.func_72896_J()) {
                    ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.rain_dance.alreadyraining", new Object[0]);
                    return -1;
                }
            } else {
                if (!pixelmon.field_70170_p.func_226660_f_(pixelmon.func_233580_cy_())) {
                    ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.weather.underground", pixelmon.func_145748_c_());
                    return -1;
                }
                if (!pixelmon.field_70170_p.func_72896_J()) {
                    ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.sunny_day.alreadysunny", new Object[0]);
                    return -1;
                }
            }
            pixelmon.field_70170_p.func_72912_H().func_76084_b(rain);
            if (pixelmon.getPokemon().getSpecies().is(PixelmonSpecies.KYOGRE) && rain) {
                ServerWorld serverWorld = (ServerWorld)pixelmon.field_70170_p;
                serverWorld.func_241113_a_(0, 6000, true, true);
                ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.WHITE, "pixelmon.moveskill.rain_dance.kyogreused", pixelmon.func_145748_c_());
            } else if (rain) {
                ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.WHITE, "pixelmon.moveskill.rain_dance.used", new Object[0]);
            } else {
                ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.WHITE, "pixelmon.moveskill.sunny_day.used", new Object[0]);
            }
            return moveSkill.cooldownTicks;
        });
        return moveSkill;
    }
}

