/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.events.PokeballEffectEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureHealth;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureValues;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.entities.pokeballs.EmptyPokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class PokeBallEntity
extends ThrowableEntity {
    private static final AnimationType[] ANIMS = new AnimationType[]{AnimationType.SHAKELEFT, AnimationType.SHAKERIGHT};
    public static final DataSync<PokeBallEntity, PokeBall> SYNC_POKEBALL_TYPE = new DataSync<PokeBallEntity, PokeBall>(PokeBallEntity.class, PixelmonDataSerializers.POKE_BALL_TYPE, (pokeBallEntity, o) -> {
        pokeBallEntity.pokeBallType = o;
    });
    public static final DataSync<PokeBallEntity, Boolean> SYNC_IS_WAITING = new DataSync<PokeBallEntity, Boolean>(PokeBallEntity.class, DataSerializers.field_187198_h, (pokeBallEntity, aBoolean) -> {
        pokeBallEntity.waiting = aBoolean;
    });
    public static final DataSync<PokeBallEntity, Boolean> SYNC_IS_ON_GROUND = new DataSync<PokeBallEntity, Boolean>(PokeBallEntity.class, DataSerializers.field_187198_h, (pokeBallEntity, aBoolean) -> {
        pokeBallEntity.onGround = aBoolean;
    });
    public static final DataSync<PokeBallEntity, Float> SYNC_INITIAL_YAW = new DataSync<PokeBallEntity, Float>(PokeBallEntity.class, DataSerializers.field_187193_c, (pokeBallEntity, aFloat) -> {
        pokeBallEntity.initialYaw = aFloat.floatValue();
    });
    public static final DataSync<PokeBallEntity, AnimationType> SYNC_ANIMATION = new DataSync<PokeBallEntity, AnimationType>(PokeBallEntity.class, PixelmonDataSerializers.ANIMATION_TYPE, (pokeBallEntity, o) -> {
        pokeBallEntity.animationType = o;
    });
    public static final DataSync<PokeBallEntity, Integer> SYNC_ID = new DataSync<PokeBallEntity, Integer>(PokeBallEntity.class, DataSerializers.field_187192_b, (pokeBallEntity, integer) -> {
        pokeBallEntity.pokeballId = integer;
    });
    public static final DataSync<PokeBallEntity, Float> SYNC_INITIAL_PITCH = new DataSync<PokeBallEntity, Float>(PokeBallEntity.class, DataSerializers.field_187193_c, (pokeBallEntity, aFloat) -> {
        pokeBallEntity.initialPitch = aFloat.floatValue();
    });
    public static final DataSync<PokeBallEntity, PokeBallMode> SYNC_MODE = new DataSync<PokeBallEntity, PokeBallMode>(PokeBallEntity.class, PixelmonDataSerializers.POKE_BALL_MODE, (pokeBallEntity, enumPokeBallMode) -> {
        pokeBallEntity.pokeBallMode = enumPokeBallMode;
    });
    protected static final DataSync<PokeBallEntity, Optional<UUID>> SYNC_OWNER = new DataSync<PokeBallEntity, Optional>(PokeBallEntity.class, DataSerializers.field_187203_m, (pokeBallEntity, uuid1) -> {
        pokeBallEntity.owner = uuid1.orElse(null);
    });
    protected static final DataSync<PokeBallEntity, Optional<UUID>> SYNC_POKE_UUID = new DataSync<PokeBallEntity, Optional>(PokeBallEntity.class, DataSerializers.field_187203_m, (pokeBallEntity, uuid1) -> {
        pokeBallEntity.pokeUUID = uuid1.orElse(null);
    });
    protected static final DataSync<PokeBallEntity, Byte> SYNC_SLOT = new DataSync<PokeBallEntity, Byte>(PokeBallEntity.class, DataSerializers.field_187191_a, (pokeBallEntity, aByte) -> {
        pokeBallEntity.slot = aByte.byteValue();
    });
    public static final DataSync<PokeBallEntity, Boolean> SYNC_CRITICAL = new DataSync<PokeBallEntity, Boolean>(PokeBallEntity.class, DataSerializers.field_187198_h, (pokeBallEntity, aBoolean) -> {
        pokeBallEntity.critical = aBoolean;
    });
    public static final DataSync<PokeBallEntity, Integer> SYNC_PAIRED_ENTITY = new DataSync<PokeBallEntity, Integer>(PokeBallEntity.class, DataSerializers.field_187192_b, (pokeBallEntity, integer) -> {
        pokeBallEntity.pairedEntity = integer;
    });
    protected final int ticksPerShake = 25;
    protected int waitTimer;
    public static final float SCALE = 0.0033333334f;
    protected LivingEntity thrower;
    protected PixelmonEntity pixelmon;
    protected float endRotationYaw = 0.0f;
    protected boolean dropItem;
    protected boolean canCatch = false;
    protected float openAngle = 0.0f;
    private Vector3d initPos;
    private Vector3d diff;
    protected float initialScale;
    public IncrementingVariable inc;
    private boolean firstContact = true;
    private boolean pausing = false;
    public AnimationType lastAnim = null;
    private int shakeCount = 0;
    private boolean startCapture = true;
    @OnlyIn(value=Dist.CLIENT)
    private ModelPokeballs model;
    private boolean capture1 = false;
    private boolean capture2 = false;
    public float clientRotation = Float.NaN;
    private PokeBall pokeBallType;
    private PokeBallMode pokeBallMode;
    private boolean waiting;
    private boolean onGround;
    private float initialYaw;
    private float initialPitch;
    private AnimationType animationType;
    private int pokeballId;
    private UUID owner;
    private UUID pokeUUID;
    private boolean critical;
    private int pairedEntity;
    protected int slot;
    protected EntityDataSyncManager dataSyncManager;
    String name = null;
    int numShakes = 0;

    public PokeBallEntity(EntityType<? extends PokeBallEntity> type, World world) {
        super(type, world);
    }

    public PokeBallEntity(EntityType<? extends PokeBallEntity> entityType, PokeBall type, World world, LivingEntity thrower, PokeBallMode mode) {
        super(entityType, thrower, world);
        SYNC_POKEBALL_TYPE.set((Entity)this, (Object)type);
        SYNC_MODE.set((Entity)this, (Object)mode);
    }

    public ITextComponent func_200200_C_() {
        if (this.name == null) {
            this.name = this.getBallType().getLocalizedName();
        }
        return new StringTextComponent(this.name);
    }

    protected void func_70227_a(RayTraceResult movingobjectposition) {
    }

    public abstract void spawnRedBeam();

    public ItemStack[] getComponentItems() {
        if (this.getBallType().hasLid()) {
            return new ItemStack[]{this.getBallType().getLidItem(), new ItemStack((IItemProvider)this.getBallType().getRandomBaseAsItem()), new ItemStack((IItemProvider)Items.field_221766_cs)};
        }
        return new ItemStack[]{new ItemStack((IItemProvider)this.getBallType().getRandomBaseAsItem()), new ItemStack((IItemProvider)Items.field_221766_cs)};
    }

    protected void func_70088_a() {
        this.define(SYNC_POKEBALL_TYPE, PokeBallRegistry.POKE_BALL.orElse((PokeBall)null));
        this.define(SYNC_IS_WAITING, false);
        this.define(SYNC_IS_ON_GROUND, false);
        this.define(SYNC_INITIAL_YAW, Float.valueOf(0.0f));
        this.define(SYNC_INITIAL_PITCH, Float.valueOf(0.0f));
        this.define(SYNC_ANIMATION, AnimationType.IDLE);
        this.define(SYNC_ID, 0);
        this.define(SYNC_MODE, PokeBallMode.FULL);
        this.define(SYNC_OWNER, Optional.empty());
        this.define(SYNC_POKE_UUID, Optional.empty());
        this.define(SYNC_SLOT, (byte)-1);
        this.define(SYNC_CRITICAL, false);
        this.define(SYNC_PAIRED_ENTITY, -1);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.animationTick();
        }
        if (this.getMode() == PokeBallMode.FULL && this.getIsWaiting()) {
            this.field_70177_z = this.getInitialYaw();
            if (this.waitTimer > 0) {
                --this.waitTimer;
            }
            if (this.firstContact) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.3, this.func_213322_ci().func_82616_c());
                this.firstContact = false;
            } else if (this.func_213322_ci().func_82617_b() <= 0.0 && !this.pausing) {
                this.waitTimer = 2;
                this.pausing = true;
            }
            if (this.waitTimer > 0) {
                EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.0);
            } else if (this.pausing && this.waitTimer == 0) {
                PixelmonEntity pixelmon;
                PlayerPartyStorage storage;
                Pokemon pokemon;
                if (this.getAnimation() != AnimationType.BOUNCECLOSED) {
                    EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.2);
                    EntityHelper.setMotion((Entity)this, EnumRotation.x, 0.2 * (double)((float)Math.cos((double)this.getInitialYaw() * Math.PI / 180.0 - 1.5707963267948966)));
                    EntityHelper.setMotion((Entity)this, EnumRotation.z, 0.2 * (double)((float)Math.sin((double)this.getInitialYaw() * Math.PI / 180.0 - 1.5707963267948966)));
                    this.setAnimation(AnimationType.BOUNCECLOSED);
                    if (this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_CLOSE.get(), SoundCategory.NEUTRAL, 0.1f, 1.0f, true);
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_RELEASE.get(), SoundCategory.NEUTRAL, 0.2f, 1.0f, true);
                    }
                }
                if (!(this.field_70170_p.field_72995_K || this.thrower == null || (pokemon = (storage = StorageProxy.getParty((ServerPlayerEntity)this.thrower)).get(this.slot)) == null || pokemon.getPixelmonEntity().isPresent() || pokemon.isEgg() || (pixelmon = pokemon.getOrSpawnPixelmon(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f)) == null)) {
                    Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayerEntity)this.func_234616_v_(), pokemon, pixelmon));
                    pixelmon.resetAI();
                    pixelmon.onSendout();
                    pokemon.updateDimensionAndEntityID((RegistryKey<World>)pixelmon.field_70170_p.func_234923_W_(), pixelmon.func_145782_y());
                }
                --this.waitTimer;
            }
        }
        if ((this.getMode() == PokeBallMode.EMPTY || this.getMode() == PokeBallMode.BATTLE && !this.getIsOnGround()) && this.getIsWaiting()) {
            if (this.waitTimer > 0) {
                --this.waitTimer;
            }
            if (this.firstContact) {
                EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.3);
                if (this.thrower != null) {
                    EntityHelper.setMotion((Entity)this, EnumRotation.x, -this.thrower.func_70040_Z().func_82615_a() * 0.225);
                    EntityHelper.setMotion((Entity)this, EnumRotation.z, -this.thrower.func_70040_Z().func_82616_c() * 0.225);
                }
                this.firstContact = false;
            } else if (this.func_213322_ci().func_82617_b() <= 0.0 && !this.pausing) {
                this.waitTimer = 60;
                this.setAnimation(AnimationType.BOUNCEOPEN);
                this.pausing = true;
                if (!this.field_70170_p.field_72995_K) {
                    this.initialScale = this.pixelmon.getPixelmonScale();
                    this.initPos = new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_226278_cu_(), this.pixelmon.func_226281_cx_());
                    Vector3d current = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                    current.func_178788_d(this.initPos);
                    this.diff = current;
                }
            }
            if (this.waitTimer > 0) {
                this.func_213317_d(Vector3d.field_186680_a);
                if (this.waitTimer >= 20 && this.waitTimer < 40) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.waitTimer == 20) {
                            this.pixelmon.setOverlay(false);
                            this.pixelmon.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));
                        } else {
                            this.pixelmon.setOverlay(true);
                            this.pixelmon.setColor(new Color(1.0f, 0.0f, 0.0f, (float)(40 - this.waitTimer) / 20.0f));
                        }
                        this.pixelmon.setFullbright(true);
                        this.pixelmon.setDisableTexture(true);
                    }
                } else if (this.waitTimer < 20 && !this.field_70170_p.field_72995_K) {
                    if (this.startCapture) {
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_CAPTURE.get(), SoundCategory.NEUTRAL, 0.2f, 1.0f, true);
                        this.startCapture = false;
                    }
                    this.pixelmon.setOverlay(false);
                    this.pixelmon.setDisableNametag(true);
                    this.pixelmon.setDisableShadow(true);
                    this.pixelmon.setDisableTexture(true);
                    this.pixelmon.setFullbright(true);
                    this.pixelmon.setColor(new Color(1.0f, 0.0f, 0.0f, (float)this.waitTimer / 20.0f));
                }
                if (this.waitTimer == 1 && !this.field_70170_p.field_72995_K) {
                    this.pixelmon.unloadEntity();
                    this.setAnimation(AnimationType.BOUNCECLOSED);
                    this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_CLOSE.get(), SoundCategory.NEUTRAL, 0.1f, 1.0f, true);
                    EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.2);
                }
            }
        }
        if (!this.getIsWaiting() && !this.getIsOnGround()) {
            this.field_70177_z += 50.0f;
        } else if (this.getIsOnGround()) {
            this.func_213317_d(Vector3d.field_186680_a);
            if (this.getMode() == PokeBallMode.EMPTY || this.getMode() == PokeBallMode.BATTLE && this.field_70170_p.field_72995_K) {
                if (this.waitTimer > 0) {
                    --this.waitTimer;
                }
                if (this.waitTimer <= 0 && this.shakeCount < Math.abs(this.getPokeballID())) {
                    ++this.shakeCount;
                    this.chooseAnimation();
                    if (this.inc != null) {
                        this.inc.value = 0.0f;
                    }
                    this.waitTimer = this.ticksPerShake;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void animationTick() {
        if (this.field_70170_p.field_72995_K && this.model != null) {
            if (this.inc == null) {
                this.inc = new IncrementingVariable(30.0f, 2.1474836E9f);
                if (this.getAnimation() == AnimationType.BOUNCEOPEN) {
                    this.inc.shouldReverse = true;
                    this.inc.shouldStayAtEnd = true;
                    this.inc.stayAtEndTime = 30;
                    this.inc.atEndTask = this::spawnRedBeam;
                }
            }
            if (this.getIsWaiting() && this instanceof EmptyPokeBallEntity) {
                if (this.getInitialPitch() != 0.0f) {
                    this.setInitialPitch(this.getInitialPitch() - this.getInitialPitch() / 10.0f);
                }
                if (this.getInitialYaw() != 0.0f) {
                    this.setInitialYaw(this.getInitialYaw() - this.getInitialYaw() / 10.0f);
                }
            }
            this.inc.tick();
        }
    }

    private void chooseAnimation() {
        this.setAnimation(ANIMS[RandomHelper.getRandomNumberBetween(0, ANIMS.length - 1)]);
    }

    protected void moveCloser(float percent) {
        Vector3d newVec = this.initPos.func_72441_c(this.diff.field_72450_a * (double)(1.0f - percent), this.diff.field_72448_b * (double)(1.0f - percent), this.diff.field_72449_c * (double)(1.0f - percent));
        EntityHelper.setMotion((Entity)this.pixelmon, EnumRotation.x, newVec.field_72450_a);
        EntityHelper.setMotion((Entity)this.pixelmon, EnumRotation.y, newVec.field_72448_b);
        EntityHelper.setMotion((Entity)this.pixelmon, EnumRotation.z, newVec.field_72449_c);
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.func_226278_cu_() <= -64.0) {
            this.func_174812_G();
            return;
        }
        if (this.getIsOnGround()) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
    }

    public void premierFlash() {
        if (this.getBallType().hasParticles()) {
            this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(255.0f, 250.0f, 250.0f, 1.0f), this.func_226277_ct_() + 0.1, this.func_226278_cu_() + 0.05, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public void onCaptureAttemptEffect() {
        if (Pixelmon.EVENT_BUS.post((Event)new PokeballEffectEvent.StartCaptureEffect(this))) {
            return;
        }
        if (!this.capture2 && this.pausing) {
            if (this.getBallType().is(PokeBallRegistry.PREMIER_BALL)) {
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.4, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() - 0.4, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.2, this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.2, this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.2, this.func_226278_cu_() - 0.2, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.2, this.func_226278_cu_() - 0.2, this.func_226281_cx_(), 255.0, 250.0, 250.0);
            }
            if (this.getBallType().is(PokeBallRegistry.MASTER_BALL)) {
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.4, this.func_226281_cx_(), 148.0, 0.0, 211.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() - 0.4, this.func_226281_cx_(), 148.0, 0.0, 211.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.2, this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 148.0, 0.0, 211.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.2, this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 148.0, 0.0, 211.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.2, this.func_226278_cu_() - 0.2, this.func_226281_cx_(), 148.0, 0.0, 211.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.2, this.func_226278_cu_() - 0.2, this.func_226281_cx_(), 148.0, 0.0, 211.0);
            }
            this.capture2 = true;
        }
    }

    public void successfulCaptureEffect() {
        if (Pixelmon.EVENT_BUS.post((Event)new PokeballEffectEvent.SuccessfullCaptureEffect(this))) {
            return;
        }
        if (!this.capture1) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_CAPTURE_SUCCESS.get(), SoundCategory.NEUTRAL, 0.07f, 1.0f, false);
            if (this.getBallType().hasParticles()) {
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.8, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 255.0, 250.0, 250.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.5, this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 255.0, 250.0, 250.0);
            } else {
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.8, this.func_226281_cx_(), 255.0, 255.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 255.0, 255.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.5, this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 255.0, 255.0, 0.0);
            }
            this.capture1 = true;
        }
    }

    public void releaseEffect() {
        if (Pixelmon.EVENT_BUS.post((Event)new PokeballEffectEvent.SentOutEffect(this))) {
            return;
        }
        if (!this.capture1) {
            if (this.getBallType().hasParticles()) {
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.4, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() - 0.4, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.2, this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.2, this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() + 0.2, this.func_226278_cu_() - 0.2, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                WorldHelper.spawnRedstoneParticle(this.field_70170_p, this.func_226277_ct_() - 0.2, this.func_226278_cu_() - 0.2, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            this.capture1 = true;
        }
    }

    protected void doCaptureCalc(PixelmonEntity p2) {
        CaptureValues values = this.getBallType().getCaptureMethod().calculateCapture(new CaptureHealth(p2), this.getBallType(), this, null, (ServerPlayerEntity)this.thrower, p2.getPokemon(), this.getMode());
        this.setCritical(values.isCritical());
        this.canCatch = values.isCaught();
        this.numShakes = values.getShakes();
    }

    public PokeBall getBallType() {
        return this.pokeBallType;
    }

    protected void setIsWaiting(boolean value) {
        SYNC_IS_WAITING.set((Entity)this, (Object)value);
    }

    public boolean getIsWaiting() {
        return this.waiting;
    }

    protected void setIsOnGround(boolean value) {
        SYNC_IS_ON_GROUND.set((Entity)this, (Object)value);
    }

    protected boolean getIsOnGround() {
        return this.onGround;
    }

    public void setAnimation(AnimationType animation) {
        SYNC_ANIMATION.set((Entity)this, (Object)animation);
    }

    public AnimationType getAnimation() {
        return this.animationType;
    }

    public int getPokeballID() {
        return this.pokeballId;
    }

    public void setPokeballID(int id) {
        SYNC_ID.set((Entity)this, (Object)id);
    }

    public float getInitialYaw() {
        return this.initialYaw;
    }

    public void setInitialYaw(float yaw) {
        SYNC_INITIAL_YAW.set((Entity)this, (Object)Float.valueOf(yaw));
    }

    public float getInitialPitch() {
        return this.initialPitch;
    }

    public void setInitialPitch(float pitch) {
        SYNC_INITIAL_PITCH.set((Entity)this, (Object)Float.valueOf(pitch));
    }

    protected void setCritical(boolean value) {
        SYNC_CRITICAL.set((Entity)this, (Object)value);
    }

    public boolean getCritical() {
        return this.critical;
    }

    public PokeBallMode getMode() {
        return this.pokeBallMode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelPokeballs getModel() {
        if (this.model == null) {
            this.model = (ModelPokeballs)((Object)this.getBallType().getModelHolder(true).getModel());
        }
        return this.model;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setModel(ModelPokeballs model) {
        this.model = model;
    }

    public int getShakeCount() {
        return this.shakeCount;
    }

    public int getWaitTimer() {
        return this.waitTimer;
    }

    public UUID getOwnerId() {
        return this.owner;
    }

    public void setOwnerId(UUID ownerUuid) {
        SYNC_OWNER.set((Entity)this, Optional.ofNullable(ownerUuid));
    }

    public UUID getPokeUUID() {
        return this.pokeUUID;
    }

    public void setPokeUUID(UUID pokeUUID) {
        SYNC_POKE_UUID.set((Entity)this, Optional.ofNullable(pokeUUID));
    }

    public int getPairedEntity() {
        return this.pairedEntity;
    }

    public void setPairedEntity(Entity entity) {
        SYNC_PAIRED_ENTITY.set((Entity)this, (Object)entity.func_145782_y());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

