/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.container.PokeBagContainer;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class PokeBagItem
extends PixelmonItem
implements IEquippable {
    private final DyeColor color;

    public PokeBagItem(DyeColor color) {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_UTILITY).func_200917_a(1));
        this.color = color;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && hand == Hand.MAIN_HAND) {
            PokeBagItem.openPokeBag(stack, (ServerPlayerEntity)player);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        if (player.field_71070_bA instanceof PokeBagContainer) {
            player.func_71053_j();
            return false;
        }
        return super.onDroppedByPlayer(item, player);
    }

    @Override
    public String getTooltipText() {
        return I18n.func_135052_a((String)"item.pixelmon.pokebag.tooltip", (Object[])new Object[0]);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.MAINHAND;
    }

    @Override
    public String getEquippableModelKey() {
        return "badgecase";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return null;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }

    public static void openPokeBag(final ItemStack stack, final ServerPlayerEntity player) {
        if (stack.func_77973_b() instanceof PokeBagItem) {
            final PokeBag pokeBag = PokeBag.readFromItemStack((PlayerEntity)player, stack);
            if (pokeBag == null) {
                return;
            }
            SimpleNamedContainerProvider containerProvider = new SimpleNamedContainerProvider((id, inventory, entity) -> new PokeBagContainer(id, player.field_71071_by, pokeBag), (ITextComponent)new TranslationTextComponent(""));
            if (!player.field_71071_by.func_70431_c(stack)) {
                return;
            }
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, pokeBag::writeToBuffer);
            player.field_71070_bA.func_75132_a(new IContainerListener(){

                public void func_71110_a(Container container, NonNullList<ItemStack> stacks) {
                    if (!player.field_71071_by.func_70431_c(stack)) {
                        return;
                    }
                    pokeBag.writeToStack(stack);
                }

                public void func_71111_a(Container container, int slot, ItemStack item) {
                    if (!player.field_71071_by.func_70431_c(stack)) {
                        return;
                    }
                    if (slot >= pokeBag.inventory.func_70302_i_()) {
                        return;
                    }
                    pokeBag.inventory.func_70299_a(slot, item);
                    pokeBag.writeToStack(stack);
                }

                public void func_71112_a(Container container, int id, int data) {
                    if (!player.field_71071_by.func_70431_c(stack)) {
                        return;
                    }
                    pokeBag.writeToStack(stack);
                }
            });
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Unequippable")) && this.getEquipmentSlot(stack) == armorType;
    }

    public static class PokeBag {
        public Inventory inventory;
        private int slot;
        public DyeColor color;

        public PokeBag(Inventory inventory, DyeColor color, int slot) {
            this.inventory = inventory;
            this.color = color;
            this.slot = slot;
        }

        public int getSlot() {
            return this.slot;
        }

        public void writeToStack(ItemStack stack) {
            CompoundNBT compound = stack.func_196082_o();
            this.saveInventory(compound);
            compound.func_74768_a("PokeBagColor", this.color.ordinal());
        }

        public void writeToBuffer(PacketBuffer buffer) {
            CompoundNBT compound = new CompoundNBT();
            this.saveInventory(compound);
            buffer.func_150786_a(compound);
            buffer.writeInt(this.color.func_196059_a());
            buffer.writeInt(this.slot);
        }

        public void saveInventory(CompoundNBT tag) {
            ListNBT list = new ListNBT();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", i);
                nbt.func_218657_a("item", (INBT)this.inventory.func_70301_a(i).func_77955_b(new CompoundNBT()));
                list.add((Object)nbt);
            }
            tag.func_218657_a("PokeBagItems", (INBT)list);
        }

        public static Inventory fromTag(CompoundNBT tag) {
            ListNBT list = tag.func_150295_c("PokeBagItems", 10);
            Inventory inventory = new Inventory(27);
            for (INBT inbt : list) {
                CompoundNBT listNBT = (CompoundNBT)inbt;
                inventory.func_70299_a(listNBT.func_74762_e("slot"), ItemStack.func_199557_a((CompoundNBT)listNBT.func_74775_l("item")));
            }
            return inventory;
        }

        public static PokeBag readFromItemStack(PlayerEntity player, ItemStack stack) {
            if (!(stack.func_77973_b() instanceof PokeBagItem)) {
                return null;
            }
            CompoundNBT compound = stack.func_77978_p();
            Inventory inventory = new Inventory(27);
            if (compound != null && compound.func_74764_b("PokeBagItems")) {
                inventory = PokeBag.fromTag(compound);
            }
            DyeColor color = DyeColor.RED;
            if (compound != null) {
                color = DyeColor.func_196056_a((int)compound.func_74762_e("PokeBagColor"));
            }
            int slot = -1;
            for (int i2 = 0; i2 < player.field_71071_by.field_70462_a.size(); ++i2) {
                ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(i2);
                if (!Objects.equals(item, stack)) continue;
                slot = i2;
                break;
            }
            PokeBag pokeBag = new PokeBag(inventory, color, slot);
            inventory.func_110134_a(i -> pokeBag.writeToStack(stack));
            return pokeBag;
        }

        public static PokeBag fromBuffer(PacketBuffer buffer) {
            CompoundNBT compound = buffer.func_150793_b();
            Inventory inventory = PokeBag.fromTag(compound);
            return new PokeBag(inventory, DyeColor.func_196056_a((int)buffer.readInt()), buffer.readInt());
        }
    }
}

