/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import net.minecraft.item.Item;

public class BerryStatResponseItem
extends BerryItem {
    private final AttackCategory category;
    private final BattleStatsType stat;

    public BerryStatResponseItem(Item.Properties properties, EnumHeldItems type, BerryType berry, AttackCategory category, BattleStatsType stat) {
        super(properties, type, berry);
        this.category = category;
        this.stat = stat;
    }

    @Override
    public void postProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, float damage) {
        if (BerryStatResponseItem.canEatBerry(target) && damage > 0.0f && attack.getAttackCategory() == this.category) {
            this.eatBerry(target);
            target.consumeItem();
        }
    }

    @Override
    public void eatBerry(PixelmonWrapper user) {
        boolean ripened = user.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Ripen.class);
        user.bc.sendToAll("pixelmon.helditems.pinchberry", user.getNickname(), user.getHeldItem().getLocalizedName());
        if (ripened) {
            user.bc.sendToAll("pixelmon.abilities.ripen", user.getNickname(), this.getLocalizedName());
        }
        user.getBattleStats().modifyStat(ripened ? 2 : 1, this.stat);
        super.eatBerry(user);
    }
}

