/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.items.heldItems.PlateItem;
import java.util.ArrayList;

public class LegendPlateItem
extends PlateItem {
    private Element currentType = Element.NORMAL;

    public LegendPlateItem() {
        super(Element.NORMAL);
    }

    @Override
    public double preProcessDamagingAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        return attack.getMove().getAttackType() == this.currentType ? damage * 1.2 : damage;
    }

    @Override
    public void onEndOfBattle(PixelmonWrapper pw) {
        if (pw.getSpecies().is(PixelmonSpecies.ARCEUS)) {
            pw.setForm("");
        }
    }

    public Element getNewType(PixelmonWrapper target) {
        if (target == null || target.type == null) {
            this.currentType = Element.NORMAL;
            return this.currentType;
        }
        ArrayList<Element> targetElements = new ArrayList<Element>(target.type);
        ArrayList<Element> options = this.getMostEffective(targetElements, new ArrayList<Element>(Element.getAllTypes()));
        if (targetElements.size() > 0) {
            options = this.getResist(targetElements.get(0), options);
        }
        if (targetElements.size() > 1) {
            options = this.getResist(targetElements.get(1), options);
        }
        int rand = field_77697_d.nextInt(options.size());
        this.currentType = options.get(rand);
        return this.currentType;
    }

    private ArrayList<Element> getMostEffective(ArrayList<Element> targetsTypes, ArrayList<Element> options) {
        ArrayList<Element> mostEffective = new ArrayList<Element>();
        float maxEffectiveness = 0.0f;
        for (Element newType : options) {
            float effectiveness = Element.getTotalEffectiveness(targetsTypes, newType);
            if (!(effectiveness >= maxEffectiveness)) continue;
            if (effectiveness > maxEffectiveness) {
                mostEffective.clear();
                maxEffectiveness = effectiveness;
            }
            mostEffective.add(newType);
        }
        return mostEffective;
    }

    private ArrayList<Element> getResist(Element typing, ArrayList<Element> options) {
        ArrayList<Element> mostResistant = new ArrayList<Element>();
        float maxResistance = 2.0f;
        for (Element newType : options) {
            float effectiveness = Element.getEffectiveness((Element)newType, (Element)typing).value;
            if (!(effectiveness <= maxResistance)) continue;
            if (effectiveness < maxResistance) {
                mostResistant.clear();
                maxResistance = effectiveness;
            }
            mostResistant.add(newType);
        }
        return mostResistant;
    }
}

