/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SheerForce;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.item.Item;

public class LifeOrbItem
extends HeldItem {
    transient boolean shouldRecoil = false;

    public LifeOrbItem() {
        super(EnumHeldItems.lifeorb, new Item.Properties());
    }

    @Override
    public double preProcessDamagingAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        if (damage > 0.0) {
            return damage * 1.3;
        }
        return damage;
    }

    @Override
    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
        Ability attackerAbility = attacker.getBattleAbility();
        if (attack != null && damageType == DamageTypeEnum.ATTACK && !attacker.isFainted()) {
            boolean doesRecoil;
            boolean bl = doesRecoil = !(attackerAbility instanceof MagicGuard || !defender.isFainted() && attacker.inParentalBond || attackerAbility instanceof SheerForce && attack.getMove().hasSecondaryEffect());
            if (doesRecoil) {
                this.shouldRecoil = doesRecoil;
            }
        }
    }

    @Override
    public void applyEffectAfterAllTargets(PixelmonWrapper attacker) {
        if (this.shouldRecoil) {
            int recoil = attacker.getPercentMaxHealth(10.0f);
            if (attacker.isDynamax()) {
                recoil = attacker.getPercentMaxHealth(10.0f, true);
            }
            attacker.bc.sendToAll("pixelmon.helditem.lifeowner", attacker.getNickname());
            attacker.doBattleDamage(attacker, recoil, DamageTypeEnum.ITEM);
        }
        this.shouldRecoil = false;
    }
}

