/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownManager;
import com.pixelmonmod.pixelmon.quests.actions.ExecutorMode;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestOverviewScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.SimpleButton;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.math.NumberUtils;

public class QuestStageScreen
extends Screen {
    private List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private Stage stage;
    private CopyOnWriteArrayList<QuestElement> objectives;
    private CopyOnWriteArrayList<QuestElement> actions;
    private QuestElement selection = null;
    private HashSet<Integer> actionObjectives = new HashSet();
    private ExecutorMode actionMode = ExecutorMode.AND;
    private ArrayList<AbstractGui> selectionElements = new ArrayList();
    private DropDown<QuestElement> dropDown;
    private final DropDownManager dropDownManager = new DropDownManager();
    private MouseState mouseState = MouseState.HOVER;
    private boolean reload = false;
    int prevWidth = -1;
    int prevHeight = -1;

    public QuestStageScreen(Stage stage) {
        super(StringTextComponent.field_240750_d_);
        this.stage = stage;
        this.objectives = new CopyOnWriteArrayList<QuestElement>(QuestEditorState.get().getObjectivesForStage(stage));
        this.actions = new CopyOnWriteArrayList<QuestElement>(QuestEditorState.get().getActionsForStage(stage));
        this.dropDownManager.clearDropDowns();
    }

    public void func_231160_c_() {
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        int id = 0;
        int buttonS = 14;
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 0, y + 6, 12, Resources.back, 2, 2, -12407307));
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 1, y + 6, 12, Resources.save, 2, 2, -14300093));
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 2, y + 6, 12, Resources.discard, 2, 2, -2210481));
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float f) {
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        super.func_230430_a_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.backgroundTexture);
        int gap = 3;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        QuestStageScreen.func_238463_a_((MatrixStack)matrix, (int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (int)((int)((float)dispWidth / 2.0f)), (int)dispHeight);
        QuestStageScreen.func_238463_a_((MatrixStack)matrix, (int)(x + dispWidth / 2 + gap + 1), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (int)((int)((float)dispWidth / 2.0f)), (int)dispHeight);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        this.drawElements(matrix, x, y, mouseX, mouseY);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        for (SimpleButton button : this.buttons) {
            button.draw(matrix);
        }
        if (this.selection != null) {
            this.selection.draw(matrix, this.field_230706_i_, x, y, dispWidth, dispHeight);
        }
        this.dropDownManager.drawDropDowns(matrix, 0.0f, mouseX, mouseY);
        if (this.mouseState == MouseState.PRESS) {
            QuestStageScreen.func_238463_a_((MatrixStack)matrix, (int)(x + 104), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    private void drawElements(MatrixStack matrix, int x, int y, int mouseX, int mouseY) {
        boolean showActionOptions;
        boolean mouseDown = Minecraft.func_71410_x().field_71417_B.func_198030_b();
        if (mouseDown) {
            if (this.mouseState == MouseState.HOVER) {
                this.mouseState = MouseState.PRESS;
            } else if (this.mouseState == MouseState.PRESS) {
                this.mouseState = MouseState.DRAG;
            }
        } else if (this.mouseState == MouseState.PRESS || this.mouseState == MouseState.DRAG) {
            this.mouseState = MouseState.RELEASE;
        } else if (this.mouseState == MouseState.RELEASE) {
            this.mouseState = MouseState.HOVER;
        }
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int left = x + 4;
        int top = y + 24;
        int right = x + dispWidth / 2 - 10;
        int size = 13;
        boolean bl = showActionOptions = this.selection != null && this.selection.getType() == QuestElementType.ACTION;
        if (showActionOptions) {
            ScreenHelper.drawCenteredString(matrix, TextFormatting.BOLD + this.actionMode.name(), (float)right - 6.0f, (float)(top - 8), 0);
        }
        int i = 0;
        for (QuestElement element : this.objectives) {
            this.drawElement(matrix, element, x, y, dispWidth, dispHeight, i++, size, left, right, top, mouseX, mouseY, -17664);
        }
        for (QuestElement element : this.actions) {
            this.drawElement(matrix, element, x, y, dispWidth, dispHeight, i++, size, left, right, top, mouseX, mouseY, -5479425);
        }
        int addY = top + (size - 1) * i + 5;
        QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(left + 20), (int)addY, (int)(left + 40), (int)(addY + 10), (int)-17664);
        ScreenHelper.drawCenteredString(matrix, "+", (float)left + 30.5f, (float)addY + 1.75f, -16777216);
        QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(right - 40), (int)addY, (int)(right - 20), (int)(addY + 10), (int)-5479425);
        ScreenHelper.drawCenteredString(matrix, "+", (float)(right - 40) + 10.5f, (float)addY + 1.75f, -16777216);
        if (this.mouseState == MouseState.PRESS) {
            if (showActionOptions && mouseX >= right - 12 && mouseX <= right && mouseY >= top - 8 && mouseY <= top - 2) {
                this.actionMode = this.actionMode == ExecutorMode.AND ? ExecutorMode.OR : ExecutorMode.AND;
            } else if (mouseY >= addY && mouseY <= addY + 10) {
                if (mouseX >= left + 20 && mouseX <= left + 40) {
                    this.objectives.add(QuestEditorState.get().getObjectives().get(0).copy());
                } else if (mouseX >= right - 40 && mouseX <= right - 20) {
                    this.actions.add(QuestEditorState.get().getActions().get(0).copy());
                }
            }
        }
        QuestColor color = QuestEditorState.get().getSelectedQuest().getColor();
        RenderSystem.color4f((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.stage.getIcon().getResource());
        QuestStageScreen.func_238463_a_((MatrixStack)matrix, (int)(x + 60), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
    }

    private void drawElement(MatrixStack matrix, QuestElement element, int x, int y, int w, int h, int i, int size, int left, int right, int top, int mouseX, int mouseY, int color) {
        boolean selected;
        int offset = (size - 1) * i;
        boolean bl = selected = this.selection == element;
        if (selected) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 2.0);
        }
        boolean showActionOptions = this.selection != null && this.selection.getType() == QuestElementType.ACTION && element.getType() == QuestElementType.OBJECTIVE;
        int nudge = 0;
        if (showActionOptions) {
            nudge = 12;
        }
        int x1 = left;
        int x2 = right - nudge;
        int y1 = top + offset;
        int y2 = top + size + offset;
        QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)x1, (int)y1, (int)x2, (int)y2, (int)(selected ? -1 : -16777216));
        QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)color);
        ScreenHelper.drawSquashedString(matrix, this.field_230712_o_, I18n.func_188566_a((String)element.getName()) ? I18n.func_135052_a((String)element.getName(), (Object[])new Object[0]) : element.getIdentifier(), false, showActionOptions ? 84.0f : 95.0f, (float)(x1 + 3), (float)(y1 + size / 2 - 3), -16777216, false);
        QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(x2 - 11), (int)(y1 + 2), (int)(x2 - 2), (int)(y1 + 11), (int)-2210481);
        this.field_230712_o_.func_238421_b_(matrix, "-", (float)(x2 - 9), (float)(y1 + 3), -1);
        if (showActionOptions) {
            QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(right - 11), (int)(y1 + 2), (int)(right - 2), (int)(y1 + 3), (int)-16777216);
            QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(right - 11), (int)(y1 + 10), (int)(right - 2), (int)(y1 + 11), (int)-16777216);
            QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(right - 11), (int)(y1 + 2), (int)(right - 10), (int)(y1 + 11), (int)-16777216);
            QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(right - 3), (int)(y1 + 2), (int)(right - 2), (int)(y1 + 11), (int)-16777216);
            if (this.actionObjectives.contains(i)) {
                QuestStageScreen.func_238467_a_((MatrixStack)matrix, (int)(right - 10), (int)(y1 + 3), (int)(right - 3), (int)(y1 + 10), (int)-5479425);
            }
        }
        if (this.mouseState == MouseState.PRESS) {
            if (showActionOptions && mouseX >= right - 11 && mouseY >= y1 + 2 && mouseX <= right - 2 && mouseY <= y1 + 11) {
                if (!this.actionObjectives.remove(i)) {
                    this.actionObjectives.add(i);
                }
            } else if (mouseX >= x2 - 11 && mouseY >= y1 + 2 && mouseX <= x2 - 2 && mouseY <= y1 + 11) {
                this.deleteElement(element);
            } else if (mouseX >= x1 && mouseY >= y1 && mouseX <= x2 && mouseY <= y2) {
                this.selectElement(element, x, y, w, h);
            }
        }
        if (selected) {
            matrix.func_227865_b_();
        }
    }

    private void writeExtraString(QuestElement element) {
        if (element != null && element.getType() == QuestElementType.ACTION) {
            StringBuilder extra = new StringBuilder(this.actionMode == ExecutorMode.AND ? "+" : "");
            boolean first = true;
            for (int i : this.actionObjectives) {
                if (!first) {
                    extra.append(",");
                }
                extra.append(i);
                first = false;
            }
            String result = extra.toString();
            if (result.isEmpty() || result.equalsIgnoreCase("+")) {
                element.setExtra("0");
            } else {
                element.setExtra(result);
            }
        }
    }

    private void selectElement(QuestElement element, int x, int y, int w, int h) {
        this.writeExtraString(this.selection);
        this.selection = element;
        if (this.selection.getType() == QuestElementType.ACTION) {
            String objArgs = this.selection.getExtra();
            ExecutorMode executorMode = this.actionMode = objArgs.startsWith("+") ? ExecutorMode.AND : ExecutorMode.OR;
            if (this.actionMode == ExecutorMode.AND) {
                objArgs = objArgs.substring(1);
            }
            String[] split = objArgs.split(",");
            this.actionObjectives.clear();
            for (String arg : split) {
                if (!NumberUtils.isParsable((String)arg)) continue;
                int i = Integer.parseInt(arg);
                if (this.objectives.size() <= i) continue;
                this.actionObjectives.add(i);
            }
        }
        this.selection.initialize(this.field_230706_i_, x, y, w, h);
        this.setDropDowns(x, y, w, h);
    }

    private void setDropDowns(int x, int y, int w, int h) {
        int dropDownX = x + w / 2 + 6;
        int dropDownY = y + 2;
        int dropDownW = 111;
        int dropDownH = 140;
        this.dropDownManager.clearDropDowns();
        if (this.selection.getType() == QuestElementType.OBJECTIVE) {
            this.addDropDown(new DropDown<int>((List<int>)QuestEditorState.get().getObjectives(), QuestEditorState.get().getObjectives().indexOf(QuestEditorState.get().getObjective(this.selection.getIdentifier())), dropDownX, dropDownY, dropDownW, dropDownH, dropDownW - 6).setGetOptionString(qe -> I18n.func_188566_a((String)qe.getName()) ? I18n.func_135052_a((String)qe.getName(), (Object[])new Object[0]) : qe.getIdentifier()).setOrdered().setOnSelected(e -> this.selection.duplicate((QuestElement)e)));
        } else if (this.selection.getType() == QuestElementType.ACTION) {
            this.addDropDown(new DropDown<int>((List<int>)QuestEditorState.get().getActions(), QuestEditorState.get().getActions().indexOf(QuestEditorState.get().getAction(this.selection.getIdentifier())), dropDownX, dropDownY, dropDownW, dropDownH, dropDownW - 6).setGetOptionString(qe -> I18n.func_188566_a((String)qe.getName()) ? I18n.func_135052_a((String)qe.getName(), (Object[])new Object[0]) : qe.getIdentifier()).setOrdered().setOnSelected(e -> this.selection.duplicate((QuestElement)e)));
        }
    }

    private void deleteElement(QuestElement element) {
        if (this.objectives.remove(element)) {
            Quest quest = QuestEditorState.get().getSelectedQuest();
            quest.clearDefaultStrings(this.stage.getStage(), this.objectives.size());
            this.actionObjectives.remove(this.objectives.size());
        }
        this.actions.remove(element);
        if (this.selection == element) {
            this.selection = null;
        }
    }

    private int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.dropDownManager.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        if (mouseX >= (double)(x + 60) && mouseX <= (double)(x + 60 + 16) && mouseY >= (double)(y + 4) && mouseY <= (double)(y + 4 + 16)) {
            this.stage.changeIcon();
            return true;
        }
        int id = -1;
        for (SimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            switch (id) {
                case 0: {
                    this.writeToStage();
                    this.field_230706_i_.func_147108_a((Screen)new QuestOverviewScreen());
                    break;
                }
                case 1: {
                    this.writeToStage();
                    break;
                }
                case 2: {
                    this.field_230706_i_.func_147108_a((Screen)new QuestOverviewScreen());
                }
            }
        }
        if (this.selection != null) {
            this.selection.onClick(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    private void writeToStage() {
        this.writeExtraString(this.selection);
        Quest quest = QuestEditorState.get().getSelectedQuest();
        this.stage.getRawObjectives().clear();
        int oi = 0;
        for (QuestElement element : this.objectives) {
            this.stage.getRawObjectives().add(element.build(quest, this.stage, oi++));
        }
        this.stage.getRawActions().clear();
        int ai = 0;
        for (QuestElement element : this.actions) {
            this.stage.getRawActions().add(element.build(quest, this.stage, ai++));
        }
        quest.setDefaultStrings(this.stage.getStage(), this.stage.getRawObjectives().size());
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        boolean val = super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
        if (this.selection != null) {
            this.selection.onType(Character.forDigit(p_231046_1_, p_231046_1_), p_231046_1_);
        }
        return val;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double mousewheelDirection) {
        if (mousewheelDirection == 120.0) {
            this.onScroll(Direction.DOWN, mouseX, mouseY);
        } else if (mousewheelDirection == -120.0) {
            this.onScroll(Direction.UP, mouseX, mouseY);
        }
        return true;
    }

    private void onScroll(Direction direction, double mouseX, double mouseY) {
    }

    public void func_231023_e_() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.field_230706_i_.func_147108_a((Screen)new QuestEditorScreen());
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.field_230708_k_ != this.prevWidth || this.field_230709_l_ != this.prevHeight)) {
            this.addButtons();
            if (this.selection != null) {
                int x = this.field_230708_k_ / 2 - 125;
                int y = this.field_230709_l_ / 2 - 100;
                int xOffset = 20;
                int yOffset = 20;
                int dispWidth = xOffset + 230;
                int dispHeight = yOffset + 180;
                this.selection.initialize(this.field_230706_i_, x, y, dispWidth, dispHeight);
                this.setDropDowns(x, y, dispWidth, dispHeight);
            }
        }
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.reload = false;
        }
        this.prevWidth = this.field_230708_k_;
        this.prevHeight = this.field_230709_l_;
    }

    public <T> DropDown<T> addDropDown(DropDown<T> dropDown) {
        this.dropDownManager.addDropDown(dropDown);
        return dropDown;
    }

    public void removeDropDown(DropDown dropDown) {
        this.dropDownManager.removeDropDown(dropDown);
    }

    private static enum Direction {
        UP,
        DOWN;

    }

    private static enum MouseState {
        HOVER,
        PRESS,
        DRAG,
        RELEASE;

    }
}

