/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnActionNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.gen.FlatChunkGenerator;

public class CaveLevelTweak
implements SpawningTweak {
    @Override
    public void doTweak(AbstractSpawner spawner, SpawnAction<? extends Entity> action) {
        if (action instanceof SpawnActionPokemon) {
            SpawnActionPokemon actionPokemon = (SpawnActionPokemon)action;
            if (!(action.spawnInfo instanceof SpawnInfoPokemon)) {
                return;
            }
            SpawnInfoPokemon spawnInfo = (SpawnInfoPokemon)action.spawnInfo;
            PixelmonEntity pixelmon = (PixelmonEntity)actionPokemon.getOrCreateEntity();
            if (pixelmon.isBossPokemon()) {
                return;
            }
            int newLevel = this.getTweakedLevel(spawner, actionPokemon, actionPokemon.pokemon.getPokemonLevel(), spawnInfo.minLevel, spawnInfo.maxLevel);
            pixelmon.getPokemon().setLevel(newLevel);
            pixelmon.func_70606_j(pixelmon.getPokemon().getHealth());
        } else if (action instanceof SpawnActionNPCTrainer) {
            SpawnActionNPCTrainer actionTrainer = (SpawnActionNPCTrainer)action;
            SpawnInfoNPCTrainer infoTrainer = (SpawnInfoNPCTrainer)actionTrainer.spawnInfo;
            NPCTrainer trainer = (NPCTrainer)((Object)actionTrainer.getOrCreateEntity());
            trainer.setPokemonLevel(this.getTweakedLevel(spawner, actionTrainer, trainer.pokemonLevel, infoTrainer.getMinLevel(), infoTrainer.getMaxLevel()));
        }
    }

    public int getTweakedLevel(AbstractSpawner spawner, SpawnAction<? extends Entity> action, int level, int min, int max) {
        if (min == max || !(action.spawnLocation.cause instanceof ServerPlayerEntity) || action.spawnLocation.location == null || action.spawnLocation.location.pos == null) {
            return level;
        }
        ServerPlayerEntity cause = (ServerPlayerEntity)action.spawnLocation.cause;
        if (cause.func_71121_q().func_72863_F().field_186029_c instanceof FlatChunkGenerator) {
            return level;
        }
        int y = action.spawnLocation.location.pos.func_177956_o();
        double multiplier = (double)PixelmonConfigProxy.getSpawning().getCaveMaxMultiplier() * Math.exp(-0.05 * (double)y);
        if (multiplier <= 1.0 || y >= 31) {
            return level;
        }
        return (int)(multiplier * (double)level);
    }
}

