/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LegendarySpawner
extends TickingSpawner {
    public int minDistFromCentre = PixelmonConfigProxy.getSpawning().getWildSpawning().getMinimumDistanceFromCentre();
    public int maxDistFromCentre = PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumDistanceFromCentre();
    public int horizontalSliceRadius = PixelmonConfigProxy.getSpawning().getWildSpawning().getHorizontalSliceRadius();
    public int verticalSliceRadius = PixelmonConfigProxy.getSpawning().getWildSpawning().getVerticalSliceRadius();
    public List<SpawnAction<?>> possibleSpawns = null;
    public boolean firesChooseEvent = true;

    public LegendarySpawner(String name) {
        super(name);
    }

    public static void fillNearby(ArrayList<ServerPlayerEntity> allPlayers, ArrayList<ServerPlayerEntity> cluster, ServerPlayerEntity focus) {
        for (int i = 0; i < allPlayers.size(); ++i) {
            if (allPlayers.get(i) == focus || cluster.contains(allPlayers.get(i)) || !(focus.func_70032_d((Entity)allPlayers.get(i)) < 50.0f)) continue;
            ServerPlayerEntity newFocus = allPlayers.get(i);
            cluster.add(newFocus);
            allPlayers.remove(newFocus);
            LegendarySpawner.fillNearby(allPlayers, cluster, newFocus);
        }
    }

    public void forcefullySpawn(@Nullable ServerPlayerEntity onlyFocus) {
        ArrayList<ArrayList<ServerPlayerEntity>> clusters = new ArrayList<ArrayList<ServerPlayerEntity>>();
        ArrayList<ServerPlayerEntity> players = new ArrayList<ServerPlayerEntity>(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
        if (onlyFocus == null) {
            while (!players.isEmpty()) {
                ArrayList<ServerPlayerEntity> cluster = new ArrayList<ServerPlayerEntity>();
                ServerPlayerEntity focus = (ServerPlayerEntity)players.remove(0);
                if (PixelmonConfigProxy.getSpawning().isSpawningDisabledDimension((World)focus.func_71121_q())) continue;
                cluster.add(focus);
                LegendarySpawner.fillNearby(players, cluster, focus);
                clusters.add(cluster);
            }
        }
        this.isBusy = true;
        ServerPlayerEntity spawnedOnPlayer = this.getPlayer(onlyFocus, clusters);
        this.doLegendarySpawn(spawnedOnPlayer).whenCompleteAsync((spawnActions, throwable) -> {
            this.possibleSpawns = spawnActions;
            this.isBusy = false;
        }, (Executor)SpawnerCoordinator.PROCESSOR);
    }

    private ServerPlayerEntity getPlayer(ServerPlayerEntity onlyFocus, ArrayList<ArrayList<ServerPlayerEntity>> clusters) {
        if (onlyFocus != null) {
            return onlyFocus;
        }
        Collections.shuffle(clusters);
        while (clusters.size() > 0) {
            for (int i = 0; i < clusters.size(); ++i) {
                ServerPlayerEntity player = (ServerPlayerEntity)CollectionHelper.getRandomElement((List)clusters.get(i));
                clusters.get(i).remove(player);
                if (clusters.get(i).isEmpty()) {
                    clusters.remove(i--);
                }
                if (this.firesChooseEvent) {
                    LegendarySpawnEvent.ChoosePlayer event = new LegendarySpawnEvent.ChoosePlayer(this, player, clusters);
                    if (Pixelmon.EVENT_BUS.post((Event)event) || event.player == null) continue;
                    return event.player;
                }
                return player;
            }
        }
        return null;
    }

    @Override
    public List<SpawnAction<? extends Entity>> getSpawns(int pass) {
        if (pass == 0) {
            this.possibleSpawns = null;
            int numPlayers = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_72394_k();
            int baseSpawnTicks = this.firesChooseEvent ? PixelmonConfigProxy.getSpawning().getLegendarySpawnTicks() : PixelmonConfigProxy.getSpawning().getBossSpawning().getBossSpawnTicks();
            int spawnTicks = (int)((float)baseSpawnTicks / (1.0f + (float)(numPlayers - 1) * PixelmonConfigProxy.getSpawning().getSpawnTicksPlayerMultiplier()));
            this.spawnFrequency = 1200.0f / (RandomHelper.getRandomNumberBetween(0.6f, 1.4f) * (float)spawnTicks);
            if (this.firesChooseEvent && !RandomHelper.getRandomChance(PixelmonConfigProxy.getSpawning().getLegendarySpawnChance()) || !this.firesChooseEvent && !RandomHelper.getRandomChance(PixelmonConfigProxy.getSpawning().getBossSpawning().getBossSpawnChance())) {
                return null;
            }
            if (ServerLifecycleHooks.getCurrentServer().func_184103_al().func_72394_k() > 0) {
                this.forcefullySpawn(null);
            }
            return null;
        }
        if (this.possibleSpawns != null && !this.possibleSpawns.isEmpty()) {
            return this.possibleSpawns;
        }
        return null;
    }

    public CompletableFuture<List<SpawnAction<?>>> doLegendarySpawn(ServerPlayerEntity target) {
        if (target == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.getTrackedBlockCollection((Entity)target, 0.0f, 0.0f, this.horizontalSliceRadius, this.verticalSliceRadius, this.minDistFromCentre, this.maxDistFromCentre).thenApply(blockCollection -> {
            ArrayList<SpawnLocation> spawnLocations = this.spawnLocationCalculator.calculateSpawnableLocations((BlockCollection)blockCollection);
            Collections.shuffle(spawnLocations);
            List<SpawnAction<? extends Entity>> possibleSpawns = this.selectionAlgorithm.calculateSpawnActions(this, this.spawnSets, spawnLocations);
            if (possibleSpawns == null || possibleSpawns.isEmpty()) {
                return Collections.emptyList();
            }
            possibleSpawns.forEach(SpawnAction::applyLocationMutations);
            return possibleSpawns;
        });
    }

    @Override
    public int getNumPasses() {
        return 2;
    }

    public static class LegendarySpawnerBuilder<T extends LegendarySpawner>
    extends TickingSpawner.TickingSpawnerBuilder<T> {
        protected Integer minDistFromCentre = null;
        protected Integer maxDistFromCentre = null;
        protected Integer horizontalSliceRadius = null;
        protected Integer verticalSliceRadius = null;
        protected boolean firesChooseEvent = true;

        public <E extends LegendarySpawnerBuilder<T>> E setDistanceFromCentre(int minimum, int maximum) {
            if (minimum < 0) {
                minimum = 0;
            }
            this.minDistFromCentre = minimum;
            if (maximum < 0) {
                maximum = 0;
            }
            this.maxDistFromCentre = maximum;
            return (E)((LegendarySpawnerBuilder)this.getThis());
        }

        public <E extends LegendarySpawnerBuilder<T>> E setSliceRadii(int horizontal, int vertical) {
            if (horizontal < 1) {
                horizontal = 1;
            }
            this.horizontalSliceRadius = horizontal;
            if (vertical < 1) {
                vertical = 1;
            }
            this.verticalSliceRadius = vertical;
            return (E)((LegendarySpawnerBuilder)this.getThis());
        }

        public <E extends LegendarySpawnerBuilder<T>> E setFiresChooseEvent(boolean firesChooseEvent) {
            this.firesChooseEvent = firesChooseEvent;
            return (E)((LegendarySpawnerBuilder)this.getThis());
        }

        @Override
        public T apply(T spawner) {
            super.apply(spawner);
            ((LegendarySpawner)spawner).minDistFromCentre = this.minDistFromCentre != null ? this.minDistFromCentre.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getMinimumDistanceFromCentre();
            ((LegendarySpawner)spawner).maxDistFromCentre = this.maxDistFromCentre != null ? this.maxDistFromCentre.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumDistanceFromCentre();
            ((LegendarySpawner)spawner).verticalSliceRadius = this.verticalSliceRadius != null ? this.verticalSliceRadius.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getVerticalSliceRadius();
            ((LegendarySpawner)spawner).horizontalSliceRadius = this.horizontalSliceRadius != null ? this.horizontalSliceRadius.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getHorizontalSliceRadius();
            ((LegendarySpawner)spawner).firesChooseEvent = this.firesChooseEvent;
            ((TickingSpawner)spawner).onSpawnEnded();
            return spawner;
        }
    }
}

