/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerTrackingSpawner
extends TickingSpawner {
    public final UUID playerUUID;
    public PlayerPartyStorage playerStorage;
    public Long lastStorageCheck = 0L;
    protected List<SpawnAction<? extends Entity>> possibleSpawns = new ArrayList<SpawnAction<? extends Entity>>();
    public int minDistFromCentre = PixelmonConfigProxy.getSpawning().getWildSpawning().getMinimumDistanceFromCentre();
    public int maxDistFromCentre = PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumDistanceFromCentre();
    public float horizontalTrackFactor = PixelmonConfigProxy.getSpawning().getWildSpawning().getHorizontalTrackFactor();
    public float verticalTrackFactor = PixelmonConfigProxy.getSpawning().getWildSpawning().getVerticalTrackFactor();
    public int horizontalSliceRadius = PixelmonConfigProxy.getSpawning().getWildSpawning().getHorizontalSliceRadius();
    public int verticalSliceRadius = PixelmonConfigProxy.getSpawning().getWildSpawning().getVerticalSliceRadius();

    public PlayerTrackingSpawner(ServerPlayerEntity player) {
        super(player.func_200200_C_().getString());
        this.playerUUID = player.func_110124_au();
    }

    @Override
    public int getNumPasses() {
        return PixelmonConfigProxy.getSpawning().getPlayerTrackingSpawnerSpawnCollectionRate();
    }

    @Nullable
    public ServerPlayerEntity getTrackedPlayer() {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.playerUUID);
    }

    @Override
    public boolean hasCapacity(int numSpawns) {
        if (!super.hasCapacity(numSpawns)) {
            return false;
        }
        int effectiveCapacity = this.capacity;
        int playerSpawnerCount = 0;
        for (AbstractSpawner spawner : PixelmonSpawning.coordinator.spawners) {
            if (!(spawner instanceof PlayerTrackingSpawner)) continue;
            ++playerSpawnerCount;
        }
        if (playerSpawnerCount == 0) {
            return true;
        }
        if (PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumSpawnedPokemon() / playerSpawnerCount < effectiveCapacity) {
            effectiveCapacity = Math.min(effectiveCapacity, PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumSpawnedPokemon() / playerSpawnerCount);
        }
        return numSpawns + this.spawnedTracker.count() <= effectiveCapacity;
    }

    @Override
    public boolean canSpawn(SpawnAction<?> action) {
        ServerPlayerEntity playerByUUID = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.playerUUID);
        if (playerByUUID == null || !playerByUUID.func_70089_S() || playerByUUID.func_193105_t() || playerByUUID.func_70644_a((Effect)EffectRegistration.REPEL.get())) {
            return false;
        }
        if (action instanceof SpawnActionPokemon) {
            PixelmonEntity pixelmon = (PixelmonEntity)((SpawnActionPokemon)action).getOrCreateEntity();
            if (pixelmon == null) {
                if (this.playerStorage.getTeam().get(0).getHeldItemAsItemHeld().getHeldItemType() != EnumHeldItems.cleanseTag) {
                    Pixelmon.LOGGER.error("Invalid spawnset: " + action);
                }
                return false;
            }
            SpawnLocationType[] slt = pixelmon.getForm().getSpawn().getSpawnLocations();
            boolean matches = false;
            for (SpawnLocationType s : slt) {
                if (s != SpawnLocationType.AIR && s != SpawnLocationType.AIR_PERSISTENT) continue;
                matches = true;
                break;
            }
            if (action.spawnInfo.stringLocationTypes != null && action.spawnInfo.stringLocationTypes.contains("Air") || pixelmon.getForm() != null && matches) {
                int playerFlyingPokes = this.spawnedTracker.countAllFlyingPoke();
                long maxFlying = PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumSpawnedPokemon();
                long playerSpawnerCount = PixelmonSpawning.coordinator.spawners.stream().filter(it -> it instanceof PlayerTrackingSpawner).count();
                if (playerSpawnerCount == 0L) {
                    playerSpawnerCount = 1L;
                }
                return (long)(playerFlyingPokes + 1) <= (maxFlying = Math.min(maxFlying, (long)PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumSpawnedPokemon() / playerSpawnerCount));
            }
        }
        return super.canSpawn(action);
    }

    @Override
    public boolean shouldDoSpawning() {
        if (PixelmonConfigProxy.getSpawning().isSpawningDisabledDimension((World)this.getTrackedPlayer().func_71121_q())) {
            return false;
        }
        return super.shouldDoSpawning();
    }

    public boolean isTrackedPlayerOnline() {
        return this.getTrackedPlayer() != null;
    }

    @Override
    public List<SpawnAction<? extends Entity>> getSpawns(int pass) {
        if (pass == 0) {
            this.possibleSpawns = new ArrayList<SpawnAction<? extends Entity>>();
            ServerPlayerEntity player = this.getTrackedPlayer();
            if (player != null) {
                if (player.func_226278_cu_() < 0.0 || player.func_226278_cu_() > 255.0) {
                    return null;
                }
                if (this.playerStorage == null) {
                    this.playerStorage = StorageProxy.getParty(player);
                    if (this.playerStorage == null) {
                        return null;
                    }
                }
                if (this.lastStorageCheck < System.currentTimeMillis() + 10000L) {
                    if (this.playerStorage != null) {
                        this.playerStorage.updatePartyCache();
                    }
                    this.lastStorageCheck = System.currentTimeMillis();
                    this.spawnedTracker.removeNonExistent();
                }
                this.isBusy = true;
                this.getTrackedBlockCollection((Entity)player, this.horizontalTrackFactor, this.verticalTrackFactor, this.horizontalSliceRadius, this.verticalSliceRadius, this.minDistFromCentre, this.maxDistFromCentre).whenCompleteAsync((blockCollection, throwable) -> {
                    if (blockCollection == null) {
                        this.isBusy = false;
                        return;
                    }
                    ArrayList<SpawnLocation> spawnLocations = this.spawnLocationCalculator.calculateSpawnableLocations((BlockCollection)blockCollection);
                    Collections.shuffle(spawnLocations);
                    this.possibleSpawns = this.selectionAlgorithm.calculateSpawnActions(this, this.spawnSets, spawnLocations);
                    this.isBusy = false;
                }, (Executor)SpawnerCoordinator.PROCESSOR);
            }
            return null;
        }
        if (this.possibleSpawns == null || this.possibleSpawns.isEmpty()) {
            return null;
        }
        this.possibleSpawns.removeIf(action -> {
            action.applyLocationMutations();
            if (!this.canSpawn((SpawnAction<?>)action)) {
                return true;
            }
            return !action.spawnLocation.location.world.func_225317_b(Entity.class, AxisAlignedBB.func_241550_g_((double)this.minDistBetweenSpawns, (double)this.minDistBetweenSpawns, (double)this.minDistBetweenSpawns).func_186670_a((BlockPos)action.spawnLocation.location.pos)).isEmpty();
        });
        return this.possibleSpawns;
    }

    public static class PlayerTrackingSpawnerBuilder<T extends PlayerTrackingSpawner>
    extends TickingSpawner.TickingSpawnerBuilder<T> {
        public Integer minDistFromCentre = null;
        public Integer maxDistFromCentre = null;
        public Float horizontalTrackFactor = null;
        public Float verticalTrackFactor = null;
        public Integer horizontalSliceRadius = null;
        public Integer verticalSliceRadius = null;

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setDistanceFromCentre(int minimum, int maximum) {
            if (minimum < 0) {
                minimum = 0;
            }
            this.minDistFromCentre = minimum;
            if (maximum < 0) {
                maximum = 0;
            }
            this.maxDistFromCentre = maximum;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setTrackFactors(float horizontal, float vertical) {
            this.horizontalTrackFactor = Float.valueOf(horizontal);
            this.verticalTrackFactor = Float.valueOf(vertical);
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setSliceRadii(int horizontal, int vertical) {
            if (horizontal < 1) {
                horizontal = 1;
            }
            this.horizontalSliceRadius = horizontal;
            if (vertical < 1) {
                vertical = 1;
            }
            this.verticalSliceRadius = vertical;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        @Override
        public T apply(T spawner) {
            ((PlayerTrackingSpawner)spawner).minDistFromCentre = this.minDistFromCentre != null ? this.minDistFromCentre.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getMinimumDistanceFromCentre();
            ((PlayerTrackingSpawner)spawner).maxDistFromCentre = this.maxDistFromCentre != null ? this.maxDistFromCentre.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getMaximumDistanceFromCentre();
            ((PlayerTrackingSpawner)spawner).verticalTrackFactor = this.verticalTrackFactor != null ? this.verticalTrackFactor.floatValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getVerticalTrackFactor();
            ((PlayerTrackingSpawner)spawner).horizontalTrackFactor = this.horizontalTrackFactor != null ? this.horizontalTrackFactor.floatValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getHorizontalTrackFactor();
            ((PlayerTrackingSpawner)spawner).verticalSliceRadius = this.verticalSliceRadius != null ? this.verticalSliceRadius.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getVerticalSliceRadius();
            ((PlayerTrackingSpawner)spawner).horizontalSliceRadius = this.horizontalSliceRadius != null ? this.horizontalSliceRadius.intValue() : PixelmonConfigProxy.getSpawning().getWildSpawning().getHorizontalSliceRadius();
            PlayerPartyStorage party = StorageProxy.getParty(((PlayerTrackingSpawner)spawner).playerUUID);
            ((PlayerTrackingSpawner)spawner).rarityTweaks.add(party);
            super.apply(spawner);
            return spawner;
        }
    }
}

