/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TeleportPosition
implements ISaveData {
    private RegistryKey<World> dimension;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public BlockPos getPosition() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        if (this.dimension != null && this.dimension != World.field_234918_g_) {
            nbt.func_74778_a("tpDimension", this.dimension.getRegistryName().toString());
        }
        nbt.func_74780_a("tpPosX", this.x);
        nbt.func_74780_a("tpPosY", this.y);
        nbt.func_74780_a("tpPosZ", this.z);
        nbt.func_74776_a("tpRotY", this.yaw);
        nbt.func_74776_a("tpRotP", this.pitch);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.dimension = nbt.func_74764_b("tpDimension") ? RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ResourceLocationHelper.of(nbt.func_74779_i("tpDimension"))) : RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ResourceLocationHelper.of("overworld"));
        this.x = nbt.func_74769_h("tpPosX");
        this.y = nbt.func_74769_h("tpPosY");
        this.z = nbt.func_74769_h("tpPosZ");
        this.yaw = nbt.func_74760_g("tpRotY");
        this.pitch = nbt.func_74760_g("tpRotP");
    }

    public void store(RegistryKey<World> dimension, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this.dimension = dimension;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.yaw = rotationYaw;
        this.pitch = rotationPitch;
    }

    public void teleport(ServerPlayerEntity player) {
        ServerWorld world = player.func_184102_h().func_71218_a(this.dimension);
        if (world == null) {
            return;
        }
        player.func_200619_a(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }
}

