/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.tree.berry;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.blocks.ApricornLeavesBlock;
import com.pixelmonmod.pixelmon.enums.items.ApricornType;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;

public class ApricornTreeFeatureConfig
extends BaseTreeFeatureConfig {
    protected ApricornTreeFeatureConfig(BlockStateProvider p_i232020_1_, BlockStateProvider p_i232020_2_, FoliagePlacer p_i232020_3_, AbstractTrunkPlacer p_i232020_4_, AbstractFeatureSizeType p_i232020_5_, List<TreeDecorator> p_i232020_6_, int p_i232020_7_, boolean p_i232020_8_, Heightmap.Type p_i232020_9_) {
        super(p_i232020_1_, p_i232020_2_, p_i232020_3_, p_i232020_4_, p_i232020_5_, p_i232020_6_, p_i232020_7_, p_i232020_8_, p_i232020_9_);
    }

    public static class Builder {
        public final BlockStateProvider trunkProvider;
        public final BlockStateProvider leavesProvider;
        private final FoliagePlacer foliagePlacer;
        private final AbstractTrunkPlacer trunkPlacer;
        private final AbstractFeatureSizeType minimumSize;
        private List<TreeDecorator> decorators = ImmutableList.of();
        private int maxWaterDepth;
        private boolean ignoreVines;
        private Heightmap.Type heightmap = Heightmap.Type.OCEAN_FLOOR;

        public Builder(ApricornType type, FoliagePlacer p_i232021_3_, AbstractTrunkPlacer p_i232021_4_) {
            this.trunkProvider = new SimpleBlockStateProvider(type.logBlock().func_176223_P());
            this.leavesProvider = new WeightedBlockStateProvider().func_227407_a_(type.leavesBlock().func_176223_P(), 19).func_227407_a_((BlockState)type.leavesBlock().func_176223_P().func_206870_a((Property)ApricornLeavesBlock.AGE, (Comparable)Integer.valueOf(2)), 1);
            this.foliagePlacer = p_i232021_3_;
            this.trunkPlacer = p_i232021_4_;
            this.minimumSize = new TwoLayerFeature(1, 0, 1);
        }

        public Builder decorators(List<TreeDecorator> p_236703_1_) {
            this.decorators = p_236703_1_;
            return this;
        }

        public Builder maxWaterDepth(int p_236701_1_) {
            this.maxWaterDepth = p_236701_1_;
            return this;
        }

        public Builder ignoreVines() {
            this.ignoreVines = true;
            return this;
        }

        public Builder heightmap(Heightmap.Type p_236702_1_) {
            this.heightmap = p_236702_1_;
            return this;
        }

        public BaseTreeFeatureConfig build() {
            return new ApricornTreeFeatureConfig(this.trunkProvider, this.leavesProvider, this.foliagePlacer, this.trunkPlacer, this.minimumSize, this.decorators, this.maxWaterDepth, this.ignoreVines, this.heightmap);
        }
    }
}

