/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.crater;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CraterGyserFeature
extends Feature<NoFeatureConfig> {
    public CraterGyserFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.015f)) {
            return false;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos.func_177958_n(), generator.func_222532_b(pos.func_177958_n(), pos.func_177956_o(), Heightmap.Type.WORLD_SURFACE_WG), pos.func_177952_p());
        while (mutablePos.func_177956_o() > 20 && ((blockState = level.func_180495_p((BlockPos)mutablePos)).func_203425_a(Blocks.field_150350_a) || blockState.func_203425_a(Blocks.field_150355_j))) {
            mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
        }
        int originY = mutablePos.func_177956_o();
        int originZ = mutablePos.func_177952_p();
        int originX = mutablePos.func_177958_n();
        int maxHeight = RandomHelper.getRandomNumberBetween(10, 40);
        int maxRadius = RandomHelper.getRandomNumberBetween(10, 30);
        int numPoints = 900;
        int minRadius = RandomHelper.getRandomNumberBetween(10, 15);
        for (int h = 0; h < maxHeight; ++h) {
            double radius = (double)(maxRadius * (maxHeight - h)) / (double)maxHeight;
            if (radius < (double)minRadius) continue;
            for (int i = 0; i < numPoints; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numPoints;
                mutablePos.func_189532_c((double)originX + radius * Math.cos(angle), (double)(originY + h), (double)originZ + radius * Math.sin(angle));
                this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, Blocks.field_196856_iQ.func_176223_P());
            }
            int r = 0;
            while ((double)r < radius) {
                for (int i = 0; i < numPoints; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)numPoints;
                    mutablePos.func_189532_c((double)originX + (double)r * Math.cos(angle), (double)(originY + h), (double)originZ + (double)r * Math.sin(angle));
                    if (!level.func_180495_p((BlockPos)mutablePos).func_203425_a(Blocks.field_150350_a)) continue;
                    this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, h == 0 ? Blocks.field_196814_hQ.func_176223_P() : Blocks.field_150355_j.func_176223_P());
                }
                ++r;
            }
        }
        return true;
    }
}

