/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.crater;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CraterMetalPipeFeature
extends Feature<NoFeatureConfig> {
    public CraterMetalPipeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.05f)) {
            return false;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos.func_177958_n(), generator.func_222532_b(pos.func_177958_n(), pos.func_177956_o(), Heightmap.Type.WORLD_SURFACE_WG), pos.func_177952_p());
        while (mutablePos.func_177956_o() > 20 && ((blockState = level.func_180495_p((BlockPos)mutablePos)).func_203425_a(Blocks.field_150350_a) || blockState.func_203425_a(Blocks.field_150355_j))) {
            mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
        }
        int originY = mutablePos.func_177956_o() + random.nextInt(8);
        int originZ = mutablePos.func_177952_p();
        int originX = mutablePos.func_177958_n();
        boolean xDirection = random.nextBoolean();
        int coil = RandomHelper.getRandomNumberBetween(1, 4);
        BlockState randomBlock = this.getRandomBlock().func_176223_P();
        for (int length = -10; length <= 0; ++length) {
            for (double i = 0.0; i <= Math.PI * 2; i += 0.05235987755982988) {
                double radius = 3.5 * Math.sin(i);
                double y = 3.5 * Math.cos(i) + (double)(length / coil);
                if (xDirection) {
                    mutablePos.func_223471_o(originX + length);
                    mutablePos.func_223472_q((int)((double)originZ + radius));
                } else {
                    mutablePos.func_223472_q(originZ + length);
                    mutablePos.func_223471_o((int)((double)originX + radius));
                }
                mutablePos.func_185336_p((int)((double)originY + y));
                this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, randomBlock);
                if (xDirection) {
                    mutablePos.func_223471_o(originX - length);
                } else {
                    mutablePos.func_223472_q(originZ - length);
                }
                this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, randomBlock);
            }
        }
        return true;
    }

    private Block getRandomBlock() {
        if (RandomHelper.getRandomChance(0.45f)) {
            return Blocks.field_150339_S;
        }
        if (RandomHelper.getRandomChance(0.45f)) {
            return PixelmonBlocks.aluminium_block;
        }
        if (RandomHelper.getRandomChance(0.05f)) {
            return PixelmonBlocks.silver_block;
        }
        if (RandomHelper.getRandomChance(0.05f)) {
            return PixelmonBlocks.platinum_block;
        }
        return Blocks.field_189880_di;
    }
}

