/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.accessors;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import java.util.ArrayList;
import java.util.List;

public class CardAttacks {
    public static void register(CardAttack attack) {
        if (attack != null) {
            RegistryManager.register(attack.getID(), attack);
        }
    }

    public static CardAttack get(String id) {
        return RegistryValue.of(CardAttack.class, id).getValueUnsafe();
    }

    public static CardAttack get(String card, int attack) {
        return CardAttacks.get(card + "#" + attack);
    }

    public static List<CardAttack> getAll() {
        return Lists.newArrayList(RegistryManager.getAllValues(CardAttack.class));
    }

    public static List<CardAttack> getAllFor(String card) {
        return CardAttacks.getAllFor(card, 4);
    }

    public static List<CardAttack> getAllFor(String card, int depth) {
        ArrayList attacks = Lists.newArrayList();
        for (int i = 0; i < depth; ++i) {
            RegistryValue.of(CardAttack.class, card + "#" + i).ifInitialized(attacks::add);
        }
        return attacks;
    }
}

