/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.config.impl;

import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/tcg.yml")
public class TCGConfig
extends AbstractYamlConfig {
    private int essenceRadius = 30;
    private double essencePerKnockout = 1.5;
    private double rarePokemonEssenceModifier = 3.75;
    private double randomTickEssenceGainChance = 0.5;
    private boolean generateCosmeticsInCardShop = true;
    private int maxTradesPerTrader = 12;
    private int essenceToFillJar = 100;
    private int savedUIScale = -1;

    public double getEssencePerKnockout() {
        return this.essencePerKnockout;
    }

    public double getRarePokemonEssenceModifier() {
        return this.rarePokemonEssenceModifier;
    }

    public double getEssenceRadius() {
        return this.essenceRadius;
    }

    public double getRandomTickEssenceGainChance() {
        return this.randomTickEssenceGainChance;
    }

    public boolean shouldRandomTickGainEssence() {
        return RandomHelper.getRandom().nextDouble() < this.randomTickEssenceGainChance;
    }

    public int getEssenceToFillJar() {
        return this.essenceToFillJar;
    }

    public int getSavedUIScale() {
        return this.savedUIScale;
    }

    public void setSavedUIScale(int savedUIScale) {
        this.savedUIScale = savedUIScale;
    }

    public int getEssenceDropped(boolean rare) {
        double amount = this.essencePerKnockout * (rare ? this.rarePokemonEssenceModifier : 1.0);
        double amountFloor = Math.floor(amount);
        return (int)(amountFloor + (double)(RandomHelper.getRandom().nextDouble() < amount - amountFloor ? 1 : 0));
    }

    public boolean shouldGenerateCosmeticsInCardShop() {
        return this.generateCosmeticsInCardShop;
    }

    public int getMaxTradesPerTrader() {
        return this.maxTradesPerTrader;
    }
}

