/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.PlayerTargetsScreen;
import com.pixelmonmod.tcg.client.gui.TargetScreen;
import com.pixelmonmod.tcg.client.gui.abilities.GuiOptional;
import com.pixelmonmod.tcg.client.gui.abilities.GuiPeek;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenChattableBase;
import com.pixelmonmod.tcg.client.gui.duel.CardSelector;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.duel.DuelLogScreen;
import com.pixelmonmod.tcg.client.gui.duel.FlippingCoinScreen;
import com.pixelmonmod.tcg.client.gui.duel.InspectingCard;
import com.pixelmonmod.tcg.client.gui.duel.PrizeSelectorScreen;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorPurpose;
import com.pixelmonmod.tcg.client.helper.BattleHelper;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.client.renderers.BattleControllerTileEntityRenderer;
import com.pixelmonmod.tcg.duel.RenderDuel;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.GenericGUIPacket;
import com.pixelmonmod.tcg.network.packets.battles.GenericActionRequestPacket;
import com.pixelmonmod.tcg.network.packets.battles.UpdateServerCardRecordPacket;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.network.packets.enums.PhaseAction;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.apache.commons.lang3.tuple.Pair;

public class TCGScreen
extends TCGScreenChattableBase {
    public static final String GUI_PEEK_ID = "GUI_PEEK";
    public static final String GUI_OPTIONAL_ID = "GUI_OPTIONAL";
    private static final int BUTTON_ENDTURN_ID = 10;
    private static final int BUTTON_DISCARD_ID = 11;
    public BattleOwnedTileEntityController controller;
    private final int playerIndex;
    private boolean isCardInSelectMode = false;
    private CardWithLocation draggingCard = null;
    private final InspectingCard inspectingCard;
    private final CardSelector cardSelector;
    private final FlippingCoinScreen guiFlippingCoin;
    private final DuelLogScreen guiDuelLog;
    private final PrizeSelectorScreen guiPrizeSelector;
    boolean isSpectating = false;
    private int ticks = 0;
    public double guiScaling;
    public float scaledWidth;
    public float scaledHeight;
    public float scaledFactor;
    private final Set<Screen> subGui = Sets.newHashSet();
    private final PlayerTargetsScreen myTargets;
    private final PlayerTargetsScreen oppTargets;
    private final IndexedButton buttonEndTurn = new IndexedButton(10, 0, 0, 80, 20, "End turn", this::actionPerformed);
    private final IndexedButton buttonDiscard = new IndexedButton(11, 0, 0, 80, 20, "Discard", this::actionPerformed);
    private final TargetScreen buttonAbility;
    private final TargetScreen[] buttonAttacks;
    private final TargetScreen buttonRetreat;
    private final GuiPeek guiPeek;
    private final GuiOptional guiOptional;

    public TCGScreen(BattleOwnedTileEntityController controller, int playerIndex, boolean isSpectating) {
        this.controller = controller;
        this.playerIndex = playerIndex;
        this.isSpectating = isSpectating;
        this.inspectingCard = new InspectingCard(this);
        this.cardSelector = new CardSelector(this, controller);
        this.guiFlippingCoin = new FlippingCoinScreen(this, controller);
        this.guiDuelLog = new DuelLogScreen(this);
        this.guiPrizeSelector = new PrizeSelectorScreen(this, controller);
        this.guiPeek = new GuiPeek(this, controller);
        this.guiPeek.visible = false;
        this.guiOptional = new GuiOptional(this, controller);
        this.guiOptional.visible = false;
        this.myTargets = new PlayerTargetsScreen();
        this.oppTargets = new PlayerTargetsScreen();
        this.buttonAbility = new TargetScreen(0.0f);
        this.buttonAttacks = new TargetScreen[3];
        for (int i = 0; i < this.buttonAttacks.length; ++i) {
            this.buttonAttacks[i] = new TargetScreen(0.0f);
        }
        this.buttonRetreat = new TargetScreen(0.0f);
    }

    public InspectingCard getInspectingCard() {
        return this.inspectingCard;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.updateLocalDimensions();
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)this.buttonEndTurn);
        this.func_230480_a_((Widget)this.buttonDiscard);
        this.buttonDiscard.field_230694_p_ = false;
        this.subGui.clear();
        this.subGui.add(this.cardSelector);
        this.subGui.add(this.guiFlippingCoin);
        this.subGui.add(this.guiPrizeSelector);
        this.subGui.add(this.guiPeek);
        this.subGui.add(this.guiOptional);
        this.subGui.forEach(screen -> screen.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_));
        this.updateTargetPositions();
        this.field_230706_i_.field_71474_y.field_74319_N = true;
        ForgeIngameGui.renderObjective = false;
        CursorHelper.setCursor(CursorHelper.BATTLE_CURSOR);
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
        this.field_230706_i_.field_71474_y.field_74319_N = false;
        this.field_230706_i_.field_71474_y.field_74335_Z = TCGConfigProxy.getConfig().getSavedUIScale();
        ForgeIngameGui.renderObjective = true;
        BattleHelper.resetViewEntity();
        NetworkHelper.sendToServer(new GenericGUIPacket(GenericGUIPacket.GUITypes.spectating(this.isSpectating), false, this.controller.func_174877_v()));
        this.controller = null;
        CursorHelper.resetCursor();
    }

    @Override
    public void func_231023_e_() {
        if (this.controller == null) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        super.func_231023_e_();
        if (this.ticks == 0) {
            this.updateCameraPositions(BattleControllerTileEntityRenderer.getFacing(this.controller));
        }
        BattleHelper.setViewEntity((Entity)ClientProxy.camera);
        if (this.controller != null && this.controller.getClient() != null && this.controller.getClient().getMe() != null) {
            BaseTrainerEffect effect;
            float width;
            CommonCardState card;
            GameClientState client = this.controller.getClient();
            PlayerClientMyState me = client.getMe();
            PlayerClientOpponentState opp = client.getOpponent();
            if (me.getPendingPrizeCount() > 0 || !this.controller.getShowingPrizes().isEmpty()) {
                if (me.getPendingPrizePlayerIndex() == client.getPlayerIndex()) {
                    this.guiPrizeSelector.setPrizes(me.getPrizeCards());
                } else {
                    this.guiPrizeSelector.setPrizes(opp.getPrizeCards());
                }
            } else {
                this.guiPrizeSelector.setPrizes(null);
            }
            if (this.inspectingCard != null && this.inspectingCard.getCard() != null && (card = this.inspectingCard.getCard()) instanceof PokemonCardState) {
                PokemonCardState pokemon = (PokemonCardState)card;
                int line = 0;
                if (pokemon.getAbility() != null) {
                    line = 3;
                    if (pokemon.getData().getAttacks().size() == 1 && pokemon.getData().getAttacks().get(0).getText() == null) {
                        line = 5;
                    }
                }
                int[] attackLines = CardRenderingHelper.calculateAttackDescriptionLines(pokemon.getAttacksStatus(), pokemon.getAbility() != null, 94);
                for (int i = 0; i < attackLines.length; ++i) {
                    float spacing = 9.0f;
                    int offset = i > 0 && attackLines[i - 1] == 0 ? 2 : 0;
                    int height = 12 - offset;
                    if (attackLines[i] == 0 && i < attackLines.length - 1) {
                        height -= 2;
                    }
                    this.buttonAttacks[i].setHeight(height);
                    this.buttonAttacks[i].setX((int)((double)(this.scaledWidth / 2.0f) + (double)(this.inspectingCard.isPickingAttack() ? 0 : 150) * this.guiScaling - 56.0));
                    this.buttonAttacks[i].setY((int)(this.scaledHeight / 2.0f + (-2.0f + (float)line * spacing + (float)offset)));
                    line += attackLines[i] + 1;
                }
            }
            if (me.getActiveCard() == null && client.getGamePhase().after(GamePhase.PreMatch) && me.hasPrizeLeft() && opp.hasPrizeLeft() && this.guiPrizeSelector.getPrizes() == null) {
                if (this.cardSelector.getPurpose() == null) {
                    CardSelectorState state = SelectorHelper.generateSelectorForBench(me, "battle.selector.newactive");
                    this.cardSelector.set(CardSelectorPurpose.KnockoutSwitch, state);
                }
            } else if (me.getActiveCard() != null && this.cardSelector.getPurpose() == CardSelectorPurpose.KnockoutSwitch) {
                this.cardSelector.set(null, null);
            } else if (me.getCardSelectorState() != null) {
                this.cardSelector.set(CardSelectorPurpose.Trainer, this.controller.getClient().getMe().getCardSelectorState());
                this.inspectingCard.clear();
            } else if (this.cardSelector.getPurpose() == CardSelectorPurpose.Trainer) {
                this.cardSelector.set(null, null);
            }
            if ((this.cardSelector.getPurpose() == CardSelectorPurpose.FinishRetreating || this.cardSelector.getPurpose() == CardSelectorPurpose.StartRetreating) && this.cardSelector.getData().isCancellable() && !client.isMyTurn()) {
                this.cardSelector.set(null, null);
            }
            if (me.isChoosingOppAttack()) {
                this.inspectingCard.set(opp.getActiveCard(), false, BoardLocation.Active, 0, true, "Choose an attack", true);
            } else if (this.inspectingCard.isPickingAttack()) {
                this.inspectingCard.clear();
            }
            if (this.myTargets.handTargets.size() != me.getHand().size()) {
                ArrayList handTargets = Lists.newArrayList();
                for (int i = 0; i < me.getHand().size(); ++i) {
                    handTargets.add(new TargetScreen(0.0f));
                }
                this.myTargets.handTargets = handTargets;
            }
            for (int i = 0; i < this.myTargets.handTargets.size(); ++i) {
                double cardOffset = 12.6 * (double)i;
                double handOffset = -5.5 * (double)this.myTargets.handTargets.size() - 10.0;
                width = i < this.myTargets.handTargets.size() - 1 ? 12.6f : 26.0f;
                this.myTargets.handTargets.get(i).setWidth((int)((double)width * this.guiScaling));
                this.myTargets.handTargets.get(i).setHeight((int)(40.0 * this.guiScaling));
                this.myTargets.handTargets.get(i).setX((int)(this.scaledWidth / 2.0f + (float)((int)((handOffset + cardOffset) * this.guiScaling))));
                this.myTargets.handTargets.get(i).setY((int)(this.scaledHeight - (float)((int)(42.0 * this.guiScaling))));
            }
            if (this.oppTargets.handTargets.size() != opp.getHand().size()) {
                ArrayList<TargetScreen> handTargets = new ArrayList<TargetScreen>();
                for (int i = 0; i < opp.getHand().size(); ++i) {
                    handTargets.add(new TargetScreen(0.0f));
                }
                this.oppTargets.handTargets = handTargets;
            }
            for (int i = 0; i < this.oppTargets.handTargets.size(); ++i) {
                double cardOffset = 12.6 * (double)i;
                double handOffset = -5.5 * (double)this.oppTargets.handTargets.size() - 10.0;
                width = i < this.oppTargets.handTargets.size() - 1 ? 12.6f : 26.0f;
                this.oppTargets.handTargets.get(i).setWidth((int)((double)width * this.guiScaling));
                this.oppTargets.handTargets.get(i).setHeight((int)(40.0 * this.guiScaling));
                this.oppTargets.handTargets.get(i).setX((int)(this.scaledWidth / 2.0f + (float)((int)((handOffset + cardOffset) * this.guiScaling))));
                this.oppTargets.handTargets.get(i).setY((int)(-33.0 * this.guiScaling));
            }
            this.buttonEndTurn.field_230694_p_ = this.cardSelector.getData() == null && client.getCoinFlip() == null && !this.isSpectating;
            boolean bl = this.buttonEndTurn.field_230693_o_ = client.getGamePhase().after(GamePhase.PreMatch) && client.isMyTurn() || !client.getGamePhase().after(GamePhase.PreMatch) && me.getActiveCard() != null && !me.isReady();
            if (client.getGamePhase() == GamePhase.PreMatch && !this.controller.getClient().getMe().isReady() || client.getGamePhase() != GamePhase.PreMatch && this.controller.getClient().isMyTurn()) {
                if (client.getGamePhase() == GamePhase.PreMatch) {
                    this.buttonEndTurn.setMessage("Start Game");
                } else {
                    this.buttonEndTurn.setMessage("End Turn");
                }
            } else {
                this.buttonEndTurn.setMessage("Waiting...");
            }
            this.buttonDiscard.field_230694_p_ = false;
            if (this.inspectingCard != null && this.inspectingCard.getCard() != null && this.inspectingCard.isMine() && !this.isSpectating && (effect = this.inspectingCard.getCard().getData().getEffect()) != null && effect.showDiscardButton()) {
                this.buttonDiscard.field_230694_p_ = true;
            }
            if (me.getCustomGUI() != null) {
                switch (me.getCustomGUI()) {
                    case "GUI_PEEK": {
                        this.guiPeek.visible = true;
                        this.guiPeek.func_231160_c_();
                        break;
                    }
                    case "GUI_OPTIONAL": {
                        this.guiOptional.visible = true;
                        this.guiOptional.func_231160_c_();
                        break;
                    }
                    default: {
                        this.guiPeek.visible = false;
                        this.guiOptional.visible = false;
                        break;
                    }
                }
            } else {
                this.guiPeek.visible = false;
                this.guiOptional.visible = false;
            }
            this.inspectingCard.update(this.isRightMousePressed());
            this.subGui.forEach(Screen::func_231023_e_);
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean enabled;
        GameClientState client = this.controller.getClient();
        PlayerClientMyState me = client.getMe();
        if (me == null) {
            return false;
        }
        PlayerClientOpponentState opp = client.getOpponent();
        List<ImmutableCard> myHand = me.getHand();
        boolean handled = false;
        boolean bl = enabled = this.cardSelector.getData() == null && (client.getCoinFlip() == null || client.getCoinFlip().getResults().isEmpty()) && this.guiPrizeSelector.getPrizes() == null && !this.guiPeek.visible && !this.guiOptional.visible;
        if (enabled && !this.isSpectating) {
            int pos;
            this.handleAbilityButton(this.controller.getClient().getPlayerIndex(), this.controller.getClient().isMyTurn(), mouseX, mouseY, me);
            this.handleAttackButtons(this.controller.getClient().getPlayerIndex(), this.controller.getClient().isMyTurn(), mouseX, mouseY, me);
            handled = this.handleRetreatButton(this.controller.getClient().isMyTurn(), mouseX, mouseY, me, opp) || handled;
            for (pos = 0; pos < myHand.size(); ++pos) {
                handled = this.handleCardInHand(mouseX, mouseY, mouseButton, myHand, opp.getHand(), pos, true) || handled;
            }
            for (pos = 0; pos < opp.getHand().size(); ++pos) {
                handled = this.handleCardInHand(mouseX, mouseY, mouseButton, myHand, opp.getHand(), pos, false) || handled;
            }
        }
        if (this.draggingCard == null) {
            this.isCardInSelectMode = false;
        }
        if (enabled) {
            handled = this.handleActiveCards(mouseX, mouseY, me, opp) || handled;
            handled = this.handleBenchCards(mouseX, mouseY, me, opp) || handled;
            boolean bl2 = handled = this.handleTrainerCards(mouseX, mouseY, me, opp) || handled;
        }
        if (!handled) {
            this.inspectingCard.clear();
        }
        if (this.draggingCard == null && me.getCardSelectorState() == null && this.isLeftMousePressed()) {
            if ((this.playerIndex == 0 && mouseX > (double)(this.scaledWidth / 2.0f - 106.0f) && mouseX < (double)(this.scaledWidth / 2.0f - 78.0f) && mouseY < (double)(this.scaledHeight / 2.0f + 72.0f) && mouseY > (double)(this.scaledHeight / 2.0f + 51.0f) || this.playerIndex == 1 && mouseX > (double)(this.scaledWidth / 2.0f + 79.0f) && mouseX < (double)(this.scaledWidth / 2.0f + 107.0f) && mouseY < (double)(this.scaledHeight / 2.0f + 72.0f) && mouseY > (double)(this.scaledHeight / 2.0f + 51.0f)) && !me.getDiscardPile().isEmpty()) {
                CardSelectorState discard = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false, "selector.mydiscard");
                for (ImmutableCard c : me.getDiscardPile()) {
                    discard.getCardList().add(new CardWithLocation(new CommonCardState(c), true, BoardLocation.DiscardPile, 0));
                }
                me.setCardSelectorState(discard);
            }
            if ((this.playerIndex == 0 && mouseX > (double)(this.scaledWidth / 2.0f - 106.0f) && mouseX < (double)(this.scaledWidth / 2.0f - 78.0f) && mouseY < (double)(this.scaledHeight / 2.0f - 94.0f) && mouseY > (double)(this.scaledHeight / 2.0f - 115.0f) || this.playerIndex == 1 && mouseX > (double)(this.scaledWidth / 2.0f + 79.0f) && mouseX < (double)(this.scaledWidth / 2.0f + 107.0f) && mouseY < (double)(this.scaledHeight / 2.0f - 94.0f) && mouseY > (double)(this.scaledHeight / 2.0f - 115.0f)) && !opp.getDiscardPile().isEmpty()) {
                CardSelectorState discard = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false, "selector.oppdiscard");
                for (ImmutableCard c : opp.getDiscardPile()) {
                    discard.getCardList().add(new CardWithLocation(new CommonCardState(c), false, BoardLocation.DiscardPile, 0));
                }
                me.setCardSelectorState(discard);
            }
        }
        this.subGui.forEach(screen -> screen.func_231044_a_(mouseX, mouseY, mouseButton));
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        GameClientState client = this.controller.getClient();
        PlayerClientMyState me = client.getMe();
        if (me != null) {
            List<ImmutableCard> myHand = me.getHand();
            if (this.draggingCard != null) {
                this.releaseDraggingCard((int)mouseX, (int)mouseY, myHand, this.controller.getClient().getPlayerIndex());
            }
        }
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.updateLocalDimensions();
        this.updateTargetPositions();
        if (this.field_230706_i_ != null && this.controller != null && this.controller.getClient() != null) {
            if (this.controller.getClient().getMe() == null || this.controller.getClient().getOpponent() == null) {
                String s = "Waiting for another player...";
                ScreenHelper.drawString(matrix, s, this.scaledWidth / 2.0f - (float)ScreenHelper.getStringWidth(s) / 2.0f, this.scaledHeight / 2.0f, 0xFFFFFF, true);
                this.buttonEndTurn.field_230694_p_ = false;
            } else {
                String text;
                this.myTargets.draw(matrix, mouseX, mouseY);
                this.oppTargets.draw(matrix, mouseX, mouseY);
                GameClientState client = this.controller.getClient();
                PlayerClientMyState me = client.getMe();
                PlayerClientOpponentState opp = client.getOpponent();
                List<ImmutableCard> myHand = me.getHand();
                List<ImmutableCard> oppHand = opp.getHand();
                if (client.getGamePhase() == GamePhase.PreMatch && !this.isSpectating) {
                    ResourceLocation tex = client.isMyTurn() ? Coins.get(this.controller.getClient().getMe().getCoinSetID()).getHeads() : Coins.get(this.controller.getClient().getMe().getCoinSetID()).getTails();
                    ScreenHelper.drawImageQuad(tex, matrix, (float)this.field_230706_i_.func_228018_at_().func_198109_k() / this.scaledFactor - 50.0f, 33.0f, 40.0f, 40.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                    text = client.isMyTurn() ? I18n.func_135052_a((String)"battle.first", (Object[])new Object[0]) : I18n.func_135052_a((String)"battle.second", (Object[])new Object[0]);
                    ScreenHelper.drawString(matrix, text, this.scaledWidth - (float)ScreenHelper.getStringWidth(text) - 50.0f, 40.0f, 0xFFFFFF, true);
                    int topY = -60;
                    int lineHeight = 12;
                    int offset = 80;
                    RenderDuel.draw2DRectangle(matrix, this.scaledWidth / 2.0f + (float)offset - 5.0f, this.scaledWidth, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 4) + 8.0f + 5.0f, this.scaledHeight / 2.0f + (float)topY - 5.0f, 0.0f, 0.0f, 0.0f, 0.5f);
                    ScreenHelper.drawString(matrix, I18n.func_135052_a((String)"battle.guide.settingup.title", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY, 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.func_135052_a((String)"battle.guide.settingup.1", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)lineHeight, 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.func_135052_a((String)"battle.guide.settingup.2", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 2), 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.func_135052_a((String)"battle.guide.settingup.3", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 3), 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.func_135052_a((String)"battle.guide.settingup.4", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 4), 0xFFFFFF, true);
                }
                if (this.isSpectating) {
                    int topY = 10;
                    String title = I18n.func_135052_a((String)"battleSpectator.title", (Object[])new Object[0]);
                    int titleWidth = ScreenHelper.getStringWidth(title);
                    String player1 = this.controller.getClient().getMe().getPlayerName();
                    if (this.controller.getClient().isMyTurn()) {
                        player1 = TextFormatting.AQUA + "> " + player1;
                    }
                    int player1Width = ScreenHelper.getStringWidth(player1);
                    String player2 = this.controller.getClient().getOpponent().getPlayerName();
                    if (!this.controller.getClient().isMyTurn()) {
                        player2 = TextFormatting.AQUA + "> " + player2;
                    }
                    int player2Width = ScreenHelper.getStringWidth(player2);
                    int maxWidth = Math.max(titleWidth, Math.max(player1Width, player2Width));
                    RenderDuel.draw2DRectangle(matrix, this.scaledWidth, this.scaledWidth - 20.0f - (float)maxWidth, topY - 5, topY + 32 + 5, 0.0f, 0.0f, 0.0f, 0.5f);
                    ScreenHelper.drawString(matrix, title, this.scaledWidth - 10.0f - (float)titleWidth, topY, 0xFFFFFF);
                    ScreenHelper.drawString(matrix, player1, this.scaledWidth - 10.0f - (float)player1Width, topY + 12, 0xFFFFFF);
                    ScreenHelper.drawString(matrix, player2, this.scaledWidth - 10.0f - (float)player2Width, topY + 24, 0xFFFFFF);
                }
                matrix.func_227860_a_();
                matrix.func_227861_a_(-120.0, 0.0, 0.0);
                this.inspectingCard.render(matrix, me, opp, 3.0f);
                matrix.func_227865_b_();
                if (this.guiPrizeSelector.getPrizes() == null && !this.guiPeek.visible && !this.guiOptional.visible) {
                    this.drawHand(matrix, mouseX, mouseY, myHand, oppHand);
                    this.drawAbilityButtons(matrix, mouseX, mouseY, me);
                    this.drawAttackButtons(matrix, mouseX, mouseY, me);
                    this.drawRetreatButton(matrix, mouseX, mouseY, me, opp, client.isMyTurn());
                    if (this.draggingCard != null) {
                        this.drawDraggingCard(matrix, mouseX, mouseY, this.draggingCard.getCard(), me, opp);
                        if (this.isLeftMousePressed()) {
                            this.checkAndDrawActionHint(matrix, this.draggingCard.getCard().getData(), this.controller.getClient().isMyTurn(), mouseX, mouseY, me, this.controller.getClient().getPlayerIndex());
                        }
                    }
                    this.inspectingCard.drawTooltip(matrix, mouseX, mouseY, 4.0f);
                }
                this.guiDuelLog.draw(matrix, client.getLog(), mouseX, mouseY, 2.0f);
                for (Screen gui : this.subGui) {
                    gui.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
                }
                if (me.getCounterEndTime() != null) {
                    int secondsLeft = (int)((me.getCounterEndTime().getTime() - Calendar.getInstance().getTime().getTime()) / 1000L);
                    if (secondsLeft < 0) {
                        secondsLeft = 0;
                    }
                    text = secondsLeft + "s";
                    int color = 0xFFFFFF;
                    if (secondsLeft < 10) {
                        color = 0xFF0000;
                    }
                    ScreenHelper.drawString(matrix, text, 25.0f - (float)ScreenHelper.getStringWidth(text) / 2.0f, this.scaledHeight / 2.0f - 97.0f, color);
                } else if (opp.getCounterEndTime() != null) {
                    int secondsLeft = (int)((opp.getCounterEndTime().getTime() - Calendar.getInstance().getTime().getTime()) / 1000L);
                    if (secondsLeft < 0) {
                        secondsLeft = 0;
                    }
                    text = secondsLeft + "s";
                    ScreenHelper.drawString(matrix, text, 25.0f - (float)ScreenHelper.getStringWidth(text) / 2.0f, this.scaledHeight / 2.0f - 97.0f, 0xBBBBBB);
                }
            }
        }
    }

    protected void actionPerformed(Button button) {
        if (this.isSpectating) {
            return;
        }
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).getID()) {
                case 10: {
                    NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.func_174877_v(), PhaseAction.EndTurn, this.playerIndex, 0, 0));
                    break;
                }
                case 11: {
                    NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.func_174877_v(), PhaseAction.Discard, this.playerIndex, this.inspectingCard.getLocation().ordinal(), this.inspectingCard.getLocationSubIndex()));
                }
            }
        }
    }

    private void updateLocalDimensions() {
        this.guiScaling = (double)((float)this.field_230706_i_.func_228018_at_().func_198083_n() / 240.0f) / this.field_230706_i_.func_228018_at_().func_198100_s();
        this.scaledWidth = this.field_230706_i_.func_228018_at_().func_198107_o();
        this.scaledHeight = this.field_230706_i_.func_228018_at_().func_198087_p();
        this.scaledFactor = (float)this.field_230706_i_.func_228018_at_().func_198100_s();
    }

    private void updateTargetPositions() {
        int i;
        int battleControllerScale = (int)this.controller.getScale();
        int centerY = (int)(this.scaledHeight / 2.0f - (float)((int)(21.0 * this.guiScaling)));
        int cardWidth = (int)(16.0 * this.guiScaling);
        int cardHeight = (int)(22.0 * this.guiScaling);
        int activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((double)(7 + battleControllerScale) * this.guiScaling)));
        int trainerXOffset = (int)((double)(this.playerIndex == 0 ? 20 : -34) * this.guiScaling);
        int myYOffset = (int)((double)(13 + battleControllerScale) * this.guiScaling);
        int oppYOffset = (int)((double)(23 + battleControllerScale) * this.guiScaling);
        if (battleControllerScale == 2) {
            activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((this.playerIndex == 0 ? -0.75 : 15.0) * this.guiScaling)));
            trainerXOffset = (int)((double)(this.playerIndex == 0 ? 26 : -42) * this.guiScaling);
            myYOffset = (int)((double)(this.playerIndex == 0 ? 8 : 15) * this.guiScaling);
            oppYOffset = (int)((double)(this.playerIndex == 0 ? 26 : 18) * this.guiScaling);
            if (this.controller.getDirection() == Direction.NORTH) {
                activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((this.playerIndex == 0 ? 3.5 : 12.0) * this.guiScaling)));
                trainerXOffset = (int)((double)(this.playerIndex == 0 ? 24 : -39) * this.guiScaling);
                myYOffset = (int)(12.0 * this.guiScaling);
                oppYOffset = (int)(22.0 * this.guiScaling);
            }
            if (this.controller.getDirection() == Direction.SOUTH) {
                activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((this.playerIndex == 0 ? 5.75 : 10.0) * this.guiScaling)));
                trainerXOffset = (int)((double)(this.playerIndex == 0 ? 21 : -36) * this.guiScaling);
                myYOffset = (int)((double)(this.playerIndex == 0 ? 14 : 12) * this.guiScaling);
                oppYOffset = (int)((double)(this.playerIndex == 0 ? 20 : 25) * this.guiScaling);
            }
            if (this.controller.getDirection() == Direction.EAST) {
                activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((this.playerIndex == 0 ? 0.75 : 15.0) * this.guiScaling)));
                trainerXOffset = (int)((double)(this.playerIndex == 0 ? 26 : -42) * this.guiScaling);
                myYOffset = (int)((double)(this.playerIndex == 0 ? 8 : 17) * this.guiScaling);
                oppYOffset = (int)((double)(this.playerIndex == 0 ? 28 : 18) * this.guiScaling);
            }
            if (this.controller.getDirection() == Direction.WEST) {
                activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((this.playerIndex == 0 ? -1.75 : 17.0) * this.guiScaling)));
                trainerXOffset = (int)((double)(this.playerIndex == 0 ? 28 : -44) * this.guiScaling);
                myYOffset = (int)((double)(this.playerIndex == 0 ? 12 : 15) * this.guiScaling);
                oppYOffset = (int)((double)(this.playerIndex == 0 ? 24 : 21) * this.guiScaling);
            }
        }
        if (battleControllerScale == 4) {
            activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((double)(this.playerIndex == 0 ? 3 : 13) * this.guiScaling)));
            oppYOffset = (int)((double)(this.playerIndex == 0 ? 22 : 25) * this.guiScaling);
            trainerXOffset = (int)((double)(this.playerIndex == 0 ? 24 : -39) * this.guiScaling);
            myYOffset = (int)((double)(this.playerIndex == 0 ? 15 : 11) * this.guiScaling);
            if (this.controller.getDirection() == Direction.SOUTH) {
                activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((double)(this.playerIndex == 0 ? 3 : 11) * this.guiScaling)));
            }
            if (this.controller.getDirection() == Direction.EAST || this.controller.getDirection() == Direction.WEST) {
                activeTargetXOffset = (int)(this.scaledWidth / 2.0f - (float)((int)((this.playerIndex == 0 ? -2.5 : 17.0) * this.guiScaling)));
                trainerXOffset = (int)((double)(this.playerIndex == 0 ? 29 : -44) * this.guiScaling);
                myYOffset = (int)((double)(this.playerIndex == 0 ? 10 : 15) * this.guiScaling);
                oppYOffset = (int)((double)(this.playerIndex == 0 ? 26 : 20) * this.guiScaling);
            }
        }
        this.myTargets.activeTarget.setWidth(cardWidth);
        this.myTargets.activeTarget.setHeight(cardHeight);
        this.myTargets.activeTarget.setX(activeTargetXOffset);
        this.myTargets.activeTarget.setY(centerY + myYOffset);
        this.oppTargets.activeTarget.setWidth(cardWidth);
        this.oppTargets.activeTarget.setHeight(cardHeight);
        this.oppTargets.activeTarget.setX(activeTargetXOffset);
        this.oppTargets.activeTarget.setY(centerY - oppYOffset);
        this.myTargets.trainerTarget.setWidth(cardWidth);
        this.myTargets.trainerTarget.setHeight(cardHeight);
        this.myTargets.trainerTarget.setX((int)(this.scaledWidth / 2.0f + (float)trainerXOffset));
        this.myTargets.trainerTarget.setY(centerY + myYOffset);
        this.oppTargets.trainerTarget.setWidth(cardWidth);
        this.oppTargets.trainerTarget.setHeight(cardHeight);
        this.oppTargets.trainerTarget.setX((int)(this.scaledWidth / 2.0f + (float)trainerXOffset));
        this.oppTargets.trainerTarget.setY(centerY - oppYOffset);
        for (i = 0; i < 5; ++i) {
            float myCardX = (float)(this.playerIndex == 0 ? 43 : 44) - (float)i * 18.0f;
            float oppCardX = (float)(this.playerIndex == 0 ? 43 : 44) - (float)(4 - i) * 18.0f;
            int myCardY = centerY + (int)((double)(this.playerIndex == 0 ? 50 : 49) * this.guiScaling);
            int oppCardY = centerY - (int)(59.0 * this.guiScaling);
            if (battleControllerScale == 1) {
                if (this.controller.getDirection() == Direction.EAST) {
                    myCardY = centerY + (int)(49.0 * this.guiScaling);
                }
                if (this.controller.getDirection() == Direction.SOUTH) {
                    myCardX = (float)(this.playerIndex == 0 ? 44 : 43) - (float)i * 18.0f;
                    oppCardX = (float)(this.playerIndex == 0 ? 44 : 43) - (float)(4 - i) * 18.0f;
                }
            }
            if (battleControllerScale == 2) {
                myCardX = (float)(this.playerIndex == 0 ? 37 : 51) - (float)i * 18.0f;
                oppCardX = (float)(this.playerIndex == 0 ? 37 : 51) - (float)(4 - i) * 18.0f;
                myCardY = centerY + (int)((double)(this.playerIndex == 0 ? 45 : 53) * this.guiScaling);
                oppCardY = centerY - (int)((double)(this.playerIndex == 0 ? 63 : 55) * this.guiScaling);
                if (this.controller.getDirection() == Direction.NORTH) {
                    myCardX = (float)(this.playerIndex == 0 ? 39 : 48) - (float)i * 18.0f;
                    oppCardX = (float)(this.playerIndex == 0 ? 39 : 48) - (float)(4 - i) * 18.0f;
                    myCardY = centerY + (int)(49.0 * this.guiScaling);
                    oppCardY = centerY - (int)(59.0 * this.guiScaling);
                }
                if (this.controller.getDirection() == Direction.SOUTH) {
                    myCardX = (float)(this.playerIndex == 0 ? 42 : 46) - (float)i * 18.0f;
                    oppCardX = (float)(this.playerIndex == 0 ? 42 : 46) - (float)(4 - i) * 18.0f;
                    myCardY = centerY + (int)((double)(this.playerIndex == 0 ? 51 : 47) * this.guiScaling);
                    oppCardY = centerY - (int)((double)(this.playerIndex == 0 ? 56 : 61) * this.guiScaling);
                }
                if (this.controller.getDirection() == Direction.WEST) {
                    myCardX = (float)(this.playerIndex == 0 ? 34 : 53) - (float)i * 18.0f;
                    oppCardX = (float)(this.playerIndex == 0 ? 34 : 53) - (float)(4 - i) * 18.0f;
                    myCardY = centerY + (int)((double)(this.playerIndex == 0 ? 46 : 51) * this.guiScaling);
                    oppCardY = centerY - (int)((double)(this.playerIndex == 0 ? 61 : 57) * this.guiScaling);
                }
            }
            if (battleControllerScale == 4) {
                myCardX = (float)(this.playerIndex == 0 ? 39 : 48) - (float)i * 18.0f;
                oppCardX = (float)(this.playerIndex == 0 ? 39 : 48) - (float)(4 - i) * 18.0f;
                myCardY = centerY + (int)((double)(this.playerIndex == 0 ? 52 : 46) * this.guiScaling);
                oppCardY = centerY - (int)((double)(this.playerIndex == 0 ? 55 : 62) * this.guiScaling);
                if (this.controller.getDirection() == Direction.EAST || this.controller.getDirection() == Direction.WEST) {
                    myCardX = (float)(this.playerIndex == 0 ? 34 : 53) - (float)i * 18.0f;
                    oppCardX = (float)(this.playerIndex == 0 ? 34 : 53) - (float)(4 - i) * 18.0f;
                    myCardY = centerY + (int)((double)(this.playerIndex == 0 ? 46 : 51) * this.guiScaling);
                    oppCardY = centerY - (int)((double)(this.playerIndex == 0 ? 61 : 56) * this.guiScaling);
                }
            }
            this.myTargets.benchTargets[i].setWidth(cardWidth);
            this.myTargets.benchTargets[i].setHeight(cardHeight);
            this.myTargets.benchTargets[i].setX((int)(this.scaledWidth / 2.0f - (float)((int)((double)myCardX * this.guiScaling))));
            this.myTargets.benchTargets[i].setY(myCardY);
            this.oppTargets.benchTargets[i].setWidth(cardWidth);
            this.oppTargets.benchTargets[i].setHeight(cardHeight);
            this.oppTargets.benchTargets[i].setX((int)(this.scaledWidth / 2.0f - (float)((int)((double)oppCardX * this.guiScaling))));
            this.oppTargets.benchTargets[i].setY(oppCardY);
        }
        this.buttonAbility.setWidth(111);
        this.buttonAbility.setHeight(12);
        this.buttonAbility.setX((int)((double)(this.scaledWidth / 2.0f) + 150.0 * this.guiScaling - 56.0));
        this.buttonAbility.setY((int)((double)(this.scaledHeight / 2.0f) + -1.0 * this.guiScaling));
        for (i = 0; i < 3; ++i) {
            this.buttonAttacks[i].setWidth(111);
        }
        this.buttonEndTurn.field_230690_l_ = (int)(this.scaledWidth - 10.0f - (float)this.buttonEndTurn.func_230998_h_());
        this.buttonEndTurn.field_230691_m_ = 10;
        this.buttonDiscard.field_230690_l_ = (int)(this.scaledWidth - 10.0f - (float)this.buttonDiscard.func_230998_h_() - 10.0f - (float)this.buttonEndTurn.func_230998_h_());
        this.buttonDiscard.field_230691_m_ = 10;
        this.buttonRetreat.setWidth(43);
        this.buttonRetreat.setHeight(20);
        this.buttonRetreat.setX((int)((double)(this.scaledWidth / 2.0f) + 150.0 * this.guiScaling + 12.0));
        this.buttonRetreat.setY((int)((double)(this.scaledHeight / 2.0f) + 0.0 * this.guiScaling + 56.0));
    }

    private void updateCameraPositions(Direction facing) {
        CameraEntity cam = new CameraEntity((World)this.field_230706_i_.field_71441_e);
        this.field_230706_i_.execute(() -> {
            ClientProxy.camera = cam;
            int rotation = 90;
            double x0 = 0.0;
            double x1 = 0.0;
            double z0 = 0.0;
            double z1 = 0.0;
            float scale = this.controller.getScale();
            double scaleX = 0.0;
            double scaleZ = 0.0;
            switch (facing) {
                case EAST: {
                    rotation = 0;
                    x1 = 6.3;
                    x0 = 6.3;
                    scaleX = scale > 1.0f ? (double)scale * 0.25 : 0.0;
                    scaleZ = scale > 1.0f ? (double)(-scale) : 0.0;
                    z0 = -1.2;
                    z1 = 2.2;
                    break;
                }
                case NORTH: {
                    rotation = -90;
                    x0 = -1.15;
                    x1 = 2.15;
                    z1 = -5.25;
                    z0 = -5.25;
                    scaleX = scale > 1.0f ? (double)(-scale) * 0.5 : 0.0;
                    scaleZ = scale > 1.0f ? (double)(-scale) * 0.5 : 0.0;
                    break;
                }
                case SOUTH: {
                    rotation = 90;
                    x0 = 2.15;
                    x1 = -1.15;
                    z1 = 6.2;
                    z0 = 6.2;
                    scaleX = scale > 1.0f ? (double)(-scale) * 0.25 : 0.0;
                    scaleZ = scale > 1.0f ? (double)(-scale) * 0.25 : 0.0;
                    break;
                }
                case WEST: {
                    rotation = 180;
                    x1 = -5.3;
                    x0 = -5.3;
                    z0 = 2.1;
                    z1 = -1.2;
                    scaleX = scale > 1.0f ? (double)(-scale) : 0.0;
                    scaleZ = scale > 1.0f ? (double)scale * 0.25 : 0.0;
                }
            }
            double y = (double)this.controller.func_174877_v().func_177956_o() + 13.5 * (double)scale;
            if (this.playerIndex == 0) {
                ClientProxy.camera.func_70080_a((double)this.controller.func_174877_v().func_177958_n() + x0 * (double)scale + scaleX, y, (double)this.controller.func_174877_v().func_177952_p() + z0 * (double)scale + scaleZ, rotation, 90.0f);
                ClientProxy.camera.func_70034_d(rotation);
            } else if (this.playerIndex == 1) {
                ClientProxy.camera.func_70080_a((double)this.controller.func_174877_v().func_177958_n() + x1 * (double)scale + scaleX, y, (double)this.controller.func_174877_v().func_177952_p() + z1 * (double)scale + scaleZ, rotation + 180, 90.0f);
                ClientProxy.camera.func_70034_d((float)rotation + 180.0f);
            }
            this.field_230706_i_.field_71441_e.func_217411_a(ClientProxy.camera.func_145782_y(), (Entity)ClientProxy.camera);
        });
        this.ticks = 1;
    }

    private boolean handleActiveCards(double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean handled = false;
        if (this.draggingCard == null) {
            if (me.getActiveCard() != null && this.myTargets.activeTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(me.getActiveCard(), true, BoardLocation.Active, 0, true);
                handled = true;
            }
            if (opp.getActiveCard() != null && !opp.getActiveCard().getData().isFaceDown() && this.oppTargets.activeTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(opp.getActiveCard(), false, BoardLocation.Active, 0, true);
                handled = true;
            }
        }
        return handled;
    }

    private boolean handleBenchCards(double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean handled = false;
        if (this.draggingCard == null) {
            for (int bench = 0; bench < 5; ++bench) {
                if (me.getBenchCards()[bench] != null && this.myTargets.benchTargets[bench].isInside(mouseX, mouseY)) {
                    this.isCardInSelectMode = true;
                    this.inspectingCard.set(me.getBenchCards()[bench], true, BoardLocation.Bench, bench, true);
                    handled = true;
                }
                if (opp.getBenchCards()[bench] == null || opp.getBenchCards()[bench].getData().isFaceDown() || !this.oppTargets.benchTargets[bench].isInside(mouseX, mouseY)) continue;
                this.isCardInSelectMode = true;
                this.inspectingCard.set(opp.getBenchCards()[bench], false, BoardLocation.Bench, bench, true);
                handled = true;
            }
        }
        return handled;
    }

    private boolean handleTrainerCards(double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean handled = false;
        if (this.draggingCard == null) {
            if (me.getTrainerCard() != null && this.myTargets.trainerTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(me.getTrainerCard(), true, BoardLocation.Trainer, 0, true);
                handled = true;
            }
            if (opp.getTrainerCard() != null && this.oppTargets.trainerTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(opp.getTrainerCard(), false, BoardLocation.Trainer, 0, true);
                handled = true;
            }
        }
        return handled;
    }

    private void drawAbilityButtons(MatrixStack matrix, int mouseX, int mouseY, PlayerClientMyState me) {
        PokemonCardState card;
        if (this.inspectingCard.isMine() && (this.inspectingCard.getLocation() == BoardLocation.Active || this.inspectingCard.getLocation() == BoardLocation.Bench) && me.getActiveCard() != null && this.controller.getClient().isMyTurn() && this.isCardInSelectMode && this.inspectingCard.getCard() instanceof PokemonCardState && (card = (PokemonCardState)this.inspectingCard.getCard()).getAbility() != null && card.getAbility().getEffect() != null && !card.getAbility().getEffect().isPassive()) {
            int stroke;
            boolean isEnabled = card.getAbility().getEffect().isEnabled(card, this.controller.getClient());
            int color = this.buttonAbility.isInside(mouseX, mouseY) ? 0x22FFFF00 : 0x11FFFFFF;
            int n = stroke = this.buttonAbility.isInside(mouseX, mouseY) ? -256 : -570425345;
            if (isEnabled && this.buttonAbility.isInside(mouseX, mouseY)) {
                this.drawRectWithBorder(matrix, this.buttonAbility.getX() - 1, this.buttonAbility.getY() - 1, this.buttonAbility.getX() + this.buttonAbility.getWidth() + 1, this.buttonAbility.getY() + this.buttonAbility.getHeight() + 1, color, stroke);
            } else if (isEnabled) {
                this.drawRectWithBorder(matrix, this.buttonAbility.getX(), this.buttonAbility.getY(), this.buttonAbility.getX() + this.buttonAbility.getWidth(), this.buttonAbility.getY() + this.buttonAbility.getHeight(), color, stroke);
            }
            if (this.buttonAbility.isInside(mouseX, mouseY)) {
                String error = null;
                if (!isEnabled) {
                    error = "Can't activate power";
                }
                if (error != null) {
                    ScreenHelper.drawString(matrix, error, mouseX + 4, mouseY + 4, 0xFF0000);
                }
            }
        }
    }

    private boolean handleAbilityButton(int playerIndex, boolean isMyTurn, double mouseX, double mouseY, PlayerClientMyState me) {
        PokemonCardState card;
        boolean handled = false;
        if (this.draggingCard == null && this.inspectingCard.isMine() && (this.inspectingCard.getLocation() == BoardLocation.Active || this.inspectingCard.getLocation() == BoardLocation.Bench) && me.getActiveCard() != null && isMyTurn && this.isCardInSelectMode && this.inspectingCard.getCard() instanceof PokemonCardState && (card = (PokemonCardState)this.inspectingCard.getCard()).getAbility() != null && card.getAbility().getEffect() != null && !card.getAbility().getEffect().isPassive() && card.getAbility().getEffect().isEnabled(card, this.controller.getClient()) && this.buttonAbility.isInside(mouseX, mouseY)) {
            NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.func_174877_v(), PhaseAction.UseAbility, playerIndex, this.inspectingCard.getLocation().ordinal(), this.inspectingCard.getLocationSubIndex()));
            handled = true;
        }
        return handled;
    }

    private void drawAttackButtons(MatrixStack matrix, int mouseX, int mouseY, PlayerClientMyState me) {
        if (me != null && this.controller != null && this.controller.getClient() != null && this.controller.getClient().isMyTurn() && this.inspectingCard != null && (this.inspectingCard.isPickingAttack() || this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && me.getActiveCard() != null && this.isCardInSelectMode)) {
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            for (int i = 0; i < pokemon.getAttacksStatus().length; ++i) {
                int stroke;
                PokemonAttackStatus attack = pokemon.getAttacksStatus()[i];
                CardAttack data = attack.getData();
                boolean enoughEnergy = LogicHelper.isEnoughEnergy(data, pokemon.getAttachments(), pokemon);
                boolean isEnabled = this.inspectingCard.isPickingAttack() || !attack.isDisabled() && enoughEnergy && !isAsleep && !isParalyzed && me.getAvailableActions().isCanAttack();
                TargetScreen button = this.buttonAttacks[i];
                int color = button.isInside(mouseX, mouseY) ? 0x22FFFF00 : 0x11FFFFFF;
                int n = stroke = button.isInside(mouseX, mouseY) ? -256 : -570425345;
                if (isEnabled && button.isInside(mouseX, mouseY)) {
                    this.drawRectWithBorder(matrix, button.getX() - 1, button.getY() - 1, button.getX() + button.getWidth() + 1, button.getY() + button.getHeight() + 1, color, stroke);
                } else if (isEnabled) {
                    this.drawRectWithBorder(matrix, button.getX(), button.getY(), button.getX() + button.getWidth(), button.getY() + button.getHeight(), color, stroke);
                }
                if (!button.isInside(mouseX, mouseY)) continue;
                if (this.inspectingCard.isPickingAttack()) {
                    ScreenHelper.drawString(matrix, "Choose this attack!", mouseX + 4, mouseY + 4, 0xFFFFFF);
                    continue;
                }
                String error = null;
                if (attack.isDisabled()) {
                    error = "This attack is disabled!";
                } else if (!me.getAvailableActions().isCanAttack()) {
                    error = "You can't attack this turn.";
                } else if (isAsleep) {
                    error = new TranslationTextComponent(pokemon.getData().getName().toLowerCase()).getString() + " is asleep!";
                } else if (isParalyzed) {
                    error = new TranslationTextComponent(pokemon.getData().getName().toLowerCase()).getString() + " is paralyzed!";
                } else if (!enoughEnergy) {
                    error = "Not enough energy!";
                }
                if (error == null) continue;
                ScreenHelper.drawString(matrix, error, mouseX - ScreenHelper.getStringWidth(error), mouseY + 8, 0xFF0000, true);
            }
        }
    }

    private boolean handleAttackButtons(int playerIndex, boolean isMyTurn, double mouseX, double mouseY, PlayerClientMyState me) {
        boolean handled = false;
        if (isMyTurn && this.draggingCard == null && (this.inspectingCard.isPickingAttack() || this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && me.getActiveCard() != null && this.isCardInSelectMode && me.getAvailableActions().isCanAttack())) {
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            if (this.inspectingCard.isPickingAttack() || !isAsleep && !isParalyzed) {
                for (int i = 0; i < pokemon.getAttacksStatus().length; ++i) {
                    boolean enoughEnergy;
                    PokemonAttackStatus attackStatus = pokemon.getAttacksStatus()[i];
                    CardAttack cardAttack = attackStatus.getData();
                    if (cardAttack == null || attackStatus.isDisabled() || !this.buttonAttacks[i].isInside(mouseX, mouseY)) continue;
                    boolean bl = enoughEnergy = this.inspectingCard.isPickingAttack() || LogicHelper.isEnoughEnergy(cardAttack, pokemon.getAttachments(), pokemon);
                    if (!enoughEnergy) continue;
                    NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.func_174877_v(), PhaseAction.UseAttack, playerIndex, i, 0));
                    handled = true;
                }
            }
        }
        return handled;
    }

    private boolean drawRetreatButton(MatrixStack matrix, int mouseX, int mouseY, PlayerClientMyState me, PlayerClientOpponentState opp, boolean isMyTurn) {
        boolean clickedSomething = false;
        if (this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && me.getActiveCard() != null && isMyTurn && this.isCardInSelectMode) {
            int stroke;
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            int retreatCost = Math.max(0, me.getActiveCard().getRetreatCost() + LogicHelper.getCostModifier(me, opp));
            boolean enoughEnergy = LogicHelper.isEnoughEnergy(retreatCost, pokemon.getAttachments(), pokemon);
            boolean hasBench = LogicHelper.hasBench(me);
            boolean canRetreat = me.getActiveCard().canRetreat();
            boolean enabled = hasBench && enoughEnergy && !isAsleep && !isParalyzed && me.getAvailableActions().isCanRetreatActive() && canRetreat;
            int color = this.buttonRetreat.isInside(mouseX, mouseY) ? 0x22FFFF00 : 0x11FFFFFF;
            int n = stroke = this.buttonRetreat.isInside(mouseX, mouseY) ? -256 : -570425345;
            if (enabled && this.buttonRetreat.isInside(mouseX, mouseY)) {
                this.drawRectWithBorder(matrix, this.buttonRetreat.getX() - 1, this.buttonRetreat.getY() - 1, this.buttonRetreat.getX() + this.buttonRetreat.getWidth() + 1, this.buttonRetreat.getY() + this.buttonRetreat.getHeight() + 1, color, stroke);
            } else if (enabled) {
                this.drawRectWithBorder(matrix, this.buttonRetreat.getX(), this.buttonRetreat.getY(), this.buttonRetreat.getX() + this.buttonRetreat.getWidth(), this.buttonRetreat.getY() + this.buttonRetreat.getHeight(), color, stroke);
            }
            if (this.buttonRetreat.isInside(mouseX, mouseY)) {
                String error = null;
                if (!me.getAvailableActions().isCanRetreatActive()) {
                    error = "You can't retreat this turn";
                } else if (isAsleep) {
                    error = new TranslationTextComponent(pokemon.getData().getName().toLowerCase()) + " is asleep";
                } else if (isParalyzed) {
                    error = new TranslationTextComponent(pokemon.getData().getName().toLowerCase()) + " is paralyzed";
                } else if (!hasBench) {
                    error = "You have no card in bench";
                } else if (!enoughEnergy) {
                    error = "You don't have enough energy";
                } else if (!canRetreat) {
                    error = "This can't retreat";
                }
                if (error != null) {
                    ScreenHelper.drawString(matrix, error, mouseX - ScreenHelper.getStringWidth(error), mouseY, 0xFF0000);
                }
            }
        }
        return clickedSomething;
    }

    private boolean handleRetreatButton(boolean isMyTurn, double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean clickedSomething = false;
        if (this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && this.draggingCard == null && this.buttonRetreat.isInside(mouseX, mouseY) && isMyTurn && this.isCardInSelectMode) {
            boolean enabled;
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            int cost = me.getActiveCard().getRetreatCost();
            cost = Math.max(0, cost + LogicHelper.getCostModifier(me, opp));
            boolean enoughEnergy = LogicHelper.isEnoughEnergy(cost, pokemon.getAttachments(), pokemon);
            boolean hasBench = LogicHelper.hasBench(me);
            boolean canRetreat = me.getActiveCard().canRetreat();
            boolean bl = enabled = hasBench && enoughEnergy && !isAsleep && !isParalyzed && me.getAvailableActions().isCanRetreatActive() && canRetreat;
            if (enabled) {
                CardSelectorState state = new CardSelectorState(cost, cost, true, CardSelectorDisplay.Discard, true);
                state.setCardList(LogicHelper.getEnergiesFromList(me.getActiveCard().getAttachments()));
                this.cardSelector.set(CardSelectorPurpose.StartRetreating, state);
                if (cost == 0) {
                    this.cardSelector.acceptSelection();
                }
                clickedSomething = true;
            }
        }
        return clickedSomething;
    }

    private void checkAndDrawActionHint(MatrixStack matrix, ImmutableCard card, boolean isMyTurn, int mouseX, int mouseY, PlayerClientMyState me, int playerIndex) {
        CardType ct = card.getCardType();
        int c = 10;
        int color = 65280;
        int errorColor = 0xFF0000;
        if (this.controller.getClient().getGamePhase() == GamePhase.PreMatch || isMyTurn) {
            for (int bench = 0; bench < 5; ++bench) {
                if (!this.myTargets.benchTargets[bench].isInside(mouseX, mouseY)) continue;
                PokemonCardState benchCard = me.getBenchCards()[bench];
                this.showPokemonCardActionHint(matrix, mouseX, mouseY, ct, c, color, errorColor, me, benchCard, false);
            }
            if (this.myTargets.activeTarget.isInside(mouseX, mouseY)) {
                PokemonCardState activeCard = me.getActiveCard();
                this.showPokemonCardActionHint(matrix, mouseX, mouseY, ct, c, color, errorColor, me, activeCard, true);
            } else if ((double)mouseY < (double)this.scaledHeight / 1.5 && ct == CardType.TRAINER && card.getEffect() != null) {
                if (me.getAvailableActions().isCanPlayTrainer() && card.getEffect().canPlay(this.controller.getClient())) {
                    ScreenHelper.drawString(matrix, "Play Trainer card", mouseX + c, mouseY + c, color, true);
                } else {
                    ScreenHelper.drawString(matrix, "Cannot play Trainer card now", mouseX + c, mouseY + c, errorColor, true);
                }
            }
        } else {
            ScreenHelper.drawString(matrix, "Not your turn yet!", mouseX, mouseY, errorColor, true);
        }
    }

    private void releaseDraggingCard(int mouseX, int mouseY, List<ImmutableCard> myHand, int playerIndex) {
        ImmutableCard card = this.draggingCard.getCard().getData();
        for (int benchIndex = 0; benchIndex < 5; ++benchIndex) {
            if (!this.myTargets.benchTargets[benchIndex].isInside(mouseX, mouseY)) continue;
            NetworkHelper.sendToServer(new UpdateServerCardRecordPacket(this.controller.func_174877_v(), BoardLocation.Bench, benchIndex, card, this.draggingCard.locationSubIndex));
        }
        if (this.myTargets.activeTarget.isInside(mouseX, mouseY)) {
            NetworkHelper.sendToServer(new UpdateServerCardRecordPacket(this.controller.func_174877_v(), BoardLocation.Active, 0, card, this.draggingCard.locationSubIndex));
        } else if ((double)mouseY < (double)this.scaledHeight / 1.5) {
            NetworkHelper.sendToServer(new UpdateServerCardRecordPacket(this.controller.func_174877_v(), BoardLocation.Trainer, 0, card, this.draggingCard.locationSubIndex));
        }
        this.draggingCard = null;
    }

    private void drawDraggingCard(MatrixStack matrix, int mouseX, int mouseY, CommonCardState card, PlayerClientMyState me, PlayerClientOpponentState opp) {
        matrix.func_227860_a_();
        float scaleFactor = 0.35f;
        matrix.func_227861_a_((double)mouseX, (double)mouseY, 0.0);
        matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        CardRenderingHelper.drawCard(matrix, card, 0, 0, 0.0f, 1.0f, 0.0, me, opp);
        matrix.func_227862_a_(-scaleFactor, -scaleFactor, -scaleFactor);
        matrix.func_227865_b_();
    }

    private boolean handleCardInHand(double mouseX, double mouseY, int mouseButton, List<ImmutableCard> myHand, List<ImmutableCard> oppHand, int handIndex, boolean isMe) {
        boolean handled = false;
        if (isMe) {
            ImmutableCard card = myHand.get(handIndex);
            if ((this.draggingCard == null || this.isCardInSelectMode) && this.myTargets.handTargets.size() > handIndex && this.myTargets.handTargets.get(handIndex).isInside(mouseX, mouseY) && (mouseButton == 0 || mouseButton == 1)) {
                CommonCardState cardState;
                CommonCardState commonCardState = cardState = card.isPokemonCard() ? new PokemonCardState(card, this.controller.getClient().getTurnCount()) : new CommonCardState(card);
                if (mouseButton == 1) {
                    this.inspectingCard.set(cardState, true, BoardLocation.Hand, handIndex, true);
                    handled = true;
                }
                if (mouseButton == 0) {
                    this.draggingCard = new CardWithLocation(cardState, true, BoardLocation.Hand, handIndex);
                }
                this.isCardInSelectMode = false;
            }
        } else {
            ImmutableCard card = oppHand.get(handIndex);
            if ((this.draggingCard == null || this.isCardInSelectMode) && this.oppTargets.handTargets.size() > handIndex && this.oppTargets.handTargets.get(handIndex).isInside(mouseX, mouseY) && card != null && !card.isFaceDown()) {
                CommonCardState cardState = card.isPokemonCard() ? new PokemonCardState(card, this.controller.getClient().getTurnCount()) : new CommonCardState(card);
                this.inspectingCard.set(cardState, true, BoardLocation.Hand, handIndex, true);
                handled = true;
                this.isCardInSelectMode = false;
            }
        }
        return handled;
    }

    private void drawHand(MatrixStack matrix, int mouseX, int mouseY, List<ImmutableCard> myHand, List<ImmutableCard> oppHand) {
        TargetScreen handTarget;
        ImmutableCard card;
        int i;
        for (i = 0; i < myHand.size(); ++i) {
            if (i >= myHand.size()) {
                return;
            }
            if (i >= this.myTargets.handTargets.size()) {
                return;
            }
            card = myHand.get(i);
            handTarget = this.myTargets.handTargets.get(i);
            int offsetY = 0;
            float opacity = 1.0f;
            if ((this.draggingCard == null || this.isCardInSelectMode) && handTarget.isInside(mouseX, mouseY)) {
                offsetY = -15;
            }
            if (this.draggingCard != null && this.draggingCard.getLocation() == BoardLocation.Hand && this.draggingCard.getLocationSubIndex() == i) {
                opacity = 0.3f;
            }
            matrix.func_227860_a_();
            float scaleFactor = (float)(0.25 * this.guiScaling);
            matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            if (card == null || card.isFaceDown()) {
                CardRenderingHelper.drawCardBack(matrix, (int)((float)(handTarget.getX() * 2) / scaleFactor) + 100, (int)((float)(handTarget.getY() * 2) / scaleFactor) + offsetY + 150, 0.0f, this.controller.getClient().getMe());
            } else {
                CardRenderingHelper.drawCard(matrix, new CommonCardState(card), (int)((float)(handTarget.getX() * 2) / scaleFactor) + 100, (int)((float)(handTarget.getY() * 2) / scaleFactor) + offsetY + 150, 0.0f, opacity, 0.0, null, null);
            }
            matrix.func_227862_a_(-scaleFactor, -scaleFactor, -scaleFactor);
            matrix.func_227865_b_();
        }
        for (i = 0; i < oppHand.size(); ++i) {
            if (i >= oppHand.size()) {
                return;
            }
            if (i >= this.oppTargets.handTargets.size()) break;
            card = oppHand.get(i);
            handTarget = this.oppTargets.handTargets.get(i);
            matrix.func_227860_a_();
            float scaleFactor = (float)(0.25 * this.guiScaling);
            matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            int offsetY = 0;
            float opacity = 1.0f;
            if ((this.draggingCard == null || this.isCardInSelectMode) && handTarget.isInside(mouseX, mouseY)) {
                opacity = 0.5f;
                offsetY = 15;
            }
            if (card == null || card.isFaceDown()) {
                CardRenderingHelper.drawCardBack(matrix, (int)((float)(handTarget.getX() * 2) / scaleFactor) + 100, (int)((float)(handTarget.getY() * 2) / scaleFactor) + offsetY + 150, 0.0f, this.controller.getClient().getOpponent());
            } else {
                CardRenderingHelper.drawCard(matrix, new CommonCardState(card), (int)((float)(handTarget.getX() * 2) / scaleFactor) + 100, (int)((float)(handTarget.getY() * 2) / scaleFactor) + offsetY + 150, 0.0f, opacity, 180.0, null, null);
            }
            matrix.func_227862_a_(-scaleFactor, -scaleFactor, -scaleFactor);
            matrix.func_227865_b_();
        }
    }

    private void showPokemonCardActionHint(MatrixStack matrix, int mouseX, int mouseY, CardType ct, int c, int color, int errorColor, PlayerClientMyState me, PokemonCardState card, boolean isActive) {
        if (ct == CardType.BASIC && card == null) {
            if (isActive) {
                ScreenHelper.drawString(matrix, "Play Active Pokemon", mouseX + c, mouseY + c, color, true);
            } else if (me.getActiveCard() != null) {
                ScreenHelper.drawString(matrix, "Play Benched Pokemon", mouseX + c, mouseY + c, color, true);
            } else {
                ScreenHelper.drawString(matrix, "Must play Active Pokemon first", mouseX + c, mouseY + c, errorColor, true);
            }
        } else if (ct == CardType.ENERGY && card != null) {
            if (me.getAvailableActions().isCanPlayEnergy()) {
                ScreenHelper.drawString(matrix, "Attach Energy", mouseX + c, mouseY + c, color, true);
            } else {
                ScreenHelper.drawString(matrix, "Cannot attach Energy this turn", mouseX + c, mouseY + c, errorColor, true);
            }
        } else if (ct == CardType.TOOL && card != null) {
            ScreenHelper.drawString(matrix, "Attach Tool", mouseX + c, mouseY + c, color, true);
        } else if ((ct == CardType.STAGE1 || ct == CardType.STAGE2) && card != null && this.draggingCard.getCard().getData().getPreviousEvolutionDexID() == card.getData().getPokemonID()) {
            if (LogicHelper.canEvolve(card.getTurn(), this.controller.getClient().getTurnCount())) {
                if (this.controller.getClient().isDisablingEvolution(card)) {
                    ScreenHelper.drawString(matrix, "Disabled by an power!", mouseX + c, mouseY + c, errorColor, true);
                } else {
                    ScreenHelper.drawString(matrix, "Evolve", mouseX + c, mouseY + c, color, true);
                }
            } else {
                ScreenHelper.drawString(matrix, "Cannot Evolve this turn!", mouseX + c, mouseY + c, errorColor, true);
            }
        } else if (ct == CardType.LVLX && this.draggingCard.getCard().getData().getPokemonID() == card.getData().getPokemonID()) {
            if (LogicHelper.canEvolve(card.getTurn(), this.controller.getClient().getTurnCount())) {
                ScreenHelper.drawString(matrix, "Level Up", mouseX + c, mouseY + c, color, true);
            } else {
                ScreenHelper.drawString(matrix, "Cannot Level Up this turn!", mouseX + c, mouseY + c, errorColor, true);
            }
        } else if (ct == CardType.MEGA && this.draggingCard.getCard().getData().getPokemonID() == card.getData().getPokemonID()) {
            if (LogicHelper.canEvolve(card.getTurn(), this.controller.getClient().getTurnCount())) {
                ScreenHelper.drawString(matrix, "Mega Evolve", mouseX + c, mouseY + c, color, true);
            } else {
                ScreenHelper.drawString(matrix, "Cannot Mega Evolve this turn!", mouseX + c, mouseY + c, errorColor, true);
            }
        } else {
            ScreenHelper.drawString(matrix, "Can't put that here", mouseX + c, mouseY + c, errorColor, true);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231152_a_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        super.func_231152_a_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.func_231160_c_();
        this.updateLocalDimensions();
        this.updateTargetPositions();
    }
}

