/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.commands.SubcommandBase;
import com.pixelmonmod.tcg.commands.TCGEndBattleCommand;
import com.pixelmonmod.tcg.commands.TCGGiveCommand;
import com.pixelmonmod.tcg.commands.TCGHelpCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.item.DyeColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TCGCommand
extends PixelCommand {
    private static final List<String> BASE_COMMANDS = Arrays.asList("card", "deck", "pack", "essence", "cardback", "coin", "jar");
    private TCGHelpCommand TCGHelpCommand = new TCGHelpCommand();
    private TCGGiveCommand TCGGiveCommand = new TCGGiveCommand();
    private TCGEndBattleCommand TCGEndBattleCommand = new TCGEndBattleCommand();

    public TCGCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "tcg", "", 0);
    }

    @Override
    public String getName() {
        return "tcg";
    }

    @Override
    public String getUsage(CommandSource sender) {
        StringBuilder builder = new StringBuilder("/tcg Pixelmon TCG related commands\n/tcg help: get help\n/tcg endbattle: end battle");
        if (this.TCGGiveCommand.canUse(sender)) {
            builder.append("/tcg give: give players cards or theme decks");
        }
        return builder.toString();
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length == 0) {
            SubcommandBase.sendMessage(sender, TextFormatting.GOLD, "Pixelmon TCG 9.1.12");
            SubcommandBase.sendMessage(sender, TextFormatting.RESET, "/tcg help: how to play");
            return;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.TCGHelpCommand.processCommand(sender, args);
                break;
            }
            case "give": {
                this.TCGGiveCommand.processCommand(sender, args);
                break;
            }
            case "endbattle": {
                this.TCGEndBattleCommand.processCommand(sender, args);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, @Nullable BlockPos pos) {
        ArrayList completions;
        block51: {
            block52: {
                void var8_46;
                completions = Lists.newArrayList();
                if (args.length == 1) {
                    completions.addAll(Arrays.asList("give", "help", "endbattle", "essencereset"));
                    return completions;
                }
                if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("give")) {
                        if (args[1].isEmpty() || args[1].equalsIgnoreCase(" ")) {
                            completions.addAll(BASE_COMMANDS);
                        } else {
                            for (String s : BASE_COMMANDS) {
                                if (!s.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))) continue;
                                completions.add(s);
                            }
                        }
                    }
                    if (args[0].equalsIgnoreCase("essencereset")) {
                        String[] opts;
                        if (args[1].isEmpty()) {
                            opts = ServerLifecycleHooks.getCurrentServer().func_71213_z();
                            completions.addAll(Arrays.asList(opts));
                        } else {
                            for (String string : opts = ServerLifecycleHooks.getCurrentServer().func_71213_z()) {
                                if (!string.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))) continue;
                                completions.add(string);
                            }
                        }
                    }
                    return completions;
                }
                if (args.length == 3) {
                    if (args[0].equalsIgnoreCase("give")) {
                        if (args[2].isEmpty() || args[2].equalsIgnoreCase(" ")) {
                            completions.addAll(Arrays.asList(ServerLifecycleHooks.getCurrentServer().func_71213_z()));
                        } else {
                            String[] opts;
                            for (String string : opts = ServerLifecycleHooks.getCurrentServer().func_71213_z()) {
                                if (!string.toLowerCase(Locale.ROOT).startsWith(args[2].toLowerCase(Locale.ROOT))) continue;
                                completions.add(string);
                            }
                        }
                    }
                    return completions;
                }
                if (args.length == 4) {
                    if (args[0].equalsIgnoreCase("give")) {
                        if (args[3].isEmpty() || args[3].equals(" ")) {
                            List<Object> cardsets;
                            if (args[1].equalsIgnoreCase("card")) {
                                List<ImmutableCard> cards = Cards.getAll();
                                for (ImmutableCard immutableCard : cards) {
                                    completions.add(immutableCard.getCode());
                                }
                            }
                            if (args[1].equalsIgnoreCase("deck")) {
                                cardsets = ThemeDecks.getAll();
                                for (ThemeDeck themeDeck : cardsets) {
                                    completions.add(themeDeck.getName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("pack")) {
                                cardsets = CardSets.getAll();
                                for (CardSet cardSet : cardsets) {
                                    if (!cardSet.hasPack()) continue;
                                    completions.add(cardSet.getName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("jar")) {
                                for (int i = 0; i <= 100; ++i) {
                                    completions.add(String.valueOf(i));
                                }
                            }
                            if (args[1].equalsIgnoreCase("essence")) {
                                Energy[] energies = Energy.values();
                                for (Iterator<Object> iterator : energies) {
                                    if (iterator == Energy.RAINBOW) continue;
                                    completions.add(((Energy)((Object)iterator)).getUnlocalizedName());
                                }
                                completions.add("all");
                            }
                            if (args[1].equalsIgnoreCase("cardback")) {
                                CardBack[] cardbacks = CardBacks.getAll().toArray(new CardBack[0]);
                                for (Iterator<Object> iterator : cardbacks) {
                                    completions.add(((CardBack)((Object)iterator)).getName().replace(" ", "_"));
                                }
                            }
                            if (args[1].equalsIgnoreCase("coin")) {
                                Coin[] coins = Coins.getAll().toArray(new Coin[0]);
                                for (Iterator<Object> iterator : coins) {
                                    completions.add(((Coin)((Object)iterator)).getName().replace(" ", "_"));
                                }
                            }
                        } else {
                            if (args[1].equalsIgnoreCase("card")) {
                                List<ImmutableCard> cards = Cards.getAll();
                                for (ImmutableCard immutableCard : cards) {
                                    if (!immutableCard.getName().startsWith(args[3])) continue;
                                    completions.add(immutableCard.getName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("deck")) {
                                List<ThemeDeck> cardsets = ThemeDecks.getAll();
                                for (ThemeDeck themeDeck : cardsets) {
                                    if (!themeDeck.getName().startsWith(args[3])) continue;
                                    completions.add(themeDeck.getName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("jar")) {
                                for (int i = 0; i <= 100; ++i) {
                                    if (!String.valueOf(i).startsWith(args[3])) continue;
                                    completions.add(String.valueOf(i));
                                }
                            }
                            if (args[1].equalsIgnoreCase("pack")) {
                                List<CardSet> cardsets = CardSets.getAll();
                                for (CardSet cardSet : cardsets) {
                                    if (!cardSet.getName().startsWith(args[3]) || !cardSet.hasPack()) continue;
                                    completions.add(cardSet.getName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("pack")) {
                                Energy[] energies = Energy.values();
                                for (Iterator<Object> iterator : energies) {
                                    if (!((Energy)((Object)iterator)).getUnlocalizedName().startsWith(args[3])) continue;
                                    completions.add(((Energy)((Object)iterator)).getUnlocalizedName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("cardback")) {
                                CardBack[] cardbacks = CardBacks.getAll().toArray(new CardBack[0]);
                                for (Iterator<Object> iterator : cardbacks) {
                                    if (!((CardBack)((Object)iterator)).getName().startsWith(args[3])) continue;
                                    completions.add(((CardBack)((Object)iterator)).getName());
                                }
                            }
                            if (args[1].equalsIgnoreCase("coin")) {
                                Coin[] coins = Coins.getAll().toArray(new Coin[0]);
                                for (Iterator<Object> iterator : coins) {
                                    if (!((Coin)((Object)iterator)).getName().startsWith(args[3])) continue;
                                    completions.add(((Coin)((Object)iterator)).getName());
                                }
                            }
                        }
                    }
                    return completions;
                }
                if (args.length != 5 || !args[0].equalsIgnoreCase("give")) break block51;
                if (!args[4].isEmpty() && !args[4].equals(" ")) break block52;
                if (!args[1].equalsIgnoreCase("jar")) break block51;
                DyeColor[] dyeColorArray = DyeColor.values();
                int n = dyeColorArray.length;
                boolean bl = false;
                while (var8_46 < n) {
                    DyeColor value = dyeColorArray[var8_46];
                    completions.add(value.func_176762_d());
                    ++var8_46;
                }
                break block51;
            }
            if (args[1].equalsIgnoreCase("jar")) {
                void var8_48;
                DyeColor[] dyeColorArray = DyeColor.values();
                int n = dyeColorArray.length;
                boolean bl = false;
                while (var8_48 < n) {
                    DyeColor value = dyeColorArray[var8_48];
                    if (value.func_176762_d().startsWith(args[4])) {
                        completions.add(value.func_176762_d());
                    }
                    ++var8_48;
                }
            }
        }
        return completions;
    }
}

