/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;

public class DevolveEffect
extends BaseAttackEffect {
    private static final String CODE = "DEVOLVE";
    private int mode;

    public DevolveEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (parameters.isEmpty()) {
            return this.getCardSelectorStateForEvolutionCard(new GameClientState(server));
        }
        return null;
    }

    private CardSelectorState getCardSelectorStateForEvolutionCard(GameClientState client) {
        CardSelectorState selectorState = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "card.BS72.effect.selector.choosepokemon");
        PlayerClientMyState player = client.getMe();
        if (player.getActiveCard().getData().isEvolution() && this.hasLowerEvolution(player.getActiveCard().getData().getPreviousEvolutionDexID(), player.getActiveCard().getAttachments())) {
            selectorState.getCardList().add(new CardWithLocation(player.getActiveCard(), true, BoardLocation.Active, 0));
        }
        for (int i = 0; i < player.getBenchCards().length; ++i) {
            if (player.getBenchCards()[i] == null || !player.getBenchCards()[i].getData().isEvolution() || !this.hasLowerEvolution(player.getBenchCards()[i].getData().getPreviousEvolutionDexID(), player.getBenchCards()[i].getAttachments())) continue;
            selectorState.getCardList().add(new CardWithLocation(player.getBenchCards()[i], true, BoardLocation.Bench, 0));
        }
        PlayerClientOpponentState opp = client.getOpponent();
        if (opp.getActiveCard().getData().isEvolution() && this.hasLowerEvolution(opp.getActiveCard().getData().getPreviousEvolutionDexID(), opp.getActiveCard().getAttachments())) {
            selectorState.getCardList().add(new CardWithLocation(opp.getActiveCard(), false, BoardLocation.Active, 0));
        }
        for (int i = 0; i < opp.getBenchCards().length; ++i) {
            if (opp.getBenchCards()[i] == null || !opp.getBenchCards()[i].getData().isEvolution() || !this.hasLowerEvolution(opp.getBenchCards()[i].getData().getPreviousEvolutionDexID(), opp.getBenchCards()[i].getAttachments())) continue;
            selectorState.getCardList().add(new CardWithLocation(opp.getBenchCards()[i], false, BoardLocation.Bench, 0));
        }
        return selectorState;
    }

    private boolean hasLowerEvolution(int pokemonId, List<CommonCardState> attachments) {
        return this.getLowerEvolution(pokemonId, attachments) != null;
    }

    private PokemonCardState getLowerEvolution(int pokemonId, List<CommonCardState> attachments) {
        for (CommonCardState attachment : attachments) {
            if (!(attachment instanceof PokemonCardState) || attachment.isEnergyEquivalence() || attachment.getData().getPokemonID() != pokemonId) continue;
            return (PokemonCardState)attachment;
        }
        return null;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        return !parameters.isEmpty() || this.getCardSelectorStateForEvolutionCard(new GameClientState(server)).getCardList().isEmpty();
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        for (PlayerServerState player : server.getPlayers()) {
            PokemonCardState prevEvo;
            PokemonCardState active = player.getActiveCard();
            if (parameters.contains(active) && (prevEvo = this.getLowerEvolution(active.getData().getPreviousEvolutionDexID(), active.getAttachments())) != null) {
                PokemonCardState newCard = new PokemonCardState(prevEvo.getData(), server.getCurrentTurn());
                newCard.getAttachments().addAll(active.getAttachments());
                newCard.getAttachments().remove(prevEvo);
                newCard.setStatus(active.getStatus());
                player.getHand().add(active.getData());
                player.setActiveCard(newCard);
                active.getStatus().getConditions().clear();
                return;
            }
            for (int i = 0; i < player.getBenchCards().length; ++i) {
                PokemonCardState prevEvo2;
                PokemonCardState cycle = player.getBenchCards()[i];
                if (!parameters.contains(cycle) || (prevEvo2 = this.getLowerEvolution(player.getBenchCards()[i].getData().getPreviousEvolutionDexID(), player.getBenchCards()[i].getAttachments())) == null) continue;
                PokemonCardState newCard = new PokemonCardState(prevEvo2.getData(), server.getCurrentTurn());
                newCard.getAttachments().addAll(player.getBenchCards()[i].getAttachments());
                newCard.getAttachments().remove(prevEvo2);
                newCard.setStatus(player.getBenchCards()[i].getStatus());
                player.getHand().add(player.getBenchCards()[i].getData());
                player.getBenchCards()[i] = newCard;
                player.getBenchCards()[i].getStatus().getConditions().clear();
                return;
            }
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.mode = Integer.parseInt(args[1]);
        return super.parse(args);
    }
}

