/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.DelayEffect;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class HardenEffect
extends BaseAttackEffect {
    private static final String CODE = "HARDEN";
    private int amount;

    public HardenEffect() {
        super(CODE);
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        server.addDelayEffect(new DelayEffect(this, attack, card, server.getTurnCount() + 1));
    }

    @Override
    public int modifyDamage(int damage, PokemonCardState pokemon, GameServerState server) {
        if (server.getPlayer(server.getNextTurn()).getActiveCard() != pokemon || damage > this.amount) {
            return damage;
        }
        return 0;
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.amount = Integer.parseInt(args[1]);
        return super.parse(args);
    }
}

