/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class ThunderstormEffect
extends BaseAttackEffect {
    private static final String CODE = "THUNDERSTORM";
    private int benchDamage;
    private int selfDamage;

    public ThunderstormEffect() {
        super(CODE);
    }

    @Override
    public List<CoinSide> flipCoin(List<CoinSide> currentResult, PokemonCardState pokemon, GameServerState server) {
        for (PokemonCardState benchPokemon : server.getPlayer(server.getNextTurn()).getBenchCards()) {
            if (benchPokemon == null) continue;
            currentResult.add(CoinSide.getRandom());
        }
        return currentResult;
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        PlayerServerState oppPlayer = server.getPlayer(server.getNextTurn());
        int counter = 0;
        int tails = 0;
        for (PokemonCardState pokemon : oppPlayer.getBenchCards()) {
            if (pokemon == null) continue;
            if (server.getCoinFlip().getResults().get(counter) == CoinSide.Head) {
                pokemon.addDamage(card, this.benchDamage, server);
            } else {
                ++tails;
            }
            ++counter;
        }
        card.addDamage(card, tails * this.selfDamage, server);
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.benchDamage = Integer.parseInt(args[1]);
        this.selfDamage = Integer.parseInt(args[2]);
        return super.parse(args);
    }
}

