/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.tcg.api.accessors.CardAttacks;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class PokemonAttackStatus {
    public static final int INFINITE_TURN_COUNT = 1000000;
    private CardAttack cardAttack;
    private boolean isDisabled;
    private int disabledTurnCountLeft;
    private int damageBonus;
    private int damageBonusCountLeft;
    private BaseAttackEffect temporaryEffect;
    private String temporaryEffectText;
    private int damage;
    private boolean isMissed;

    public PokemonAttackStatus(CardAttack cardAttack) {
        this.cardAttack = cardAttack;
        this.resetDamage();
    }

    public PokemonAttackStatus(PacketBuffer buf) {
        this.cardAttack = CardAttacks.get(buf.func_218666_n());
        this.isDisabled = buf.readBoolean();
        this.disabledTurnCountLeft = buf.readInt();
        this.damageBonus = buf.readInt();
        this.damageBonusCountLeft = buf.readInt();
        if (buf.readBoolean()) {
            this.temporaryEffectText = buf.func_218666_n();
        }
    }

    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.cardAttack.getID());
        buf.writeBoolean(this.isDisabled);
        buf.writeInt(this.disabledTurnCountLeft);
        buf.writeInt(this.damageBonus);
        buf.writeInt(this.damageBonusCountLeft);
        buf.writeBoolean(this.temporaryEffectText != null);
        if (this.temporaryEffectText != null) {
            buf.func_180714_a(this.temporaryEffectText);
        }
    }

    public CardAttack getData() {
        return this.cardAttack;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void disable(int turnCount) {
        if (this.isDisabled) {
            if (this.disabledTurnCountLeft != 1000000 && this.disabledTurnCountLeft < turnCount) {
                this.disabledTurnCountLeft = turnCount;
            }
        } else {
            this.isDisabled = true;
            this.disabledTurnCountLeft = turnCount;
        }
    }

    public void enable() {
        this.isDisabled = false;
        this.disabledTurnCountLeft = 0;
    }

    public int getDisabledTurnCountLeft() {
        return this.disabledTurnCountLeft;
    }

    public void reduceTurnCount() {
        if (this.disabledTurnCountLeft > 0) {
            --this.disabledTurnCountLeft;
        }
        if (this.disabledTurnCountLeft == 0 && this.isDisabled) {
            this.isDisabled = false;
        }
        if (this.damageBonusCountLeft > 0) {
            --this.damageBonusCountLeft;
        }
        if (this.damageBonusCountLeft == 0) {
            this.damageBonus = 0;
        }
        this.isMissed = false;
    }

    public int getDamage() {
        return this.damage + this.damageBonus;
    }

    public void setDamage(int damage) {
        this.damage = Math.max(0, damage);
    }

    public void resetDamage() {
        this.damage = this.cardAttack.getDamage();
    }

    public int getDamageBonus() {
        return this.damageBonus;
    }

    public int getDamageBonusCountLeft() {
        return this.damageBonusCountLeft;
    }

    public void setDamageBonus(int damageBonus, int damageBonusCountLeft) {
        this.damageBonus = damageBonus;
        this.damageBonusCountLeft = damageBonusCountLeft;
    }

    public BaseAttackEffect getTemporaryEffect() {
        return this.temporaryEffect;
    }

    public String getTemporaryEffectText() {
        return this.temporaryEffectText;
    }

    public void setTemporaryEffect(BaseAttackEffect temporaryEffect, String effectText) {
        this.temporaryEffect = temporaryEffect;
        this.temporaryEffectText = effectText;
    }

    public boolean isMissed() {
        return this.isMissed;
    }

    public void setMissed(boolean missed) {
        this.isMissed = missed;
    }

    public boolean hasDescription() {
        return StringUtils.isNotBlank((CharSequence)this.cardAttack.getText()) || StringUtils.isNotBlank((CharSequence)this.temporaryEffectText);
    }

    public ITextComponent getLocalizedDescription() {
        StringTextComponent text = new StringTextComponent("");
        if (StringUtils.isNotBlank((CharSequence)this.cardAttack.getText())) {
            text.func_230529_a_((ITextComponent)new TranslationTextComponent(this.cardAttack.getText().toLowerCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.temporaryEffectText)) {
            text.func_230529_a_((ITextComponent)new TranslationTextComponent(this.temporaryEffectText.toLowerCase())).func_240702_b_(" " + text);
        }
        return text;
    }
}

