/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class PokeFlute
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        boolean hasBench = false;
        for (PokemonCardState card : client.getOpponent().getBenchCards()) {
            if (card != null) continue;
            hasBench = true;
            break;
        }
        if (!hasBench) {
            return false;
        }
        for (ImmutableCard card : client.getOpponent().getDiscardPile()) {
            if (card.getCardType() != CardType.BASIC) continue;
            return true;
        }
        return false;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false);
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        for (int i = 0; i < opp.getDiscardPile().size(); ++i) {
            ImmutableCard card = opp.getDiscardPile().get(i);
            if (card.getCardType() != CardType.BASIC) continue;
            selector.getCardList().add(new CardWithLocation(new CommonCardState(card), false, BoardLocation.DiscardPile, i));
        }
        return selector;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() == 1;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        CommonCardState card = trainer.getParameters().get(0);
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        for (int i = 0; i < opp.getBenchCards().length; ++i) {
            if (opp.getBenchCards()[i] != null) continue;
            opp.getBenchCards()[i] = new PokemonCardState(card.getData(), server.getTurnCount());
            opp.getDiscardPile().remove(card.getData());
            break;
        }
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

